/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.types.JetType;

public class CharValue
extends IntegerValueConstant<Character> {
    public CharValue(char value, boolean canBeUsedInAnnotations, boolean pure, boolean usesVariableAsConstant) {
        super(Character.valueOf(value), canBeUsedInAnnotations, pure, usesVariableAsConstant);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        return kotlinBuiltIns.getCharType();
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitCharValue(this, data2);
    }

    public String toString() {
        return String.format("\\u%04X ('%s')", ((Character)this.value).charValue(), CharValue.getPrintablePart(((Character)this.value).charValue()));
    }

    private static String getPrintablePart(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        return CharValue.isPrintableUnicode(c) ? Character.toString(c) : "?";
    }

    private static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }
}

