/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.types.Approximation;
import kotlin.reflect.jvm.internal.impl.types.DelegatingType;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.Flexibility$$TImpl;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeDelegation;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.NullAwareness;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypesPackage$flexibleTypes$dc65222b;
import kotlin.reflect.jvm.internal.impl.types.checker.JetTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegatingFlexibleType
extends DelegatingType
implements NullAwareness,
Flexibility,
FlexibleTypeDelegation,
Approximation {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final JetType delegateType;
    @NotNull
    private final JetType lowerBound;
    @NotNull
    private final JetType upperBound;
    @NotNull
    private final FlexibleTypeCapabilities extraCapabilities;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(DelegatingFlexibleType.class);
        OBJECT$ = Companion = kotlin.reflect.jvm.internal.impl.types.DelegatingFlexibleType$Companion.access$init$0();
    }

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@JetValueParameter(name="capabilityClass") @NotNull Class<T> capabilityClass) {
        Intrinsics.checkParameterIsNotNull(capabilityClass, (String)"capabilityClass");
        T t = this.getExtraCapabilities().getCapability(capabilityClass, this, this);
        if (t == null) {
            t = super.getCapability(capabilityClass);
        }
        return t;
    }

    @Override
    @NotNull
    public JetType makeNullableAsSpecified(@JetValueParameter(name="nullable") boolean nullable2) {
        JetType jetType = TypeUtils.makeNullableAsSpecified(this.getLowerBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"TypeUtils.makeNullableAs\u2026ied(lowerBound, nullable)");
        JetType jetType2 = TypeUtils.makeNullableAsSpecified(this.getUpperBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType2, (String)"TypeUtils.makeNullableAs\u2026ied(upperBound, nullable)");
        return Companion.create(jetType, jetType2, this.getExtraCapabilities());
    }

    @Override
    public boolean computeIsNullable() {
        return this.getDelegateType().isMarkedNullable();
    }

    @Override
    public boolean isMarkedNullable() {
        NullAwareness nullAwareness = this.getCapability(NullAwareness.class);
        if (nullAwareness == null) {
            Intrinsics.throwNpe();
        }
        return nullAwareness.computeIsNullable();
    }

    @Override
    @Nullable
    public Approximation.Info approximateToExpectedType(@JetValueParameter(name="expectedType") @NotNull JetType expectedType, @JetValueParameter(name="dataFlowExtras") @NotNull Approximation.DataFlowExtras dataFlowExtras) {
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowExtras, (String)"dataFlowExtras");
        if (JetTypeChecker.DEFAULT.isSubtypeOf(this.getUpperBound(), expectedType)) {
            return null;
        }
        if (!dataFlowExtras.getCanBeNull() && JetTypeChecker.DEFAULT.isSubtypeOf(TypeUtils.makeNotNullable(this.getUpperBound()), expectedType)) {
            return null;
        }
        return new Approximation.Info(this, expectedType, dataFlowExtras.getPresentableText());
    }

    @Override
    @NotNull
    public JetType getDelegateType() {
        return this.delegateType;
    }

    @Override
    @NotNull
    protected JetType getDelegate() {
        FlexibleTypeDelegation flexibleTypeDelegation = this.getCapability(FlexibleTypeDelegation.class);
        if (flexibleTypeDelegation == null) {
            Intrinsics.throwNpe();
        }
        return flexibleTypeDelegation.getDelegateType();
    }

    @Override
    @NotNull
    public String toString() {
        return "('" + this.getLowerBound() + "'..'" + this.getUpperBound() + "')";
    }

    @Override
    @NotNull
    public JetType getLowerBound() {
        return this.lowerBound;
    }

    @Override
    @NotNull
    public JetType getUpperBound() {
        return this.upperBound;
    }

    @Override
    @NotNull
    public FlexibleTypeCapabilities getExtraCapabilities() {
        return this.extraCapabilities;
    }

    protected DelegatingFlexibleType(@JetValueParameter(name="lowerBound") @NotNull JetType lowerBound, @JetValueParameter(name="upperBound") @NotNull JetType upperBound, @JetValueParameter(name="extraCapabilities") @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        Intrinsics.checkParameterIsNotNull((Object)extraCapabilities, (String)"extraCapabilities");
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.extraCapabilities = extraCapabilities;
        if (KotlinPackage.getASSERTIONS_ENABLED()) {
            boolean value;
            boolean bl = !TypesPackage$flexibleTypes$dc65222b.isFlexible(this.getLowerBound());
            if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
                String message = "Lower bound of a flexible type can not be flexible: " + this.getLowerBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            value = !TypesPackage$flexibleTypes$dc65222b.isFlexible(this.getUpperBound());
            if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
                String message = "Upper bound of a flexible type can not be flexible: " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            value = Intrinsics.areEqual((Object)this.getLowerBound(), (Object)this.getUpperBound()) ^ true;
            if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
                String message = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            value = JetTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
            if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
                String message = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
        }
        this.delegateType = this.getLowerBound();
    }

    @Override
    @NotNull
    public JetType getSubTypeRepresentative() {
        return Flexibility$$TImpl.getSubTypeRepresentative(this);
    }

    @Override
    @NotNull
    public JetType getSuperTypeRepresentative() {
        return Flexibility$$TImpl.getSuperTypeRepresentative(this);
    }

    @Override
    public boolean sameTypeConstructor(@JetValueParameter(name="type") @NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return Flexibility$$TImpl.sameTypeConstructor(this, type2);
    }

    @platformStatic
    @NotNull
    public static final JetType create(@JetValueParameter(name="lowerBound") @NotNull JetType lowerBound, @JetValueParameter(name="upperBound") @NotNull JetType upperBound, @JetValueParameter(name="extraCapabilities") @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        Intrinsics.checkParameterIsNotNull((Object)extraCapabilities, (String)"extraCapabilities");
        return Companion.create(lowerBound, upperBound, extraCapabilities);
    }

    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @platformStatic
        @NotNull
        public final JetType create(@JetValueParameter(name="lowerBound") @NotNull JetType lowerBound, @JetValueParameter(name="upperBound") @NotNull JetType upperBound, @JetValueParameter(name="extraCapabilities") @NotNull FlexibleTypeCapabilities extraCapabilities) {
            Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
            Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
            Intrinsics.checkParameterIsNotNull((Object)extraCapabilities, (String)"extraCapabilities");
            if (Intrinsics.areEqual((Object)lowerBound, (Object)upperBound)) {
                return lowerBound;
            }
            return new DelegatingFlexibleType(lowerBound, upperBound, extraCapabilities);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$0() {
            return new Companion();
        }
    }
}

