/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.io.InputStream;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.SerializedResourcePaths;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataProvider;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceLoadingClassDataFinder
implements ClassDataFinder {
    public static final /* synthetic */ KClass $kotlinClass;
    private final PackageFragmentProvider packageFragmentProvider;
    private final SerializedResourcePaths serializedResourcePaths;
    private final Function1<? super String, ? extends InputStream> loadResource;

    static {
        $kotlinClass = Reflection.createKotlinClass(ResourceLoadingClassDataFinder.class);
    }

    @Override
    @Nullable
    public ClassDataProvider findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.getPackageFqName()");
        Object object = KotlinPackage.singleOrNull(this.packageFragmentProvider.getPackageFragments(fqName2));
        if (!(object instanceof DeserializedPackageFragment)) {
            object = null;
        }
        DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)object;
        if (deserializedPackageFragment == null) {
            return null;
        }
        DeserializedPackageFragment packageFragment = deserializedPackageFragment;
        InputStream inputStream = (InputStream)this.loadResource.invoke((Object)this.serializedResourcePaths.getClassMetadataPath(classId));
        if (inputStream == null) {
            return null;
        }
        InputStream stream = inputStream;
        ClassData classData = new ClassData(packageFragment.getNameResolver(), ProtoBuf.Class.parseFrom(stream, this.serializedResourcePaths.getExtensionRegistry()));
        return new ClassDataProvider(classData, null, 2, null);
    }

    public ResourceLoadingClassDataFinder(@NotNull PackageFragmentProvider packageFragmentProvider, @NotNull SerializedResourcePaths serializedResourcePaths, @NotNull Function1<? super String, ? extends InputStream> loadResource) {
        Intrinsics.checkParameterIsNotNull((Object)packageFragmentProvider, (String)"packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull((Object)serializedResourcePaths, (String)"serializedResourcePaths");
        Intrinsics.checkParameterIsNotNull(loadResource, (String)"loadResource");
        this.packageFragmentProvider = packageFragmentProvider;
        this.serializedResourcePaths = serializedResourcePaths;
        this.loadResource = loadResource;
    }
}

