/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kotlin.reflect.jvm.internal.impl.load.kotlin.reflect

import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns
import kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleParameters
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl
import kotlin.reflect.jvm.internal.impl.load.java.components.*
import kotlin.reflect.jvm.internal.impl.load.java.lazy.JavaResolverComponents
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaPackageFragmentProvider
import kotlin.reflect.jvm.internal.impl.load.java.lazy.SingleModuleClassResolver
import kotlin.reflect.jvm.internal.impl.load.java.reflect.ReflectJavaClassFinder
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPropertyInitializerEvaluator
import kotlin.reflect.jvm.internal.impl.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializationComponentsForJava
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver
import kotlin.reflect.jvm.internal.impl.load.kotlin.JavaClassDataFinder
import kotlin.reflect.jvm.internal.impl.name.Name
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JavaDescriptorResolver
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.LocalClassResolver
import kotlin.reflect.jvm.internal.impl.storage.LockBasedStorageManager

public class RuntimeModuleData private constructor(public val deserialization: DeserializationComponents, val packageFacadeProvider: RuntimePackagePartProvider) {
    public val module: ModuleDescriptor get() = deserialization.moduleDescriptor
    public val localClassResolver: LocalClassResolver get() = deserialization.localClassResolver

    companion object {
        public fun create(classLoader: ClassLoader): RuntimeModuleData {
            val storageManager = LockBasedStorageManager()
            val module = ModuleDescriptorImpl(Name.special("<runtime module for $classLoader>"), storageManager,
                                              ModuleParameters(listOf(), JavaToKotlinClassMap.INSTANCE))

            val reflectKotlinClassFinder = ReflectKotlinClassFinder(classLoader)
            val deserializedDescriptorResolver = DeserializedDescriptorResolver(RuntimeErrorReporter)
            val singleModuleClassResolver = SingleModuleClassResolver()
            val runtimePackageFacadeProvider = RuntimePackagePartProvider(classLoader)
            val globalJavaResolverContext = JavaResolverComponents(
                    storageManager, ReflectJavaClassFinder(classLoader), reflectKotlinClassFinder, deserializedDescriptorResolver,
                    ExternalAnnotationResolver.EMPTY, ExternalSignatureResolver.DO_NOTHING, RuntimeErrorReporter, JavaResolverCache.EMPTY,
                    JavaPropertyInitializerEvaluator.DoNothing, SamConversionResolver, RuntimeSourceElementFactory, singleModuleClassResolver,
                    runtimePackageFacadeProvider
            )

            val lazyJavaPackageFragmentProvider =
                    LazyJavaPackageFragmentProvider(globalJavaResolverContext, module, ReflectionTypes(module))
            val javaDescriptorResolver = JavaDescriptorResolver(lazyJavaPackageFragmentProvider, module)
            val javaClassDataFinder = JavaClassDataFinder(reflectKotlinClassFinder, deserializedDescriptorResolver)
            val binaryClassAnnotationAndConstantLoader = BinaryClassAnnotationAndConstantLoaderImpl(module, storageManager, reflectKotlinClassFinder, RuntimeErrorReporter)
            val deserializationComponentsForJava = DeserializationComponentsForJava(
                    storageManager, module, javaClassDataFinder, binaryClassAnnotationAndConstantLoader,
                    lazyJavaPackageFragmentProvider, RuntimeErrorReporter
            )
            singleModuleClassResolver.resolver = javaDescriptorResolver
            deserializedDescriptorResolver.setComponents(deserializationComponentsForJava)

            module.setDependencies(module, KotlinBuiltIns.getInstance().getBuiltInsModule())
            module.initialize(javaDescriptorResolver.packageFragmentProvider)

            return RuntimeModuleData(deserializationComponentsForJava.components, runtimePackageFacadeProvider)
        }
    }
}
