/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import kotlin.StringsKt;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

public final class JvmAbi {
    public static final BinaryVersion VERSION = BinaryVersion.create(1, 0, 0);
    public static final String DEFAULT_IMPLS_CLASS_NAME = "DefaultImpls";
    public static final String DEFAULT_IMPLS_SUFFIX = "$DefaultImpls";
    public static final String DEFAULT_PARAMS_IMPL_SUFFIX = "$default";
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final String SET_PREFIX = "set";
    public static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    public static final String DELEGATED_PROPERTIES_ARRAY_NAME = "$$delegatedProperties";
    public static final String ANNOTATED_PROPERTY_METHOD_NAME_SUFFIX = "$annotations";
    public static final String INSTANCE_FIELD = "INSTANCE";
    public static final String DEPRECATED_INSTANCE_FIELD = "INSTANCE$";
    public static final String DEFAULT_MODULE_NAME = "main";
    public static final ClassId REFLECTION_FACTORY_IMPL = ClassId.topLevel(new FqName("kotlin.reflect.jvm.internal.ReflectionFactoryImpl"));
    public static final String LOCAL_VARIABLE_NAME_PREFIX_INLINE_ARGUMENT = "$i$a$";
    public static final String LOCAL_VARIABLE_NAME_PREFIX_INLINE_FUNCTION = "$i$f$";

    @NotNull
    public static String getSyntheticMethodNameForAnnotatedProperty(@NotNull Name propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "kotlin/reflect/jvm/internal/impl/load/java/JvmAbi", "getSyntheticMethodNameForAnnotatedProperty"));
        }
        String string = propertyName.asString() + ANNOTATED_PROPERTY_METHOD_NAME_SUFFIX;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/java/JvmAbi", "getSyntheticMethodNameForAnnotatedProperty"));
        }
        return string;
    }

    public static boolean isGetterName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/load/java/JvmAbi", "isGetterName"));
        }
        return name.startsWith(GET_PREFIX) || name.startsWith(IS_PREFIX);
    }

    public static boolean isSetterName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/load/java/JvmAbi", "isSetterName"));
        }
        return name.startsWith(SET_PREFIX);
    }

    @NotNull
    public static String getterName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "kotlin/reflect/jvm/internal/impl/load/java/JvmAbi", "getterName"));
        }
        String string = JvmAbi.startsWithIsPrefix(propertyName) ? propertyName : GET_PREFIX + CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/java/JvmAbi", "getterName"));
        }
        return string;
    }

    @NotNull
    public static String setterName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "kotlin/reflect/jvm/internal/impl/load/java/JvmAbi", "setterName"));
        }
        String string = JvmAbi.startsWithIsPrefix(propertyName) ? SET_PREFIX + propertyName.substring(IS_PREFIX.length()) : SET_PREFIX + CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/java/JvmAbi", "setterName"));
        }
        return string;
    }

    public static boolean startsWithIsPrefix(String name) {
        if (!name.startsWith(IS_PREFIX)) {
            return false;
        }
        if (name.length() == IS_PREFIX.length()) {
            return false;
        }
        char c = name.charAt(IS_PREFIX.length());
        return 'a' > c || c > 'z';
    }

    @NotNull
    public static String sanitizeAsJavaIdentifier(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "kotlin/reflect/jvm/internal/impl/load/java/JvmAbi", "sanitizeAsJavaIdentifier"));
        }
        String string = StringsKt.replace((CharSequence)str, (Regex)StringsKt.toRegex((String)"[^\\p{L}\\p{Digit}]"), (String)"_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/java/JvmAbi", "sanitizeAsJavaIdentifier"));
        }
        return string;
    }
}

