/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.structure.reflect;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaAnnotationOwnerKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectJavaValueParameter
extends ReflectJavaElement
implements JavaValueParameter {
    private final ReflectJavaType returnType;
    private final Annotation[] annotations;
    private final String name;
    private final boolean isVararg;

    @NotNull
    public List<ReflectJavaAnnotation> getAnnotations() {
        return ReflectJavaAnnotationOwnerKt.getAnnotations(this.annotations);
    }

    @Override
    @Nullable
    public ReflectJavaAnnotation findAnnotation(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return ReflectJavaAnnotationOwnerKt.findAnnotation(this.annotations, fqName2);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return false;
    }

    @Override
    @Nullable
    public Name getName() {
        Name name;
        String string = this.name;
        if (string != null) {
            String $receiver = string;
            String p1 = $receiver;
            name = Name.guess(p1);
        } else {
            name = null;
        }
        return name;
    }

    @Override
    @NotNull
    public ReflectJavaType getType() {
        return this.returnType;
    }

    @Override
    public boolean isVararg() {
        return this.isVararg;
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + (this.isVararg ? "vararg " : "") + this.getName() + ": " + this.returnType;
    }

    public ReflectJavaValueParameter(@NotNull ReflectJavaType returnType2, @NotNull Annotation[] annotations2, @Nullable String name, boolean isVararg) {
        Intrinsics.checkParameterIsNotNull((Object)returnType2, (String)"returnType");
        Intrinsics.checkParameterIsNotNull((Object)annotations2, (String)"annotations");
        this.returnType = returnType2;
        this.annotations = annotations2;
        this.name = name;
        this.isVararg = isVararg;
    }
}

