/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.IndexedValue;
import kotlin.Sequence;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionsKt {
    @NotNull
    public static final <K, V> Map<K, V> valuesToMap(Sequence<? extends V> $receiver, @NotNull Function1<? super V, ? extends K> key) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        LinkedHashMap map2 = new LinkedHashMap();
        for (Object v : $receiver) {
            MapsKt.set((Map)map2, (Object)key.invoke(v), v);
        }
        return map2;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMap(Sequence<? extends K> $receiver, @NotNull Function1<? super K, ? extends V> value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (Object k : $receiver) {
            MapsKt.set((Map)map2, k, (Object)value.invoke(k));
        }
        return map2;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(Sequence<? extends K> $receiver, @NotNull Function1<? super K, ? extends V> value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (Object k : $receiver) {
            Object v = value.invoke(k);
            if (v == null) continue;
            MapsKt.set((Map)map2, k, (Object)v);
        }
        return map2;
    }

    @NotNull
    public static final <K, V> Map<K, V> valuesToMap(Iterable<? extends V> $receiver, @NotNull Function1<? super V, ? extends K> key) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        LinkedHashMap map2 = new LinkedHashMap();
        for (V v : $receiver) {
            MapsKt.set((Map)map2, (Object)key.invoke(v), v);
        }
        return map2;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMap(Iterable<? extends K> $receiver, @NotNull Function1<? super K, ? extends V> value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (K k : $receiver) {
            MapsKt.set((Map)map2, k, (Object)value.invoke(k));
        }
        return map2;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(Iterable<? extends K> $receiver, @NotNull Function1<? super K, ? extends V> value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (K k : $receiver) {
            Object v = value.invoke(k);
            if (v == null) continue;
            MapsKt.set((Map)map2, k, (Object)v);
        }
        return map2;
    }

    @NotNull
    public static final <K> Map<K, Integer> mapToIndex(Iterable<? extends K> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        LinkedHashMap map2 = new LinkedHashMap();
        for (IndexedValue indexedValue : kotlin.collections.CollectionsKt.withIndex($receiver)) {
            int index = indexedValue.component1();
            Object k = indexedValue.component2();
            MapsKt.set((Map)map2, (Object)k, (Object)index);
        }
        return map2;
    }

    @NotNull
    public static final <T, C extends Collection<? extends T>> C ifEmpty(C $receiver, @NotNull Function0<? extends C> body) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        return (C)($receiver.isEmpty() ? (Collection)body.invoke() : $receiver);
    }

    @NotNull
    public static final <T> T[] ifEmpty(T[] $receiver, @NotNull Function0<? extends T[]> body) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        return ArraysKt.isEmpty((Object[])$receiver) ? (Object[])body.invoke() : $receiver;
    }

    @NotNull
    public static final <T> List<T> emptyOrSingletonList(@Nullable T item) {
        return item == null ? kotlin.collections.CollectionsKt.listOf() : kotlin.collections.CollectionsKt.listOf(item);
    }

    public static final <T> void addIfNotNull(Collection<T> $receiver, @Nullable T t) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (t != null) {
            $receiver.add(t);
        }
    }

    @NotNull
    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1);
    }

    @NotNull
    public static final <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1);
    }

    @NotNull
    public static final <T> List<T> toReadOnlyList(Collection<? extends T> $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Collection<T> $receiver$iv = $receiver;
        switch ($receiver$iv.size()) {
            case 0: {
                list = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = kotlin.collections.CollectionsKt.listOf((Object)kotlin.collections.CollectionsKt.first((Iterable)$receiver));
                break;
            }
            default: {
                list = new ArrayList<T>($receiver);
            }
        }
        return list;
    }

    @NotNull
    public static final <T> List<T> singletonOrEmptyList(T $receiver) {
        return $receiver != null ? kotlin.collections.CollectionsKt.listOf($receiver) : kotlin.collections.CollectionsKt.emptyList();
    }

    @Nullable
    public static final <T> T removeLast(List<T> $receiver, @NotNull Function1<? super T, Boolean> condition) {
        int n;
        block1: {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
            List<T> $receiver$iv = $receiver;
            Iterator iterator2 = kotlin.collections.CollectionsKt.reversed((Iterable)((Iterable)kotlin.collections.CollectionsKt.getIndices((Collection)$receiver$iv))).iterator();
            while (iterator2.hasNext()) {
                int index$iv = ((Number)iterator2.next()).intValue();
                if (!((Boolean)condition.invoke($receiver$iv.get(index$iv))).booleanValue()) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int index = n;
        return index >= 0 ? (T)$receiver.remove(index) : null;
    }
}

