/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils.addToStdlib;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.utils.addToStdlib.AddToStdlibKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddToStdlibKt {
    private static final ConcurrentHashMap<Function0<?>, Object> constantMap = new ConcurrentHashMap();

    @NotNull
    public static final <T> List<T> singletonOrEmptyList(T $receiver) {
        List list;
        if ($receiver != null) {
            List<T> list2 = Collections.singletonList($receiver);
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.singletonList(this)");
        } else {
            List list3 = Collections.emptyList();
            list = list3;
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"Collections.emptyList()");
        }
        return list;
    }

    @NotNull
    public static final <T> List<T> singletonList(T $receiver) {
        List<T> list = Collections.singletonList($receiver);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.singletonList(this)");
        return list;
    }

    @NotNull
    public static final <T> Set<T> singletonOrEmptySet(T $receiver) {
        Set set;
        if ($receiver != null) {
            Set<T> set2 = Collections.singleton($receiver);
            set = set2;
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"Collections.singleton(this)");
        } else {
            Set set3 = Collections.emptySet();
            set = set3;
            Intrinsics.checkExpressionValueIsNotNull(set3, (String)"Collections.emptySet()");
        }
        return set;
    }

    private static final <T> T firstIsInstanceOrNull(Sequence<?> $receiver) {
        for (Object element : $receiver) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        return null;
    }

    private static final <T> T firstIsInstanceOrNull(Iterable<?> $receiver) {
        for (Object element : $receiver) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        return null;
    }

    private static final <T> T firstIsInstanceOrNull(Object[] $receiver) {
        for (int i = 0; i < $receiver.length; ++i) {
            Object element = $receiver[i];
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        return null;
    }

    private static final <T> T firstIsInstance(Sequence<?> $receiver) {
        for (Object element : $receiver) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        throw (Throwable)new NoSuchElementException("No element of given type found");
    }

    private static final <T> T firstIsInstance(Iterable<?> $receiver) {
        for (Object element : $receiver) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        throw (Throwable)new NoSuchElementException("No element of given type found");
    }

    private static final <T> T firstIsInstance(Object[] $receiver) {
        for (int i = 0; i < $receiver.length; ++i) {
            Object element = $receiver[i];
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        throw (Throwable)new NoSuchElementException("No element of given type found");
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> T lastIsInstanceOrNull(Iterable<?> $receiver) {
        T t;
        block5: {
            Iterable<?> iterable = $receiver;
            if (iterable instanceof List) {
                IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)((Collection)$receiver))));
                int n = intProgression.getFirst();
                int n2 = intProgression.getLast();
                int n3 = intProgression.getStep();
                int n4 = n;
                int n5 = n2;
                if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                    while (true) {
                        void i;
                        Object element = ((List)$receiver).get((int)i);
                        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                        if (element instanceof Object) {
                            return (T)element;
                        }
                        if (i == n2) break;
                        i += n3;
                    }
                }
                return null;
            }
            Iterable $receiver$iv = CollectionsKt.reversed($receiver);
            for (Object element$iv : $receiver$iv) {
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                if (!(element$iv instanceof Object)) continue;
                t = element$iv;
                break block5;
            }
            t = null;
        }
        return t;
    }

    @NotNull
    public static final <T> Sequence<T> sequenceOfLazyValues(Function0<? extends T> ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])elements), (Function1)sequenceOfLazyValues.1.INSTANCE);
    }

    @NotNull
    public static final <T1, T2> Pair<T2, T1> swap(Pair<? extends T1, ? extends T2> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return new Pair($receiver.getSecond(), $receiver.getFirst());
    }

    @Nullable
    public static final <T> T check(T $receiver, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        return (T)((Boolean)predicate.invoke($receiver) != false ? $receiver : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> T constant(@NotNull Function0<? extends T> calculator) {
        void value$iv;
        Function0<? extends T> key$iv;
        void $receiver$iv;
        Unit unit;
        Object message$iv;
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(calculator, (String)"calculator");
        Object cached = constantMap.get(calculator);
        if (cached != null) {
            Object object = cached;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)object;
        }
        Object[] $receiver$iv2 = calculator.getClass().getDeclaredFields();
        Object[] objectArray = $receiver$iv2;
        Collection collection = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            Field it = (Field)element$iv$iv;
            if (!((it.getModifiers() & 8) == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fields = (List)destination$iv$iv;
        boolean value$iv2 = fields.isEmpty();
        if (_Assertions.ENABLED) {
            if (!value$iv2) {
                message$iv = "No fields in the passed lambda expected but " + CollectionsKt.joinToString$default((Iterable)fields, null, null, null, (int)0, null, null, (int)63, null) + " found";
                throw (Throwable)((Object)new AssertionError(message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Object value = calculator.invoke();
        Map $i$a$1 = constantMap;
        message$iv = value;
        $receiver$iv.put(key$iv, value$iv);
        return (T)value;
    }

    @Nullable
    public static final Integer indexOfOrNull(String $receiver, char c, int startIndex, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int index = StringsKt.indexOf((CharSequence)$receiver, (char)c, (int)startIndex, (boolean)ignoreCase);
        return index >= 0 ? Integer.valueOf(index) : (Integer)null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Integer indexOfOrNull$default(String string, char c, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOfOrNull");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return AddToStdlibKt.indexOfOrNull(string, c, n, bl);
    }

    @Nullable
    public static final Integer lastIndexOfOrNull(String $receiver, char c, int startIndex, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int index = StringsKt.lastIndexOf((CharSequence)$receiver, (char)c, (int)startIndex, (boolean)ignoreCase);
        return index >= 0 ? Integer.valueOf(index) : (Integer)null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Integer lastIndexOfOrNull$default(String string, char c, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lastIndexOfOrNull");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return AddToStdlibKt.lastIndexOfOrNull(string, c, n, bl);
    }

    @Nullable
    public static final <T, R> R firstNotNullResult(Iterable<? extends T> $receiver, @NotNull Function1<? super T, ? extends R> transform) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(transform, (String)"transform");
        for (T element : $receiver) {
            Object result = transform.invoke(element);
            if (result == null) continue;
            return (R)result;
        }
        return null;
    }
}

