/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class AnnotationDeserializer {
    private final ConstantValueFactory factory;
    private final ModuleDescriptor module;

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        ConstructorDescriptor constructor;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        ClassId classId = nameResolver.getClassId(proto.getId());
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nameResolver.getClassId(proto.id)");
        ClassDescriptor annotationClass = this.resolveClass(classId);
        Map arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass) && (constructor = (ConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)annotationClass.getConstructors())) != null) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Pair<ValueParameterDescriptor, ConstantValue<?>> pair;
            void var13_14;
            void destination$iv$iv2;
            Collection $receiver$iv$iv2;
            Iterable $receiver$iv;
            Iterable iterable = constructor.getValueParameters();
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
            void var8_9 = $receiver$iv;
            Map map2 = new LinkedHashMap(capacity$iv22);
            for (Object element$iv$iv : $receiver$iv$iv2) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                var13_14 = destination$iv$iv2;
                pair = it.getName();
                var13_14.put(pair, element$iv$iv);
            }
            void parameterByName = destination$iv$iv2;
            $receiver$iv = proto.getArgumentList();
            Iterable capacity$iv22 = $receiver$iv;
            $receiver$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Object element$iv$iv;
                element$iv$iv = (ProtoBuf.Annotation.Argument)item$iv$iv;
                var13_14 = destination$iv$iv;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                pair = this.resolveArgument((ProtoBuf.Annotation.Argument)v1, (Map<Name, ? extends ValueParameterDescriptor>)parameterByName, nameResolver);
                var13_14.add(pair);
            }
            arguments2 = MapsKt.toMap((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<ValueParameterDescriptor, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(nameResolver.getName(proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameter.type");
        ProtoBuf.Annotation.Argument.Value value = proto.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"proto.value");
        return new Pair((Object)parameter, this.resolveValue(kotlinType, value, nameResolver));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        v0 = value.getType();
        if (v0 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                v1 = this.factory.createByteValue((byte)value.getIntValue());
                break;
            }
            case 2: {
                v1 = this.factory.createCharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                v1 = this.factory.createShortValue((short)value.getIntValue());
                break;
            }
            case 4: {
                v1 = this.factory.createIntValue((int)value.getIntValue());
                break;
            }
            case 5: {
                v1 = this.factory.createLongValue(value.getIntValue());
                break;
            }
            case 6: {
                v1 = this.factory.createFloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                v1 = this.factory.createDoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                v1 = this.factory.createBooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                v2 = nameResolver.getString(value.getStringValue());
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"nameResolver.getString(value.stringValue)");
                v1 = this.factory.createStringValue(v2);
                break;
            }
            case 10: {
                var4_4 = "Class literal annotation arguments are not supported yet (" + nameResolver.getClassId(value.getClassId()) + ")";
                throw (Throwable)new IllegalStateException(message$iv.toString());
            }
            case 11: {
                v3 = nameResolver.getClassId(value.getClassId());
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"nameResolver.getClassId(value.classId)");
                v4 = nameResolver.getName(value.getEnumValueId());
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"nameResolver.getName(value.enumValueId)");
                v1 = this.resolveEnumValue(v3, v4);
                break;
            }
            case 12: {
                v5 = value.getAnnotation();
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"value.annotation");
                v1 = new AnnotationValue(this.deserializeAnnotation(v5, nameResolver));
                break;
            }
            case 13: {
                expectedIsArray = KotlinBuiltIns.isArray(expectedType) != false || KotlinBuiltIns.isPrimitiveArray(expectedType) != false;
                arrayElements = value.getArrayElementList();
                var6_8 = arrayElements;
                if ($receiver$iv.isEmpty() == false) {
                    v6 = (ProtoBuf.Annotation.Argument.Value)CollectionsKt.first(arrayElements);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"arrayElements.first()");
                    actualElementType = this.resolveArrayElementType(v6, nameResolver);
                    v7 = this.getBuiltIns().getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(actualElementType);
                    if (v7 == null) {
                        v7 = this.getBuiltIns().getArrayType(Variance.INVARIANT, actualElementType);
                    }
                } else if (expectedIsArray) {
                    v7 = expectedType;
                } else {
                    v8 = this.getBuiltIns().getArrayType(Variance.INVARIANT, this.getBuiltIns().getAnyType());
                    v7 = v8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"builtIns.getArrayType(Va\u2026T, builtIns.getAnyType())");
                }
                actualArrayType = v7;
                v9 = this.getBuiltIns();
                if (expectedIsArray) {
                    v10 = expectedType;
                } else {
                    v11 = actualArrayType;
                    v10 = v11;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"actualArrayType");
                }
                expectedElementType = v9.getArrayElementType(v10);
                $i$f$isNotEmpty = arrayElements;
                var9_11 = this.factory;
                var10_12 = $receiver$iv;
                var11_13 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var14_16 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    var15_17 = destination$iv$iv;
                    v12 = expectedElementType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"expectedElementType");
                    v13 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"it");
                    var16_18 = this.resolveValue(v12, (ProtoBuf.Annotation.Argument.Value)v13, nameResolver);
                    var15_17.add(var16_18);
                }
                var15_17 = (List)destination$iv$iv;
                v14 = actualArrayType;
                Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"actualArrayType");
                v1 = var9_11.createArrayValue(var15_17, v14);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                expectedIsArray = "Unsupported annotation argument type: " + value.getType() + " (expected " + expectedType + ")";
                throw (Throwable)new IllegalStateException(message$iv.toString());
            }
        }
        result = v1;
        if (TypeUtilsKt.isSubtypeOf(result.getType(), expectedType)) {
            return result;
        }
        return this.factory.createErrorValue("Unexpected argument value");
    }

    private final ConstantValue<?> resolveEnumValue(ClassId enumClassId, Name enumEntryName) {
        ClassifierDescriptor enumEntry;
        ClassDescriptor enumClass = this.resolveClass(enumClassId);
        if (Intrinsics.areEqual((Object)((Object)enumClass.getKind()), (Object)((Object)ClassKind.ENUM_CLASS)) && (enumEntry = enumClass.getUnsubstitutedInnerClassesScope().getContributedClassifier(enumEntryName, NoLookupLocation.FROM_DESERIALIZATION)) instanceof ClassDescriptor) {
            return this.factory.createEnumValue((ClassDescriptor)enumEntry);
        }
        return this.factory.createErrorValue("Unresolved enum entry: " + enumClassId + "." + enumEntryName);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final KotlinType resolveArrayElementType(ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        KotlinBuiltIns receiver$iv = this.getBuiltIns();
        KotlinBuiltIns $receiver = receiver$iv;
        ProtoBuf.Annotation.Argument.Value.Type type2 = value.getType();
        if (type2 != null) {
            switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1: {
                    KotlinType kotlinType = $receiver.getByteType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"getByteType()");
                    return kotlinType2;
                }
                case 2: {
                    KotlinType kotlinType = $receiver.getCharType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"getCharType()");
                    return kotlinType2;
                }
                case 3: {
                    KotlinType kotlinType = $receiver.getShortType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"getShortType()");
                    return kotlinType2;
                }
                case 4: {
                    KotlinType kotlinType = $receiver.getIntType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"getIntType()");
                    return kotlinType2;
                }
                case 5: {
                    KotlinType kotlinType = $receiver.getLongType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"getLongType()");
                    return kotlinType2;
                }
                case 6: {
                    KotlinType kotlinType = $receiver.getFloatType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"getFloatType()");
                    return kotlinType2;
                }
                case 7: {
                    KotlinType kotlinType = $receiver.getDoubleType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"getDoubleType()");
                    return kotlinType2;
                }
                case 8: {
                    KotlinType kotlinType = $receiver.getBooleanType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"getBooleanType()");
                    return kotlinType2;
                }
                case 9: {
                    KotlinType kotlinType = $receiver.getStringType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"getStringType()");
                    return kotlinType2;
                }
                case 10: {
                    void message$iv;
                    String string = "Arrays of class literals are not supported yet";
                    throw (Throwable)new IllegalStateException(message$iv.toString());
                }
                case 11: {
                    ClassId classId = nameResolver.getClassId(value.getClassId());
                    Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nameResolver.getClassId(value.classId)");
                    KotlinType kotlinType = this.resolveClass(classId).getDefaultType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"resolveClass(nameResolve\u2026lue.classId)).defaultType");
                    return kotlinType2;
                }
                case 12: {
                    ClassId classId = nameResolver.getClassId(value.getAnnotation().getId());
                    Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nameResolver.getClassId(value.annotation.id)");
                    KotlinType kotlinType = this.resolveClass(classId).getDefaultType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"resolveClass(nameResolve\u2026notation.id)).defaultType");
                    return kotlinType2;
                }
                case 13: {
                    String message$iv = "Array of arrays is impossible";
                    throw (Throwable)new IllegalStateException(message$iv.toString());
                }
            }
        }
        String message$iv = "Unknown type: " + value.getType();
        throw (Throwable)new IllegalStateException(message$iv.toString());
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(this.module, classId);
        if (classDescriptor == null) {
            ClassDescriptor classDescriptor2 = ErrorUtils.createErrorClass(classId.asSingleFqName().asString());
            classDescriptor = classDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"ErrorUtils.createErrorCl\u2026ingleFqName().asString())");
        }
        return classDescriptor;
    }

    public AnnotationDeserializer(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        this.module = module;
        this.factory = new ConstantValueFactory(this.getBuiltIns());
    }
}

