/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.Deprecated;
import kotlin.HiddenDeclaration;
import kotlin.ReplaceWith;
import kotlin.Sequence;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilePathComponents;
import kotlin.io.FilesKt;
import kotlin.io.FilesKt__UtilsKt;
import kotlin.io.IoPackage$sam$FileFilter$ace751fe;
import kotlin.io.NoSuchFileException;
import kotlin.io.OnErrorAction;
import kotlin.io.TerminateException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinMultifileClassPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinMultifileClassPart(version={0, 25, 0}, abiVersion=25, multifileClassName="FilesKt", data={"i\f)!a)\u001b7f\u0015\u0011Q\u0017M^1\u000b\u0005%|'\"D2b]>t\u0017nY1m!\u0006$\bN\u0003\u0004TiJLgn\u001a\u0006\u0007W>$H.\u001b8\u000b3\r\fgn\u001c8jG\u0006d\u0007+\u0019;iI\u0005tgn\u001c;bi&|gn\u001d\u0006\u0011O\u0016$8)\u00198p]&\u001c\u0017\r\u001c)bi\"TA\u0001\\1oO*\u0001b)\u001b7fg.#xlX+uS2\u001c8\n\u001e\u0006\nI&\u0014Xm\u0019;pefTAbZ3u\t&\u0014Xm\u0019;pefT\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\u0019\u001d,G/\u0012=uK:\u001c\u0018n\u001c8\u000b\t9\fW.\u001a\u0006\u0011]\u0006lW\rJ1o]>$\u0018\r^5p]NTqaZ3u\u001d\u0006lWM\u0003\u000boC6,w+\u001b;i_V$X\t\u001f;f]NLwN\u001c\u0006\u0018O\u0016$h*Y7f/&$\bn\\;u\u000bb$XM\\:j_:Ta\u0001]1sK:$(B\u00059be\u0016tG\u000fJ1o]>$\u0018\r^5p]NT\u0011bZ3u!\u0006\u0014XM\u001c;\u000b\tA\fG\u000f\u001b\u0006\u0011a\u0006$\b\u000eJ1o]>$\u0018\r^5p]NTqaZ3u!\u0006$\bNC\u0007de\u0016\fG/\u001a+f[B$\u0015N\u001d\u0006\u0007aJ,g-\u001b=\u000b\rM,hMZ5y\u00159\u0019'/Z1uKR+W\u000e\u001d$jY\u0016TQ#\u00197m'\u0016\u0004\u0018M]1u_J\u001cHk\\*zgR,WNC\bd_BL(+Z2veNLg/\u001a7z\u0015\r!7\u000f\u001e\u0006\b_:,%O]8s\u0015%1UO\\2uS>t'GC\u0006J\u001f\u0016C8-\u001a9uS>t'\"D(o\u000bJ\u0014xN]!di&|gNC\u0004C_>dW-\u00198\u000b\u0007)4XNC\u0005gk:\u001cG/[8og*11m\u001c9z)>T\u0011b\u001c<fe^\u0014\u0018\u000e^3\u000b\u0015\t,hMZ3s'&TXMC\u0002J]RTA\u0001T8oO*\tB-\u001a7fi\u0016\u0014VmY;sg&4X\r\\=\u000b\u0011\u0015tGm],ji\"TQa\u001c;iKJT\u0011\u0002\\5ti\u001aKG.Z:\u000b\r\u0019LG\u000e^3s\u0015%1UO\\2uS>t\u0017GC\u0003BeJ\f\u0017PC\u0005o_Jl\u0017\r\\5{K*1\u0002/\u0019;i'\u0016\u0004\u0018M]1u_J\u001cHk\\*zgR,WN\u0003\u0007sK2\fG/\u001b<f!\u0006$\bN\u0003\u0006eKN\u001cWM\u001c3b]RT!B]3mCRLg/\u001a+p\u0015\u0011\u0011\u0017m]3\u000b\u000fI,7o\u001c7wK*A!/\u001a7bi&4XM\u0003\bsKN|GN^3TS\nd\u0017N\\4\u000b%M,\u0007/\u0019:bi>\u00148\u000fV8TsN$X-\u001c\u0006\u000bgR\f'\u000f^:XSRDg2\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)1\u0001\"\u0001\t\u00011\u0001Q!\u0001E\u0003\u000b\r!\u0019\u0001\u0003\u0002\r\u0001\u0015\u0011A\u0011\u0001\u0005\u0001\u000b\t!\u0001\u0001\u0003\u0003\u0006\u0005\u0011\u0019\u0001BA\u0003\u0004\t\u0007A\t\u0003\u0004\u0001\u0006\u0007\u0011\u0005\u0001\"\u0005\u0007\u0001\u000b\t!\u0019\u0001C\u0001\u0006\u0007\u0011)\u00012\u0005\u0007\u0001\u000b\r!\u0019\u0001\u0003\n\r\u0001\u0015\u0011A1\u0001E\u0013\u000b\t!i\u0001C\n\u0006\u0005\u00119\u0001\u0012E\u0003\u0004\t\u0007AQ\u0003\u0004\u0001\u0006\u0007\u0011\r\u00012\u0006\u0007\u0001\u000b\r!\u0019\u0001#\r\r\u0001\u0015\u0019A1\u0001\u0005\u001a\u0019\u0001)!\u0001B\u0004\t2\u0015UBq\u0019\u0003\u0016\u0007\u0015\t\u0001\"\u0001\r\u00021\u0007\t3!B\u0001\t\u0005a\u0011AeI+\u0004\u0019%)AaA\u0005\u0002\t\u0001i\u0011\u0001#\u0002\u000e\u000b\u0011\u001d\u0011\"\u0001E\u0004\u001b\u0005A)\u0001WB\u0005\u000bS!1\rB\u000b\u0004\u000b\u0005A\u0011\u0001G\u0001\u0019\u000b\u0005\u001aQ!\u0001\u0005\u00021\u0005!3%V\u0002\u0007\u001b\u0015!Y!C\u0001\t\u00065\t\u0001R\u0001-\u0004\n\u0015%Ba\u0019\u0003\u0016\u0007\u0015\t\u0001\"\u0001\r\u00021\u0019\t3!B\u0001\t\u0005a\u0011AeI+\u0004\r5)AQB\u0005\u0002\u0011\u000fi\u0011\u0001#\u0002Y\u0007\u0013))\u0004b2\u0005+\r)\u0011\u0001C\u0001\u0019\u0003a9\u0011eA\u0003\u0002\u0011\tA\"\u0001J\u0012V\u00071IQ\u0001b\u0004\n\u0003\u0011\u0001Q\"\u0001E\u0003\u001b\u0015!\u0001\"C\u0001\t\b5\t\u0001R\u0001-\u0004\n\u0015%Ba\u0019\u0003\u0016\u0007\u0015\t\u0001\"\u0001\r\u00021#\t3!B\u0001\t\u0005a\u0011AeI+\u0004\r5)A!C\u0005\u0002\u0011\u000fi\u0011\u0001#\u0002Y\u0007\u0013)9\u0004b2\u0005+\r)\u0011\u0001C\u0001\u0019\u0003aM\u0011\u0005B\u0003\u0002\u0011\u0005a\t\u0001G\u0001%GU\u001bA\"C\u0003\u0005\u0015%\tA\u0001A\u0007\u0002\u0011\u000biQ\u0001\"\u0006\n\u0003!\u0015Q\"\u0001E\u00031\u000e%QQ\u0007Cd\tU\u0019Q!\u0001\u0005\u00021\u0005A2\"I\u0002\u0006\u0003!\u0011\u0001D\u0001\u0013$+\u000ea\u0011\"\u0002C\f\u0013\u0005!\u0001!D\u0001\t\u00065)A\u0001D\u0005\u0002\u0011\u000fi\u0011\u0001#\u0002Y\u0007\u0013)Y\u0006B\u0002\u0019\u001au=A!\u0001\u0005\u000e\u001b\r)\u0011\u0001\u0003\u0002\u0019\u0005A\u001b\u0001!(\u0005\u0005\u0003!mQ\u0002B\u0003\u0002\u0011\ta\t\u0001\u0007\u0002Q\u0007\u0003i\n\u0002B\u0001\t\u000b5!Q!\u0001\u0005\u0002\u0019\u0003A\u0012\u0001U\u0002\u0002C\r)\u0011\u0001C\u0001\u0019\u0003E\u001b\u0011\u0002\"\u0007\n\u0003!\u0015Q\"\u0001E\u0004\u001b\u0005A9!D\u0001\t\u0006a\u001bI!b\u0017\u0005\u0007aqQt\u0002\u0003\u0002\u00115i1!B\u0001\t\u0005a\u0011\u0001k\u0001\u0001\u001e\u0012\u0011\t\u00012D\u0007\u0005\u000b\u0005A!\u0001$\u0001\u0019\u0005A\u001b\t!(\u0005\u0005\u0003!)Q\u0002B\u0003\u0002\u0011\u0005a\t\u0001G\u0001Q\u0007\u0005\t3!B\u0001\t\u0003a\t\u0011kA\u0005\u0005\u001d%\t\u0001RA\u0007\u0002\u0011\u000fi\u0011\u0001c\u0002\u000e\u0003!\u0015\u0001l!\u0003\u0006%\u0011\u0019QcA\u0003\u0002\u0011\tA\"\u0001'\b\"\u0007\u0015\t\u0001B\u0001\r\u0003#\u000e)AQD\u0005\u0002\u0011\u000fi\u0011\u0001c\u0002Y\u0007\u0013)a\u0007B\u0002\u0016\u0007\u0015\t\u0001\"\u0001\r\u00021=iz\u0001\u0002\u0001\t 5\u0019Q!\u0001\u0005\u00021\u0005\u00016\u0011AO\u0017\t\u0005A\u0001#\u0004\n\u0006\u0003!!\u0011\u0002B\u0005\u0004\u000b\u0005A\u0011\u0001G\u0001\n\t%\u0019Q!\u0001E\u00051\u0013IA!C\u0002\u0006\u0003!-\u00014\u0002\r\u0005!\u000e\t\u0011eA\u0003\u0002\u0011\u0019Ab!U\u0002\n\t=I\u0011\u0001\"\u0001\u000e\u0003!\u0015Q\"\u0001E\u0003\u001b\u0005Ay\u0001WB\u0005\u000bG\"1!F\u0002\u0006\u0003!\t\u0001$\u0001M\u0014;\u001f!\u0001\u0001c\b\u000e\u0007\u0015\t\u0001\"\u0001\r\u0002!\u000e\u0005Qt\u0002\u0003\u0002\u0011Qi1!B\u0001\t\ra1\u0001kA\u0001\u001e\u0010\u0011\t\u0001\u0012F\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0007\t3!B\u0001\t\u0012aE\u0011kA\u0006\u0005(%\tAqA\u0007\u0002\u0011\u000bi\u0011\u0001#\u0002\u000e\u0003\u0011\u0005Q\"\u0001C\u00031\u000e%QA\u0005\u0003\u0004+\r)\u0011\u0001C\u0001\u0019\u0003a1\u0012eA\u0003\u0002\u0011\u0019Ab!U\u0002\u0006\tYI\u0011\u0001\"\u0001\u000e\u0003!\u0015\u0001l!\u0003\u0006:\u0011\u0019QcA\u0003\u0002\u0011\u0005A\u0012\u0001'\f\u001e\u0010\u0011\u0001\u0001bF\u0007\u0004\u000b\u0005A\u0011\u0001G\u0001Q\u0007\u0003\t3!B\u0001\t\ra1\u0011kA\u0004\u0005.%\tA\u0011A\u0007\u0002\u0011\u000bi\u0011\u0001#\u0002Y\u0007\u0013)I\u0004B\u0002\u0016\u0007\u0015\t\u0001\"\u0001\r\u00021[iz\u0001\u0002\u0001\t/5\u0019Q!\u0001\u0005\u00031\t\u00016\u0011A\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004R\u0007\u001d!i#C\u0001\u0005\u00025\t\u0001RA\u0007\u0002\u0011\u000fA6\u0011BC.\t\r)2!B\u0001\t\u0003a\t\u0001tFO\u0012\t\u0001A\u0001$D\u0007\u0006\u0003!I\u0011\u0002B\u0005\u0004\u000b\u0005A\u0011\u0001G\u0001\n\t%\u0019Q!\u0001\u0005\u00071\u0019A\u0012\u0002UB\u0001C%)\u0011\u0001c\u0005\n\t%\u0019Q!\u0001\u0005\u00021\u0005a\t\u0001g\u0005R\u0007!!y#\u0003\u0002\t\u00061\u0005Q\"\u0001E\u0003\u001b\u0005A!\u0002WB\u0005\u000bI!1!F\u0002\u0006\u0003!\t\u0001$\u0001M\u001aC\r)\u0011\u0001C\u0001\u0019\u0003E\u001bQ\u0001b\r\n\u0003!\u0015Q\"\u0001E\u00031\u000e%QA\u0005\u0003\u0004+\r)\u0011\u0001\u0003\u0002\u0019\u0005aQ\u0012eA\u0003\u0002\u0011\tA\"!U\u0002\u0006\tiI\u0011\u0001c\u0002\u000e\u0003!\u001d\u0001l!\u0003\u0006:\u0011\u001dQcA\u0003\u0002\u0011\u0005A\u0012\u0001'\u000e\u001e\u0010\u0011\u0001\u0001bG\u0007\u0004\u000b\u0005A\u0011\u0001G\u0001Q\u0007\u0003\t3!B\u0001\t\u0005a\u0011\u0011kA\u0004\u00056%\t\u0001rA\u0007\u0002\u0011\u000bi\u0011\u0001#\u0002Y\u0007\u0013)I\u0004B\u0002\u0016\u0007\u0015\t\u0001\"\u0001\r\u00021oiz\u0001\u0002\u0001\t95\u0019Q!\u0001\u0005\u00021\u0005\u00016\u0011A\u0011\u0004\u000b\u0005A!\u0001\u0007\u0002R\u0007\u001d!9$C\u0001\t\b5\t\u0001RA\u0007\u0002\u0011\u000bA6\u0011BC\u001d\t\r)2!B\u0001\t\u0003a\t\u0001\u0014HO\b\t\u0001AQ$D\u0002\u0006\u0003!\t\u0001$\u0001)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00021\u0005\t6a\u0002C\u001d\u0013\u0005A)!D\u0001\t\u00065\t\u0001R\u0001-\u0004\n\u0015eBaA\u000b\u0004\u000b\u0005A\u0011\u0001G\u0001\u0019:u=A\u0001\u0001\u0005\u001e\u001b\r)\u0011\u0001\u0003\u0002\u0019\u0005A\u001b\t!I\u0002\u0006\u0003!\t\u0001$A)\u0004\u000f\u0011e\u0012\"\u0001E\u0003\u001b\u0005A)!D\u0001\t\ba\u001bI!\"\u000f\u0005\u0007U\u0019Q!\u0001\u0005\u00021\u0005AZ$h\u0004\u0005\u0001!iRbA\u0003\u0002\u0011\u0005A\u0012\u0001UB\u0001C\r)\u0011\u0001C\u0001\u0019\u0003E\u001bq\u0001b\u000f\n\u0003!\u0015Q\"\u0001E\u0003\u001b\u0005A)\u0001WB\u0005\u000bs!1!F\u0002\u0006\u0003!\t\u0001$\u0001M\u001e;\u001f!\u0001\u0001C\u000f\u000e\u0007\u0015\t\u0001B\u0001\r\u0003!\u000e\u0005\u0011eA\u0003\u0002\u0011\u0005A\u0012!U\u0002\b\twI\u0011\u0001#\u0002\u000e\u0003!\u0015Q\"\u0001E\u00041\u000e%QA\u0005\u0003\u0004+\r)\u0011\u0001C\u0001\u0019\u0003aq\u0012eA\u0003\u0002\u0011\tA\"!U\u0002\u0006\tyI\u0011\u0001c\u0002\u000e\u0003!\u0015\u0001l!\u0003\u0006%\u0011\u0019QcA\u0003\u0002\u0011\tA\"\u0001\u0007\u0010\"\u0007\u0015\t\u0001B\u0001\r\u0003#\u000e)AAH\u0005\u0002\u0011\u000fi\u0011\u0001c\u0002Y\u0007\u0013)I\u0004B\u0002\u0016\u0007\u0015\t\u0001\"\u0001\r\u00021{iz\u0001\u0002\u0001\t/5\u0019Q!\u0001\u0005\u00021\u0005\u00016\u0011A\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004R\u0007\u001d!i$C\u0001\u0005\u00025\t\u0001RA\u0007\u0002\u0011\u000bA6\u0011BC\u001d\t\r)2!B\u0001\t\u0003a\t\u0001THO\b\t\u0001Aq#D\u0002\u0006\u0003!\u0011\u0001D\u0001)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00071\u0019\t6a\u0002C\u001f\u0013\u0005!\t!D\u0001\t\u00065\t\u0001r\u0001-\u0004\n\u0001"})
final class FilesKt__UtilsKt {
    @NotNull
    public static final File createTempDir(@NotNull String prefix, @Nullable String suffix, @Nullable File directory) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        File dir = File.createTempFile(prefix, suffix, directory);
        dir.delete();
        if (dir.mkdir()) {
            File file = dir;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dir");
            return file;
        }
        throw (Throwable)new IOException("Unable to create temporary directory " + dir);
    }

    @NotNull
    public static /* synthetic */ File createTempDir$default(String string, String string2, File file, int n) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempDir(string, string2, file);
    }

    @NotNull
    public static final File createTempFile(@NotNull String prefix, @Nullable String suffix, @Nullable File directory) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        File file = File.createTempFile(prefix, suffix, directory);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File.createTempFile(prefix, suffix, directory)");
        return file;
    }

    @NotNull
    public static /* synthetic */ File createTempFile$default(String string, String string2, File file, int n) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempFile(string, string2, file);
    }

    @NotNull
    public static final File getDirectory(File $receiver) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.isDirectory()) {
            file = $receiver;
        } else {
            file = FilesKt.getParent($receiver);
            if (file == null) {
                Intrinsics.throwNpe();
            }
        }
        return file;
    }

    @Deprecated(value="Use parentFile", replaceWith=@ReplaceWith(expression="parentFile", imports={}))
    private static final /* synthetic */ void parent$annotations(File file) {
    }

    @Nullable
    public static final File getParent(File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getParentFile();
    }

    @Deprecated(value="Is replaced with automatic synthetic extension", replaceWith=@ReplaceWith(expression="canonicalPath", imports={}))
    @HiddenDeclaration
    private static final /* synthetic */ void canonicalPath$annotations(File file) {
    }

    @NotNull
    public static final /* synthetic */ String getCanonicalPath(File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getCanonicalPath()");
        return string;
    }

    @Deprecated(value="Is replaced with automatic synthetic extension", replaceWith=@ReplaceWith(expression="name", imports={}))
    @HiddenDeclaration
    private static final /* synthetic */ void name$annotations(File file) {
    }

    @NotNull
    public static final /* synthetic */ String getName(File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getName()");
        return string;
    }

    @Deprecated(value="Is replaced with automatic synthetic extension", replaceWith=@ReplaceWith(expression="path", imports={}))
    @HiddenDeclaration
    private static final /* synthetic */ void path$annotations(File file) {
    }

    @NotNull
    public static final /* synthetic */ String getPath(File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getPath()");
        return string;
    }

    @NotNull
    public static final String getExtension(File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.substringAfterLast($receiver.getName(), '.', "");
    }

    @NotNull
    public static final String separatorsToSystem(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String otherSep = Intrinsics.areEqual((Object)File.separator, (Object)"/") ? "\\" : "/";
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.separator");
        return StringsKt.replace$default($receiver, otherSep, string, false, 4);
    }

    @NotNull
    public static final String pathSeparatorsToSystem(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String otherSep = Intrinsics.areEqual((Object)File.pathSeparator, (Object)":") ? ";" : ":";
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
        return StringsKt.replace$default($receiver, otherSep, string, false, 4);
    }

    @NotNull
    public static final String allSeparatorsToSystem(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FilesKt.pathSeparatorsToSystem(FilesKt.separatorsToSystem($receiver));
    }

    @NotNull
    public static final String separatorsToSystem(File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FilesKt.separatorsToSystem($receiver.toString());
    }

    @NotNull
    public static final String getNameWithoutExtension(File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.substringBeforeLast$default($receiver.getName(), ".", null, 2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String relativeTo(File $receiver, @NotNull File base) {
        int i;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        FilePathComponents components = FilesKt.filePathComponents($receiver);
        FilePathComponents baseComponents = FilesKt.filePathComponents(base);
        if (Intrinsics.areEqual((Object)components.getRootName(), (Object)baseComponents.getRootName()) ^ true) {
            throw (Throwable)new IllegalArgumentException("this and base files have different roots: " + components.getRootName() + " and " + baseComponents.getRootName());
        }
        for (i = 0; i < components.size() && i < baseComponents.size() && Intrinsics.areEqual((Object)components.getFileList().get(i), (Object)baseComponents.getFileList().get(i)); ++i) {
        }
        int sameCount = i;
        int baseCount = baseComponents.size();
        StringBuilder res = new StringBuilder();
        int n = sameCount;
        int n2 = baseCount - 2;
        if (n <= n2) {
            while (true) {
                void j;
                res.append("..").append(File.separator);
                if (j == n2) break;
                ++j;
            }
        }
        if (baseCount > sameCount) {
            res.append(sameCount < components.size() ? ".." + File.separator : "..");
        }
        if (sameCount < components.size() - 1) {
            res.append(components.subPath(sameCount, components.size() - 1)).append(File.separator);
        }
        if (sameCount < components.size()) {
            res.append(components.subPath(components.size() - 1, components.size()));
        }
        String string = res.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"res.toString()");
        return string;
    }

    @Deprecated(value="Use relativeTo() function instead")
    @NotNull
    public static final String relativePath(File $receiver, @NotNull File descendant) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)descendant, (String)"descendant");
        String prefix = FilesKt.getDirectory($receiver).getCanonicalPath();
        String answer = descendant.getCanonicalPath();
        String string2 = prefix;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"prefix");
        if (StringsKt.startsWith$default(answer, string2, false, 2)) {
            int prefixSize = prefix.length();
            string = answer.length() > prefixSize ? StringsKt.substring(answer, prefixSize + 1) : "";
        } else {
            string = answer;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final long copyTo(File $receiver, @NotNull File dst, boolean overwrite, int bufferSize) {
        long it22;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        if (!$receiver.exists()) {
            throw (Throwable)new NoSuchFileException($receiver, null, "The source file doesn't exist", 2, null);
        }
        if ($receiver.isDirectory()) {
            throw (Throwable)new IllegalArgumentException("Use copyRecursively to copy a directory " + $receiver);
        }
        if (dst.exists()) {
            if (!overwrite) {
                throw (Throwable)new FileAlreadyExistsException($receiver, dst, "The destination file already exists");
            }
            if (dst.isDirectory() && ArraysKt.any((Object[])dst.listFiles())) {
                String string = $receiver.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                return FilesKt.copyTo($receiver, FilesKt.resolve(dst, string), overwrite, bufferSize);
            }
        }
        File file = dst.getParentFile();
        Boolean bl = file != null ? Boolean.valueOf(file.mkdirs()) : null;
        dst.delete();
        FileInputStream input = new FileInputStream($receiver);
        Closeable closeable = input;
        boolean closed = false;
        try {
            Object it3;
            void $receiver3;
            FileInputStream it22 = (FileInputStream)$receiver2;
            FileOutputStream output = new FileOutputStream(dst);
            Closeable closeable2 = output;
            boolean closed2 = false;
            try {
                it3 = (FileOutputStream)$receiver3;
                it3 = ByteStreamsKt.copyTo(input, output, bufferSize);
            }
            catch (Exception e) {
                closed2 = true;
                try {
                    $receiver3.close();
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                throw (Throwable)e;
            }
            finally {
                if (!closed2) {
                    $receiver3.close();
                }
            }
            it22 = ((Number)it3).longValue();
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver2.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver2.close();
            }
        }
        return it22;
    }

    public static /* synthetic */ long copyTo$default(File file, File file2, boolean bl, int n, int n2) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return FilesKt.copyTo(file, file2, bl, n);
    }

    public static final boolean copyRecursively(File $receiver, @NotNull File dst, @NotNull Function2<? super File, ? super IOException, ? extends OnErrorAction> onError) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        if (!$receiver.exists()) {
            return Intrinsics.areEqual((Object)((Object)((OnErrorAction)((Object)onError.invoke((Object)$receiver, (Object)new NoSuchFileException($receiver, null, "The source file doesn't exist", 2, null))))), (Object)((Object)OnErrorAction.TERMINATE)) ^ true;
        }
        try {
            Iterator<File> iterator2 = FilesKt.walkTopDown($receiver).fail((Function2<? super File, ? super IOException, ? extends Unit>)((Function2)new Function2<File, IOException, Unit>(onError){
                final /* synthetic */ Function2 $onError;

                public final void invoke(@NotNull File f, @NotNull IOException e) {
                    Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    if (Intrinsics.areEqual((Object)((Object)((OnErrorAction)((Object)this.$onError.invoke((Object)f, (Object)e)))), (Object)((Object)OnErrorAction.TERMINATE))) {
                        throw (Throwable)new TerminateException(f);
                    }
                }
                {
                    this.$onError = function2;
                    super(2);
                }
            })).iterator();
            while (iterator2.hasNext()) {
                File src = iterator2.next();
                if (!src.exists()) {
                    if (!Intrinsics.areEqual((Object)((Object)((OnErrorAction)((Object)onError.invoke((Object)src, (Object)new NoSuchFileException(src, null, "The source file doesn't exist", 2, null))))), (Object)((Object)OnErrorAction.TERMINATE))) continue;
                    return false;
                }
                String relPath = FilesKt.relativeTo(src, $receiver);
                File dstFile = new File(dst, relPath);
                if (!(!dstFile.exists() || src.isDirectory() && dstFile.isDirectory())) {
                    if (!Intrinsics.areEqual((Object)((Object)((OnErrorAction)((Object)onError.invoke((Object)dstFile, (Object)new FileAlreadyExistsException(src, dstFile, "The destination file already exists"))))), (Object)((Object)OnErrorAction.TERMINATE))) continue;
                    return false;
                }
                if (src.isDirectory()) {
                    dstFile.mkdirs();
                    continue;
                }
                if (FilesKt.copyTo$default(src, dstFile, true, 0, 4) == src.length() || !Intrinsics.areEqual((Object)((Object)((OnErrorAction)((Object)onError.invoke((Object)src, (Object)new IOException("src.length() != dst.length()"))))), (Object)((Object)OnErrorAction.TERMINATE))) continue;
                return false;
            }
            return true;
        }
        catch (TerminateException e) {
            return false;
        }
    }

    public static /* synthetic */ boolean copyRecursively$default(File file, File file2, Function2 function2, int n) {
        if ((n & 2) != 0) {
            function2 = copyRecursively.1.INSTANCE$;
        }
        return FilesKt.copyRecursively(file, file2, (Function2<? super File, ? super IOException, ? extends OnErrorAction>)function2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean deleteRecursively(File $receiver) {
        void var3_3;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Sequence sequence2 = FilesKt.walkBottomUp($receiver);
        boolean initial = $receiver.exists();
        boolean accumulator = initial;
        for (Object element : $receiver2) {
            void it2;
            File file = (File)element;
            boolean res = accumulator;
            accumulator = it2.delete() && res;
        }
        return (boolean)var3_3;
    }

    @Nullable
    public static final File[] listFiles(File $receiver, @NotNull Function1<? super File, ? extends Boolean> filter) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Function1<? super File, ? extends Boolean> function1 = filter;
        return $receiver.listFiles((FileFilter)(function1 == null ? null : new IoPackage$sam$FileFilter$ace751fe(function1)));
    }

    public static final boolean startsWith(File $receiver, @NotNull File other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        FilePathComponents components = FilesKt.filePathComponents($receiver);
        FilePathComponents otherComponents = FilesKt.filePathComponents(other);
        if (Intrinsics.areEqual((Object)components.getRootName(), (Object)otherComponents.getRootName()) ^ true && Intrinsics.areEqual((Object)otherComponents.getRootName(), (Object)"") ^ true) {
            return false;
        }
        return components.size() < otherComponents.size() ? false : ((Object)components.getFileList().subList(0, otherComponents.size())).equals(otherComponents.getFileList());
    }

    public static final boolean startsWith(File $receiver, @NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return FilesKt.startsWith($receiver, new File(other));
    }

    public static final boolean endsWith(File $receiver, @NotNull File other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        FilePathComponents components = FilesKt.filePathComponents($receiver);
        FilePathComponents otherComponents = FilesKt.filePathComponents(other);
        if (Intrinsics.areEqual((Object)components.getRootName(), (Object)otherComponents.getRootName()) ^ true && Intrinsics.areEqual((Object)otherComponents.getRootName(), (Object)"") ^ true) {
            return false;
        }
        int shift = components.size() - otherComponents.size();
        return shift < 0 ? false : ((Object)components.getFileList().subList(shift, components.size())).equals(otherComponents.getFileList());
    }

    public static final boolean endsWith(File $receiver, @NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return FilesKt.endsWith($receiver, new File(other));
    }

    @NotNull
    public static final File normalize(File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FilePathComponents components = FilesKt.filePathComponents($receiver);
        String rootName = components.getRootName();
        List list = new ArrayList();
        for (File file : components.getFileList()) {
            String name;
            switch (name = file.toString()) {
                case "..": {
                    if (!list.isEmpty() && Intrinsics.areEqual((Object)((String)list.get(list.size() - 1)), (Object)"..") ^ true) {
                        list.remove(list.size() - 1);
                        break;
                    }
                    String string = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                    list.add(string);
                    break;
                }
                default: {
                    String string = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                    list.add(string);
                }
                case ".": 
            }
        }
        Iterable iterable = list;
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.separator");
        return new File(CollectionsKt.joinToString$default(iterable, string, rootName, null, 0, null, null, 60));
    }

    @NotNull
    public static final File resolve(File $receiver, @NotNull File relative) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relative, (String)"relative");
        if (FilesKt.getRoot(relative) != null) {
            return relative;
        }
        String ourName = $receiver.toString();
        return StringsKt.endsWith$default(ourName, File.separatorChar, false, 2) ? new File(ourName + relative) : new File(ourName + File.separatorChar + relative);
    }

    @NotNull
    public static final File resolve(File $receiver, @NotNull String relative) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relative, (String)"relative");
        return FilesKt.resolve($receiver, new File(relative));
    }

    @NotNull
    public static final File resolveSibling(File $receiver, @NotNull File relative) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relative, (String)"relative");
        FilePathComponents components = FilesKt.filePathComponents($receiver);
        String rootName = components.getRootName();
        return components.size() == 0 ? relative : FilesKt.resolve(FilesKt.resolve(new File(rootName), components.subPath(0, components.size() - 1)), relative);
    }

    @NotNull
    public static final File resolveSibling(File $receiver, @NotNull String relative) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relative, (String)"relative");
        return FilesKt.resolveSibling($receiver, new File(relative));
    }
}

