/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.internal.JsonConf;
import kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonParser;
import kotlinx.serialization.json.internal.JsonReader;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonDecoder$WhenMappings;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.StringOpsKt;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\rH\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0017H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0016J\b\u0010*\u001a\u00020\rH\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u001dH\u0002J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u001dH\u0002J\b\u00102\u001a\u00020\u0019H\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\u0018\u00105\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J!\u00106\u001a\u0002H7\"\u0004\b\u0000\u001072\f\u00108\u001a\b\u0012\u0004\u0012\u0002H709H\u0016\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006A"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder;", "Lkotlinx/serialization/json/JsonDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "reader", "Lkotlinx/serialization/json/internal/JsonReader;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;Lkotlinx/serialization/json/internal/JsonReader;)V", "configuration", "Lkotlinx/serialization/json/internal/JsonConf;", "currentIndex", "", "getJson", "()Lkotlinx/serialization/json/Json;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "coerceInputValue", "", "index", "decodeBoolean", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescriptor", "decodeFloat", "", "decodeInline", "Lkotlinx/serialization/encoding/Decoder;", "inlineDescriptor", "decodeInt", "decodeJsonElement", "Lkotlinx/serialization/json/JsonElement;", "decodeListIndex", "tokenClass", "decodeLong", "", "decodeMapIndex", "decodeNotNullMark", "decodeNull", "", "decodeObjectIndex", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeShort", "", "decodeString", "", "endStructure", "", "kotlinx-serialization-json"})
public class StreamingJsonDecoder
extends AbstractDecoder
implements JsonDecoder {
    @NotNull
    private final SerializersModule serializersModule;
    private int currentIndex;
    private final JsonConf configuration;
    @NotNull
    private final Json json;
    private final WriteMode mode;
    @JvmField
    @NotNull
    public final JsonReader reader;

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    @NotNull
    public JsonElement decodeJsonElement() {
        return new JsonParser(this.getJson().getConfiguration$kotlinx_serialization_json(), this.reader).read();
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return PolymorphicKt.decodeSerializableValuePolymorphic(this, deserializer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.getJson(), descriptor2);
        if (newMode.begin != '\u0000') {
            void this_$iv;
            JsonReader jsonReader = this.reader;
            byte expected$iv = newMode.beginTc;
            boolean $i$f$requireTokenClass$kotlinx_serialization_json = false;
            if (this_$iv.tokenClass != expected$iv) {
                char c = (char)this_$iv.tokenClass;
                void var8_7 = this_$iv;
                boolean bl = false;
                String string = "Expected '" + newMode.begin + ", kind: " + descriptor2.getKind() + '\'';
                Void void_ = var8_7.fail(string, JsonReader.access$getTokenPosition$p((JsonReader)this_$iv));
                throw new KotlinNothingValueException();
            }
            this.reader.nextToken();
        }
        switch (StreamingJsonDecoder$WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                compositeDecoder = new StreamingJsonDecoder(this.getJson(), newMode, this.reader);
                break;
            }
            default: {
                compositeDecoder = this.mode == newMode ? this : new StreamingJsonDecoder(this.getJson(), newMode, this.reader);
            }
        }
        return compositeDecoder;
    }

    /*
     * WARNING - void declaration
     */
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.mode.end != '\u0000') {
            void this_$iv;
            JsonReader jsonReader = this.reader;
            byte expected$iv = this.mode.endTc;
            boolean $i$f$requireTokenClass$kotlinx_serialization_json = false;
            if (this_$iv.tokenClass != expected$iv) {
                char c = (char)this_$iv.tokenClass;
                void var7_6 = this_$iv;
                boolean bl = false;
                String string = "Expected '" + this.mode.end + '\'';
                Void void_ = var7_6.fail(string, JsonReader.access$getTokenPosition$p((JsonReader)this_$iv));
                throw new KotlinNothingValueException();
            }
            this.reader.nextToken();
        }
    }

    public boolean decodeNotNullMark() {
        return this.reader.tokenClass != 10;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Void decodeNull() {
        void this_$iv;
        JsonReader jsonReader = this.reader;
        byte expected$iv = 10;
        boolean $i$f$requireTokenClass$kotlinx_serialization_json = false;
        if (this_$iv.tokenClass != expected$iv) {
            char c = (char)this_$iv.tokenClass;
            void var6_5 = this_$iv;
            boolean bl = false;
            String string = "Expected 'null' literal";
            Void void_ = var6_5.fail(string, JsonReader.access$getTokenPosition$p((JsonReader)this_$iv));
            throw new KotlinNothingValueException();
        }
        this.reader.nextToken();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        byte tokenClass = this.reader.tokenClass;
        if (tokenClass == 4) {
            void condition$iv;
            JsonReader jsonReader = this.reader;
            boolean bl = this.currentIndex != -1;
            int position$iv = this.reader.currentPosition;
            boolean $i$f$require$kotlinx_serialization_json = false;
            if (condition$iv == false) {
                void this_$iv;
                void var8_7 = this_$iv;
                boolean bl2 = false;
                String string = "Unexpected leading comma";
                Void void_ = var8_7.fail(string, position$iv);
                throw new KotlinNothingValueException();
            }
            this.reader.nextToken();
        }
        block0 : switch (StreamingJsonDecoder$WhenMappings.$EnumSwitchMapping$1[this.mode.ordinal()]) {
            case 1: {
                n = this.decodeListIndex(tokenClass);
                break;
            }
            case 2: {
                n = this.decodeMapIndex(tokenClass);
                break;
            }
            case 3: {
                StreamingJsonDecoder streamingJsonDecoder = this;
                ++streamingJsonDecoder.currentIndex;
                switch (streamingJsonDecoder.currentIndex) {
                    case 0: {
                        n = 0;
                        break block0;
                    }
                    case 1: {
                        n = 1;
                        break block0;
                    }
                }
                n = -1;
                break;
            }
            default: {
                n = this.decodeObjectIndex(tokenClass, descriptor2);
            }
        }
        return n;
    }

    private final int decodeMapIndex(byte tokenClass) {
        int n;
        JsonReader this_$iv;
        boolean $i$f$requireTokenClass$kotlinx_serialization_json;
        byte expected$iv;
        if (tokenClass != 4 && this.currentIndex % 2 == 1) {
            JsonReader jsonReader = this.reader;
            expected$iv = 7;
            $i$f$requireTokenClass$kotlinx_serialization_json = false;
            if (this_$iv.tokenClass != expected$iv) {
                char c = (char)this_$iv.tokenClass;
                JsonReader jsonReader2 = this_$iv;
                boolean bl = false;
                String string = "Expected end of the object or comma";
                Void void_ = jsonReader2.fail(string, JsonReader.access$getTokenPosition$p(this_$iv));
                throw new KotlinNothingValueException();
            }
        }
        if (this.currentIndex % 2 == 0) {
            this_$iv = this.reader;
            expected$iv = 5;
            $i$f$requireTokenClass$kotlinx_serialization_json = false;
            if (this_$iv.tokenClass != expected$iv) {
                char it = (char)this_$iv.tokenClass;
                JsonReader jsonReader = this_$iv;
                boolean bl = false;
                String string = "Expected ':' after the key";
                Void void_ = jsonReader.fail(string, JsonReader.access$getTokenPosition$p(this_$iv));
                throw new KotlinNothingValueException();
            }
            this.reader.nextToken();
        }
        if (!this.reader.getCanBeginValue()) {
            this_$iv = this.reader;
            boolean condition$iv = tokenClass != 4;
            int position$iv = this_$iv.currentPosition;
            boolean $i$f$require$kotlinx_serialization_json = false;
            if (!condition$iv) {
                JsonReader jsonReader = this_$iv;
                boolean bl = false;
                String string = "Unexpected trailing comma";
                Void void_ = jsonReader.fail(string, position$iv);
                throw new KotlinNothingValueException();
            }
            n = -1;
        } else {
            StreamingJsonDecoder streamingJsonDecoder = this;
            n = ++streamingJsonDecoder.currentIndex;
        }
        return n;
    }

    private final boolean coerceInputValue(SerialDescriptor descriptor2, int index) {
        SerialDescriptor elementDescriptor = descriptor2.getElementDescriptor(index);
        if (this.reader.tokenClass == 10 && !elementDescriptor.isNullable()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)elementDescriptor.getKind(), (Object)SerialKind.ENUM.INSTANCE)) {
            String string = this.reader.peekString(this.configuration.isLenient);
            if (string == null) {
                return false;
            }
            String enumValue = string;
            int enumIndex = elementDescriptor.getElementIndex(enumValue);
            if (enumIndex == -3) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int decodeObjectIndex(byte tokenClass, SerialDescriptor descriptor2) {
        if (tokenClass == 4 && !this.reader.getCanBeginValue()) {
            Void void_ = JsonReader.fail$default(this.reader, "Unexpected trailing comma", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        while (this.reader.getCanBeginValue()) {
            void this_$iv;
            void condition$iv;
            boolean isUnknown;
            boolean bl;
            void this_$iv2;
            StreamingJsonDecoder streamingJsonDecoder = this;
            ++streamingJsonDecoder.currentIndex;
            int cfr_ignored_0 = streamingJsonDecoder.currentIndex;
            String key = this.decodeString();
            JsonReader jsonReader = this.reader;
            byte expected$iv = 5;
            boolean $i$f$requireTokenClass$kotlinx_serialization_json22 = false;
            if (this_$iv2.tokenClass != expected$iv) {
                char c = (char)this_$iv2.tokenClass;
                void var11_12 = this_$iv2;
                boolean bl2 = false;
                String string = "Expected ':'";
                Void void_ = var11_12.fail(string, JsonReader.access$getTokenPosition$p((JsonReader)this_$iv2));
                throw new KotlinNothingValueException();
            }
            this.reader.nextToken();
            int index = descriptor2.getElementIndex(key);
            if (index != -3) {
                if (!this.configuration.coerceInputValues || !this.coerceInputValue(descriptor2, index)) return index;
                bl = false;
            } else {
                bl = isUnknown = true;
            }
            if (isUnknown && !this.configuration.ignoreUnknownKeys) {
                Void void_ = JsonReader.fail$default(this.reader, "Encountered an unknown key '" + key + "'.\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            this.reader.skipElement();
            if (this.reader.tokenClass != 4) continue;
            this.reader.nextToken();
            JsonReader $i$f$requireTokenClass$kotlinx_serialization_json22 = this.reader;
            boolean it = this.reader.getCanBeginValue();
            int position$iv = this.reader.currentPosition;
            boolean $i$f$require$kotlinx_serialization_json = false;
            if (condition$iv != false) continue;
            void var11_13 = this_$iv;
            boolean bl3 = false;
            String string = "Unexpected trailing comma";
            Void void_ = var11_13.fail(string, position$iv);
            throw new KotlinNothingValueException();
        }
        return -1;
    }

    private final int decodeListIndex(byte tokenClass) {
        int n;
        JsonReader this_$iv;
        if (tokenClass != 4 && this.currentIndex != -1) {
            JsonReader jsonReader = this.reader;
            byte expected$iv = 9;
            boolean $i$f$requireTokenClass$kotlinx_serialization_json = false;
            if (this_$iv.tokenClass != expected$iv) {
                char c = (char)this_$iv.tokenClass;
                JsonReader jsonReader2 = this_$iv;
                boolean bl = false;
                String string = "Expected end of the array or comma";
                Void void_ = jsonReader2.fail(string, JsonReader.access$getTokenPosition$p(this_$iv));
                throw new KotlinNothingValueException();
            }
        }
        if (!this.reader.getCanBeginValue()) {
            this_$iv = this.reader;
            boolean condition$iv = tokenClass != 4;
            int position$iv = this_$iv.currentPosition;
            boolean $i$f$require$kotlinx_serialization_json = false;
            if (!condition$iv) {
                JsonReader jsonReader = this_$iv;
                boolean bl = false;
                String string = "Unexpected trailing comma";
                Void void_ = jsonReader.fail(string, position$iv);
                throw new KotlinNothingValueException();
            }
            n = -1;
        } else {
            StreamingJsonDecoder streamingJsonDecoder = this;
            n = ++streamingJsonDecoder.currentIndex;
        }
        return n;
    }

    public boolean decodeBoolean() {
        String string = this.configuration.isLenient ? this.reader.takeString() : this.reader.takeBooleanStringUnquoted();
        Boolean bl = StringOpsKt.toBooleanStrictOrNull(string);
        if (bl != null) {
            Boolean bl2 = bl;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean it = bl2;
            boolean bl5 = false;
            return it;
        }
        Void void_ = JsonReader.fail$default(this.reader, "Failed to parse type 'boolean' for input '" + string + '\'', 0, 2, null);
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    public byte decodeByte() {
        byte by;
        void $this$parseString$iv;
        JsonReader jsonReader = this.reader;
        String expectedType$iv = "byte";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.takeString();
        try {
            String $this$parseString = input$iv;
            boolean bl = false;
            String string = $this$parseString;
            boolean bl2 = false;
            by = Byte.parseByte(string);
        }
        catch (IllegalArgumentException e$iv) {
            Void void_ = JsonReader.fail$default((JsonReader)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return by;
    }

    /*
     * WARNING - void declaration
     */
    public short decodeShort() {
        short s;
        void $this$parseString$iv;
        JsonReader jsonReader = this.reader;
        String expectedType$iv = "short";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.takeString();
        try {
            String $this$parseString = input$iv;
            boolean bl = false;
            String string = $this$parseString;
            boolean bl2 = false;
            s = Short.parseShort(string);
        }
        catch (IllegalArgumentException e$iv) {
            Void void_ = JsonReader.fail$default((JsonReader)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    public int decodeInt() {
        int n;
        void $this$parseString$iv;
        JsonReader jsonReader = this.reader;
        String expectedType$iv = "int";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.takeString();
        try {
            String $this$parseString = input$iv;
            boolean bl = false;
            String string = $this$parseString;
            boolean bl2 = false;
            n = Integer.parseInt(string);
        }
        catch (IllegalArgumentException e$iv) {
            Void void_ = JsonReader.fail$default((JsonReader)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public long decodeLong() {
        long l;
        void $this$parseString$iv;
        JsonReader jsonReader = this.reader;
        String expectedType$iv = "long";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.takeString();
        try {
            String $this$parseString = input$iv;
            boolean bl = false;
            String string = $this$parseString;
            boolean bl2 = false;
            l = Long.parseLong(string);
        }
        catch (IllegalArgumentException e$iv) {
            Void void_ = JsonReader.fail$default((JsonReader)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    public float decodeFloat() {
        block8: {
            block7: {
                var2_1 = this.reader;
                expectedType$iv = "float";
                $i$f$parseString = false;
                input$iv = $this$parseString$iv.takeString();
                try {
                    $this$parseString = input$iv;
                    $i$a$-parseString-StreamingJsonDecoder$decodeFloat$result$1 = false;
                    var8_12 = $this$parseString;
                    var9_13 = false;
                    v0 = Float.parseFloat(var8_12);
                }
                catch (IllegalArgumentException e$iv) {
                    v1 = JsonReader.fail$default((JsonReader)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, 2, null);
                    throw new KotlinNothingValueException();
                }
                result = v0;
                specialFp = this.getJson().getConfiguration$kotlinx_serialization_json().allowSpecialFloatingPointValues;
                if (specialFp) break block7;
                var3_4 = result;
                var4_5 = false;
                var5_7 = var3_4;
                var6_10 = false;
                if (Float.isInfinite(var5_7)) ** GOTO lbl-1000
                var5_7 = var3_4;
                var6_10 = false;
                if (!Float.isNaN(var5_7)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) break block8;
            }
            return result;
        }
        v3 = JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.reader, Float.valueOf(result));
        throw new KotlinNothingValueException();
    }

    /*
     * Unable to fully structure code
     */
    public double decodeDouble() {
        block8: {
            block7: {
                var3_1 = this.reader;
                expectedType$iv = "double";
                $i$f$parseString = false;
                input$iv = $this$parseString$iv.takeString();
                try {
                    $this$parseString = input$iv;
                    $i$a$-parseString-StreamingJsonDecoder$decodeDouble$result$1 = false;
                    var9_12 = $this$parseString;
                    var10_14 = false;
                    v0 = Double.parseDouble(var9_12);
                }
                catch (IllegalArgumentException e$iv) {
                    v1 = JsonReader.fail$default((JsonReader)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, 2, null);
                    throw new KotlinNothingValueException();
                }
                result = v0;
                specialFp = this.getJson().getConfiguration$kotlinx_serialization_json().allowSpecialFloatingPointValues;
                if (specialFp) break block7;
                var4_4 = result;
                var6_7 = false;
                var7_10 = var4_4;
                var9_13 = false;
                if (Double.isInfinite(var7_10)) ** GOTO lbl-1000
                var7_10 = var4_4;
                var9_13 = false;
                if (!Double.isNaN(var7_10)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) break block8;
            }
            return result;
        }
        v3 = JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.reader, result);
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    public char decodeChar() {
        char c;
        void $this$parseString$iv;
        JsonReader jsonReader = this.reader;
        String expectedType$iv = "char";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.takeString();
        try {
            String $this$parseString = input$iv;
            boolean bl = false;
            c = StringsKt.single((CharSequence)$this$parseString);
        }
        catch (IllegalArgumentException e$iv) {
            Void void_ = JsonReader.fail$default((JsonReader)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return c;
    }

    @NotNull
    public String decodeString() {
        return this.configuration.isLenient ? this.reader.takeString() : this.reader.takeStringQuoted();
    }

    @NotNull
    public Decoder decodeInline(@NotNull SerialDescriptor inlineDescriptor) {
        Intrinsics.checkNotNullParameter((Object)inlineDescriptor, (String)"inlineDescriptor");
        return StreamingJsonEncoderKt.isUnsignedNumber(inlineDescriptor) ? (Decoder)new JsonDecoderForUnsignedTypes(this.reader, this.getJson()) : (Decoder)this;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        return TreeJsonDecoderKt.getElementIndexOrThrow(enumDescriptor, this.decodeString());
    }

    @Override
    @NotNull
    public Json getJson() {
        return this.json;
    }

    public StreamingJsonDecoder(@NotNull Json json, @NotNull WriteMode mode, @NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.json = json;
        this.mode = mode;
        this.reader = reader;
        this.serializersModule = this.getJson().getSerializersModule();
        this.currentIndex = -1;
        this.configuration = this.getJson().getConfiguration$kotlinx_serialization_json();
    }

    @ExperimentalSerializationApi
    @Nullable
    public <T> T decodeNullableSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return JsonDecoder.DefaultImpls.decodeNullableSerializableValue(this, deserializer);
    }

    public int decodeCollectionSize(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return JsonDecoder.DefaultImpls.decodeCollectionSize(this, descriptor2);
    }

    @ExperimentalSerializationApi
    public boolean decodeSequentially() {
        return JsonDecoder.DefaultImpls.decodeSequentially(this);
    }
}

