/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.ByteArrayPool;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.JsonWriter;
import kotlinx.serialization.json.internal.StringOpsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0011\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\nH\u0082\bJ\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0016J\t\u0010\u0017\u001a\u00020\nH\u0082\bJ\u0011\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\nH\u0082\bJ\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010#\u001a\u00020\nH\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkotlinx/serialization/json/internal/JsonToJavaStreamWriter;", "Lkotlinx/serialization/json/internal/JsonWriter;", "stream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "buffer", "", "charArray", "", "indexInBuffer", "", "appendStringSlowPath", "", "currentSize", "string", "", "ensure", "bytesCount", "ensureTotalCapacity", "oldSize", "additional", "flush", "release", "rest", "write", "byte", "text", "writeChar", "char", "", "writeLong", "value", "", "writeQuoted", "writeUtf8", "count", "writeUtf8CodePoint", "codePoint", "kotlinx-serialization-json"})
public final class JsonToJavaStreamWriter
implements JsonWriter {
    @NotNull
    private final OutputStream stream;
    @NotNull
    private final byte[] buffer;
    @NotNull
    private char[] charArray;
    private int indexInBuffer;

    public JsonToJavaStreamWriter(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        this.buffer = ByteArrayPool.INSTANCE.take();
        this.charArray = CharArrayPool.INSTANCE.take();
    }

    @Override
    public void writeLong(long value) {
        this.write(String.valueOf(value));
    }

    @Override
    public void writeChar(char c) {
        this.writeUtf8CodePoint(c);
    }

    @Override
    public void write(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int length = text.length();
        this.ensureTotalCapacity(0, length);
        String string = text;
        char[] cArray = this.charArray;
        int n = 0;
        int n2 = 0;
        string.getChars(n2, length, cArray, n);
        this.writeUtf8(this.charArray, length);
    }

    @Override
    public void writeQuoted(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.ensureTotalCapacity(0, text.length() + 2);
        char[] arr = this.charArray;
        arr[0] = 34;
        int length = text.length();
        String string = text;
        int n = 1;
        int n2 = 0;
        string.getChars(n2, length, arr, n);
        n = 1 + length;
        for (int i = 1; i < n; ++i) {
            char ch = arr[i];
            if (ch >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
            this.appendStringSlowPath(i, text);
            return;
        }
        arr[length + 1] = 34;
        this.writeUtf8(arr, length + 2);
        this.flush();
    }

    private final void appendStringSlowPath(int currentSize, String string) {
        int sz = currentSize;
        int n = string.length();
        for (int i = currentSize - 1; i < n; ++i) {
            sz = this.ensureTotalCapacity(sz, 2);
            char ch = string.charAt(i);
            if (ch < StringOpsKt.getESCAPE_MARKERS().length) {
                byte marker = StringOpsKt.getESCAPE_MARKERS()[ch];
                if (marker == 0) {
                    this.charArray[sz++] = ch;
                    continue;
                }
                if (marker == 1) {
                    String escapedString;
                    Intrinsics.checkNotNull((Object)StringOpsKt.getESCAPE_STRINGS()[ch]);
                    sz = this.ensureTotalCapacity(sz, escapedString.length());
                    String string2 = escapedString;
                    char[] cArray = this.charArray;
                    int n2 = 0;
                    int n3 = escapedString.length();
                    string2.getChars(n2, n3, cArray, sz);
                    sz += escapedString.length();
                    continue;
                }
                this.charArray[sz] = 92;
                this.charArray[sz + 1] = (char)marker;
                sz += 2;
                continue;
            }
            this.charArray[sz++] = ch;
        }
        this.ensureTotalCapacity(sz, 1);
        this.charArray[sz++] = 34;
        this.writeUtf8(this.charArray, sz);
        this.flush();
    }

    private final int ensureTotalCapacity(int oldSize, int additional) {
        int newSize = oldSize + additional;
        if (this.charArray.length <= newSize) {
            char[] cArray = Arrays.copyOf(this.charArray, RangesKt.coerceAtLeast((int)newSize, (int)(oldSize * 2)));
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOf(this, newSize)");
            this.charArray = cArray;
        }
        return oldSize;
    }

    @Override
    public void release() {
        this.flush();
        CharArrayPool.INSTANCE.release(this.charArray);
        ByteArrayPool.INSTANCE.release(this.buffer);
    }

    private final void flush() {
        this.stream.write(this.buffer, 0, this.indexInBuffer);
        this.indexInBuffer = 0;
    }

    private final void ensure(int bytesCount) {
        boolean $i$f$ensure = false;
        JsonToJavaStreamWriter this_$iv = this;
        boolean $i$f$rest = false;
        if (this_$iv.buffer.length - this_$iv.indexInBuffer < bytesCount) {
            this.flush();
        }
    }

    private final void write(int n) {
        boolean $i$f$write = false;
        int n2 = this.indexInBuffer;
        this.indexInBuffer = n2 + 1;
        this.buffer[n2] = (byte)n;
    }

    private final int rest() {
        boolean $i$f$rest = false;
        return this.buffer.length - this.indexInBuffer;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeUtf8(char[] string, int count) {
        if (!(count >= 0)) {
            boolean $i$a$-require-JsonToJavaStreamWriter$writeUtf8$32 = false;
            String $i$a$-require-JsonToJavaStreamWriter$writeUtf8$32 = "count < 0";
            throw new IllegalArgumentException($i$a$-require-JsonToJavaStreamWriter$writeUtf8$32.toString());
        }
        if (!(count <= string.length)) {
            boolean $i$a$-require-JsonToJavaStreamWriter$writeUtf8$42 = false;
            String $i$a$-require-JsonToJavaStreamWriter$writeUtf8$42 = "count > string.length: " + count + " > " + string.length;
            throw new IllegalArgumentException($i$a$-require-JsonToJavaStreamWriter$writeUtf8$42.toString());
        }
        int i = 0;
        while (i < count) {
            JsonToJavaStreamWriter this_$iv;
            char low;
            char c;
            block17: {
                void byte$iv;
                JsonToJavaStreamWriter this_$iv2;
                block16: {
                    boolean $i$f$rest;
                    JsonToJavaStreamWriter this_$iv$iv2;
                    c = string[i];
                    if (c < '\u0080') {
                        JsonToJavaStreamWriter this_$iv3;
                        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
                        int bytesCount$iv = 1;
                        int $i$f$ensure = 0;
                        this_$iv$iv2 = this_$iv3;
                        $i$f$rest = false;
                        if (this_$iv$iv2.buffer.length - this_$iv$iv2.indexInBuffer < bytesCount$iv) {
                            super.flush();
                        }
                        this_$iv3 = this;
                        boolean $i$f$write = false;
                        $i$f$ensure = this_$iv3.indexInBuffer;
                        this_$iv3.indexInBuffer = $i$f$ensure + 1;
                        this_$iv3.buffer[$i$f$ensure] = (byte)c;
                        JsonToJavaStreamWriter this_$iv222 = this;
                        boolean $i$f$rest2 = false;
                        int this_$iv222 = ++i + (this_$iv222.buffer.length - this_$iv222.indexInBuffer);
                        int runLimit = Math.min(count, this_$iv222);
                        while (i < runLimit && (c = string[i]) < '\u0080') {
                            JsonToJavaStreamWriter this_$iv4 = this;
                            boolean $i$f$write2 = false;
                            int this_$iv$iv2 = this_$iv4.indexInBuffer;
                            this_$iv4.indexInBuffer = this_$iv$iv2 + 1;
                            this_$iv4.buffer[this_$iv$iv2] = (byte)c;
                            ++i;
                        }
                        continue;
                    }
                    if (c < '\u0800') {
                        JsonToJavaStreamWriter this_$iv5;
                        JsonToJavaStreamWriter runLimit = this;
                        int bytesCount$iv = 2;
                        boolean $i$f$ensure = false;
                        this_$iv$iv2 = this_$iv5;
                        $i$f$rest = false;
                        if (this_$iv$iv2.buffer.length - this_$iv$iv2.indexInBuffer < bytesCount$iv) {
                            super.flush();
                        }
                        this_$iv5 = this;
                        int byte$iv2 = c >> 6 | 0xC0;
                        boolean $i$f$write = false;
                        int this_$iv$iv2 = this_$iv5.indexInBuffer;
                        this_$iv5.indexInBuffer = this_$iv$iv2 + 1;
                        this_$iv5.buffer[this_$iv$iv2] = (byte)byte$iv2;
                        this_$iv5 = this;
                        byte$iv2 = c & 0x3F | 0x80;
                        $i$f$write = false;
                        this_$iv$iv2 = this_$iv5.indexInBuffer;
                        this_$iv5.indexInBuffer = this_$iv$iv2 + 1;
                        this_$iv5.buffer[this_$iv$iv2] = (byte)byte$iv2;
                        ++i;
                        continue;
                    }
                    if (c < '\ud800' || c > '\udfff') {
                        JsonToJavaStreamWriter this_$iv6 = this;
                        int bytesCount$iv = 3;
                        boolean $i$f$ensure = false;
                        this_$iv$iv2 = this_$iv6;
                        $i$f$rest = false;
                        if (this_$iv$iv2.buffer.length - this_$iv$iv2.indexInBuffer < bytesCount$iv) {
                            this_$iv6.flush();
                        }
                        this_$iv6 = this;
                        int byte$iv3 = c >> 12 | 0xE0;
                        boolean $i$f$write = false;
                        int this_$iv$iv3 = this_$iv6.indexInBuffer;
                        this_$iv6.indexInBuffer = this_$iv$iv3 + 1;
                        this_$iv6.buffer[this_$iv$iv3] = (byte)byte$iv3;
                        this_$iv6 = this;
                        byte$iv3 = c >> 6 & 0x3F | 0x80;
                        $i$f$write = false;
                        this_$iv$iv3 = this_$iv6.indexInBuffer;
                        this_$iv6.indexInBuffer = this_$iv$iv3 + 1;
                        this_$iv6.buffer[this_$iv$iv3] = (byte)byte$iv3;
                        this_$iv6 = this;
                        byte$iv3 = c & 0x3F | 0x80;
                        $i$f$write = false;
                        this_$iv$iv3 = this_$iv6.indexInBuffer;
                        this_$iv6.indexInBuffer = this_$iv$iv3 + 1;
                        this_$iv6.buffer[this_$iv$iv3] = (byte)byte$iv3;
                        ++i;
                        continue;
                    }
                    char c2 = low = i + 1 < count ? string[i + 1] : (char)'\u0000';
                    if (c > '\udbff') break block16;
                    if ('\udc00' <= low ? low < '\ue000' : false) break block17;
                }
                JsonToJavaStreamWriter byte$iv4 = this;
                int bytesCount$iv = 1;
                boolean $i$f$ensure = false;
                void this_$iv$iv42 = this_$iv2;
                boolean $i$f$rest = false;
                if (this_$iv$iv42.buffer.length - this_$iv$iv42.indexInBuffer < bytesCount$iv) {
                    super.flush();
                }
                this_$iv2 = this;
                bytesCount$iv = 63;
                boolean $i$f$write = false;
                int this_$iv$iv42 = this_$iv2.indexInBuffer;
                this_$iv2.indexInBuffer = this_$iv$iv42 + 1;
                this_$iv2.buffer[this_$iv$iv42] = (byte)byte$iv;
                ++i;
                continue;
            }
            int codePoint = 65536 + ((c & 0x3FF) << 10 | low & 0x3FF);
            JsonToJavaStreamWriter byte$iv = this;
            int bytesCount$iv = 4;
            boolean $i$f$ensure = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$rest = false;
            if (this_$iv$iv.buffer.length - this_$iv$iv.indexInBuffer < bytesCount$iv) {
                super.flush();
            }
            this_$iv = this;
            int byte$iv5 = codePoint >> 18 | 0xF0;
            boolean $i$f$write = false;
            int n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv5;
            this_$iv = this;
            byte$iv5 = codePoint >> 12 & 0x3F | 0x80;
            $i$f$write = false;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv5;
            this_$iv = this;
            byte$iv5 = codePoint >> 6 & 0x3F | 0x80;
            $i$f$write = false;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv5;
            this_$iv = this;
            byte$iv5 = codePoint & 0x3F | 0x80;
            $i$f$write = false;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv5;
            i += 2;
        }
    }

    private final void writeUtf8CodePoint(int codePoint) {
        if (codePoint < 128) {
            JsonToJavaStreamWriter this_$iv;
            JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
            int bytesCount$iv = 1;
            int $i$f$ensure = 0;
            void this_$iv$iv = this_$iv;
            boolean $i$f$rest = false;
            if (this_$iv$iv.buffer.length - this_$iv$iv.indexInBuffer < bytesCount$iv) {
                super.flush();
            }
            this_$iv = this;
            boolean $i$f$write = false;
            $i$f$ensure = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = $i$f$ensure + 1;
            this_$iv.buffer[$i$f$ensure] = (byte)codePoint;
        } else if (codePoint < 2048) {
            JsonToJavaStreamWriter this_$iv = this;
            int bytesCount$iv = 2;
            boolean $i$f$ensure = false;
            JsonToJavaStreamWriter this_$iv$iv22 = this_$iv;
            boolean $i$f$rest = false;
            if (this_$iv$iv22.buffer.length - this_$iv$iv22.indexInBuffer < bytesCount$iv) {
                this_$iv.flush();
            }
            this_$iv = this;
            int byte$iv = codePoint >> 6 | 0xC0;
            boolean $i$f$write = false;
            int this_$iv$iv22 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv22 + 1;
            this_$iv.buffer[this_$iv$iv22] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint & 0x3F | 0x80;
            $i$f$write = false;
            this_$iv$iv22 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv22 + 1;
            this_$iv.buffer[this_$iv$iv22] = (byte)byte$iv;
        } else {
            boolean bl = 55296 <= codePoint ? codePoint < 57344 : false;
            if (bl) {
                JsonToJavaStreamWriter this_$iv = this;
                int bytesCount$iv = 1;
                boolean $i$f$ensure = false;
                JsonToJavaStreamWriter this_$iv$iv32 = this_$iv;
                boolean $i$f$rest = false;
                if (this_$iv$iv32.buffer.length - this_$iv$iv32.indexInBuffer < bytesCount$iv) {
                    this_$iv.flush();
                }
                this_$iv = this;
                int byte$iv = 63;
                boolean $i$f$write = false;
                int this_$iv$iv32 = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = this_$iv$iv32 + 1;
                this_$iv.buffer[this_$iv$iv32] = (byte)byte$iv;
            } else if (codePoint < 65536) {
                JsonToJavaStreamWriter this_$iv = this;
                int bytesCount$iv = 3;
                boolean $i$f$ensure = false;
                JsonToJavaStreamWriter this_$iv$iv42 = this_$iv;
                boolean $i$f$rest = false;
                if (this_$iv$iv42.buffer.length - this_$iv$iv42.indexInBuffer < bytesCount$iv) {
                    this_$iv.flush();
                }
                this_$iv = this;
                int byte$iv = codePoint >> 12 | 0xE0;
                boolean $i$f$write = false;
                int this_$iv$iv42 = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = this_$iv$iv42 + 1;
                this_$iv.buffer[this_$iv$iv42] = (byte)byte$iv;
                this_$iv = this;
                byte$iv = codePoint >> 6 & 0x3F | 0x80;
                $i$f$write = false;
                this_$iv$iv42 = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = this_$iv$iv42 + 1;
                this_$iv.buffer[this_$iv$iv42] = (byte)byte$iv;
                this_$iv = this;
                byte$iv = codePoint & 0x3F | 0x80;
                $i$f$write = false;
                this_$iv$iv42 = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = this_$iv$iv42 + 1;
                this_$iv.buffer[this_$iv$iv42] = (byte)byte$iv;
            } else if (codePoint <= 0x10FFFF) {
                JsonToJavaStreamWriter this_$iv = this;
                int bytesCount$iv = 4;
                boolean $i$f$ensure = false;
                JsonToJavaStreamWriter this_$iv$iv = this_$iv;
                boolean $i$f$rest = false;
                if (this_$iv$iv.buffer.length - this_$iv$iv.indexInBuffer < bytesCount$iv) {
                    this_$iv.flush();
                }
                this_$iv = this;
                int byte$iv = codePoint >> 18 | 0xF0;
                boolean $i$f$write = false;
                int n = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = n + 1;
                this_$iv.buffer[n] = (byte)byte$iv;
                this_$iv = this;
                byte$iv = codePoint >> 12 & 0x3F | 0x80;
                $i$f$write = false;
                n = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = n + 1;
                this_$iv.buffer[n] = (byte)byte$iv;
                this_$iv = this;
                byte$iv = codePoint >> 6 & 0x3F | 0x80;
                $i$f$write = false;
                n = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = n + 1;
                this_$iv.buffer[n] = (byte)byte$iv;
                this_$iv = this;
                byte$iv = codePoint & 0x3F | 0x80;
                $i$f$write = false;
                n = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = n + 1;
                this_$iv.buffer[n] = (byte)byte$iv;
            } else {
                throw new JsonEncodingException("Unexpected code point: " + codePoint);
            }
        }
    }
}

