/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.ChannelException;
import org.jgroups.blocks.LockManager;
import org.jgroups.blocks.LockNotGrantedException;
import org.jgroups.blocks.LockNotReleasedException;
import org.jgroups.blocks.TwoPhaseVotingAdapter;
import org.jgroups.blocks.TwoPhaseVotingListener;
import org.jgroups.blocks.VoteException;
import org.jgroups.blocks.VotingAdapter;

public class DistributedLockManager
implements TwoPhaseVotingListener,
LockManager {
    private static final long ACQUIRE_EXPIRATION = 5000L;
    private static final long VOTE_TIMEOUT = 10000L;
    private final HashMap preparedLocks = new HashMap();
    private final HashMap preparedReleases = new HashMap();
    private final HashMap heldLocks = new HashMap();
    private final TwoPhaseVotingAdapter votingAdapter;
    private final Object id;
    protected final Log log = LogFactory.getLog(this.getClass());

    public DistributedLockManager(VotingAdapter voteChannel, Object id) {
        this(new TwoPhaseVotingAdapter(voteChannel), id);
    }

    public DistributedLockManager(TwoPhaseVotingAdapter channel, Object id) {
        this.id = id;
        this.votingAdapter = channel;
        this.votingAdapter.addListener(this);
    }

    private boolean localLock(LockDecree lockDecree) {
        this.removeExpired(lockDecree);
        LockDecree localLock = (LockDecree)this.heldLocks.get(lockDecree.getKey());
        if (localLock == null) {
            lockDecree.commit();
            if (lockDecree.managerId.equals(this.id)) {
                this.heldLocks.put(lockDecree.getKey(), lockDecree);
            }
            return true;
        }
        return localLock.requester.equals(lockDecree.requester);
    }

    private boolean canLock(LockDecree decree) {
        this.removeExpired(decree);
        LockDecree lock = (LockDecree)this.heldLocks.get(decree.getKey());
        if (lock == null) {
            return true;
        }
        return lock.requester.equals(decree.requester);
    }

    private boolean canRelease(LockDecree decree) {
        this.removeExpired(decree);
        LockDecree lock = (LockDecree)this.heldLocks.get(decree.getKey());
        if (lock == null) {
            return true;
        }
        return lock.requester.equals(decree.requester);
    }

    private void removeExpired(LockDecree decree) {
        LockDecree localLock = (LockDecree)this.heldLocks.get(decree.getKey());
        if (localLock != null && !localLock.isValid()) {
            this.heldLocks.remove(localLock.getKey());
        }
    }

    private boolean localRelease(LockDecree lockDecree) {
        this.removeExpired(lockDecree);
        LockDecree localLock = (LockDecree)this.heldLocks.get(lockDecree.getKey());
        if (localLock == null) {
            return true;
        }
        if (localLock.requester.equals(lockDecree.requester)) {
            this.heldLocks.remove(lockDecree.getKey());
            return true;
        }
        return false;
    }

    public void lock(Object lockId, Object owner, int timeout) throws LockNotGrantedException, ChannelException {
        if (!(lockId instanceof Serializable) || !(owner instanceof Serializable)) {
            throw new ClassCastException("DistributedLockManager works only with serializable objects.");
        }
        boolean acquired = this.votingAdapter.vote(new AcquireLockDecree(lockId, owner, this.id), timeout);
        if (!acquired) {
            throw new LockNotGrantedException("Lock cannot be granted.");
        }
    }

    public void unlock(Object lockId, Object owner) throws LockNotReleasedException, ChannelException {
        if (!(lockId instanceof Serializable) || !(owner instanceof Serializable)) {
            throw new ClassCastException("DistributedLockManager works only with serializable objects.");
        }
        boolean released = this.votingAdapter.vote(new ReleaseLockDecree(lockId, owner, this.id), 10000L);
        if (!released) {
            throw new LockNotReleasedException("Lock cannot be unlocked.");
        }
    }

    private boolean checkPrepared(HashMap preparedContainer, LockDecree requestedDecree) {
        LockDecree preparedDecree = (LockDecree)preparedContainer.get(requestedDecree.getKey());
        if (preparedDecree != null && !preparedDecree.isValid()) {
            preparedContainer.remove(preparedDecree.getKey());
            preparedDecree = null;
        }
        if (preparedDecree != null) {
            return requestedDecree.requester.equals(preparedDecree.requester);
        }
        return true;
    }

    public synchronized boolean prepare(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            AcquireLockDecree acquireDecree = (AcquireLockDecree)decree;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Preparing to acquire decree " + acquireDecree.lockId));
            }
            if (!this.checkPrepared(this.preparedLocks, acquireDecree)) {
                return false;
            }
            if (this.canLock(acquireDecree)) {
                this.preparedLocks.put(acquireDecree.getKey(), acquireDecree);
                return true;
            }
            return false;
        }
        if (decree instanceof ReleaseLockDecree) {
            ReleaseLockDecree releaseDecree = (ReleaseLockDecree)decree;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Preparing to release decree " + releaseDecree.lockId));
            }
            if (!this.checkPrepared(this.preparedReleases, releaseDecree)) {
                return false;
            }
            if (this.canRelease(releaseDecree)) {
                this.preparedReleases.put(releaseDecree.getKey(), releaseDecree);
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized boolean commit(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Committing decree acquisition " + ((LockDecree)decree).lockId));
            }
            if (!this.checkPrepared(this.preparedLocks, (LockDecree)decree)) {
                return false;
            }
            if (this.localLock((LockDecree)decree)) {
                this.preparedLocks.remove(((LockDecree)decree).getKey());
                return true;
            }
            return false;
        }
        if (decree instanceof ReleaseLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Committing decree release " + ((LockDecree)decree).lockId));
            }
            if (!this.checkPrepared(this.preparedReleases, (LockDecree)decree)) {
                return false;
            }
            if (this.localRelease((LockDecree)decree)) {
                this.preparedReleases.remove(((LockDecree)decree).getKey());
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized void abort(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Aborting decree acquisition " + ((LockDecree)decree).lockId));
            }
            if (!this.checkPrepared(this.preparedLocks, (LockDecree)decree)) {
                return;
            }
            this.preparedLocks.remove(((LockDecree)decree).getKey());
        } else if (decree instanceof ReleaseLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Aborting decree release " + ((LockDecree)decree).lockId));
            }
            if (!this.checkPrepared(this.preparedReleases, (LockDecree)decree)) {
                return;
            }
            this.preparedReleases.remove(((LockDecree)decree).getKey());
        }
    }

    public static class ReleaseLockDecree
    extends LockDecree {
        ReleaseLockDecree(Object lockId, Object requester, Object managerId) {
            super(lockId, requester, managerId);
        }
    }

    public static class AcquireLockDecree
    extends LockDecree {
        private final long creationTime = System.currentTimeMillis();

        private AcquireLockDecree(LockDecree lockDecree) {
            this(lockDecree.lockId, lockDecree.requester, lockDecree.managerId);
        }

        private AcquireLockDecree(Object lockId, Object requester, Object managerId) {
            super(lockId, requester, managerId);
        }

        public boolean isValid() {
            boolean result = super.isValid();
            if (!this.commited && result) {
                result = this.creationTime + 5000L > System.currentTimeMillis();
            }
            return result;
        }
    }

    public static class LockDecree
    implements Serializable {
        protected final Object lockId;
        protected final Object requester;
        protected final Object managerId;
        protected boolean commited;

        private LockDecree(Object lockId, Object requester, Object managerId) {
            this.lockId = lockId;
            this.requester = requester;
            this.managerId = managerId;
        }

        public Object getKey() {
            return this.lockId;
        }

        public boolean isValid() {
            return true;
        }

        public void commit() {
            this.commited = true;
        }

        public int hashCode() {
            return this.lockId.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof LockDecree) {
                return ((LockDecree)other).lockId.equals(this.lockId);
            }
            return false;
        }
    }
}

