/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

class MyCanvas
extends Canvas {
    int field_size = 100;
    int num_fields = 4;
    int x_offset = 30;
    int y_offset = 30;
    final Font def_font = new Font("Helvetica", 1, 14);
    int[][] array = null;
    Dimension off_dimension = null;
    Image off_image = null;
    Graphics off_graphics = null;
    final Font def_font2 = new Font("Helvetica", 0, 12);
    static final Color checksum_col = Color.blue;
    int checksum = 0;

    public MyCanvas(int num_fields, int field_size, int x_offset, int y_offset) {
        this.num_fields = num_fields;
        this.field_size = field_size;
        this.x_offset = x_offset;
        this.y_offset = y_offset;
        this.array = new int[num_fields][num_fields];
        this.setBackground(Color.white);
        this.setSize(2 * x_offset + num_fields * field_size + 30, y_offset + num_fields * field_size + 50);
        for (int i = 0; i < num_fields; ++i) {
            for (int j = 0; j < num_fields; ++j) {
                this.array[i][j] = 0;
            }
        }
    }

    public void setFieldSize(int fs) {
        this.field_size = fs;
    }

    public void setNumFields(int nf) {
        this.num_fields = nf;
    }

    public void setXOffset(int o) {
        this.x_offset = o;
    }

    public void setYOffset(int o) {
        this.y_offset = o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addValueTo(int x, int y, int value) {
        int[][] nArray = this.array;
        synchronized (this.array) {
            int[] nArray2 = this.array[x];
            int n = y;
            nArray2[n] = nArray2[n] + value;
            this.repaint();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.array[x][y];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int subtractValueFrom(int x, int y, int value) {
        int[][] nArray = this.array;
        synchronized (this.array) {
            int[] nArray2 = this.array[x];
            int n = y;
            nArray2[n] = nArray2[n] - value;
            this.repaint();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.array[x][y];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int multiplyValueWith(int x, int y, int value) {
        int[][] nArray = this.array;
        synchronized (this.array) {
            int[] nArray2 = this.array[x];
            int n = y;
            nArray2[n] = nArray2[n] * value;
            this.repaint();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.array[x][y];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int divideValueBy(int x, int y, int value) {
        if (value == 0) {
            return this.array[x][y];
        }
        int[][] nArray = this.array;
        synchronized (this.array) {
            int[] nArray2 = this.array[x];
            int n = y;
            nArray2[n] = nArray2[n] / value;
            this.repaint();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.array[x][y];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(int x, int y, int value) {
        int[][] nArray = this.array;
        synchronized (this.array) {
            this.array[x][y] = value;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.repaint();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValueAt(int x, int y) {
        int[][] nArray = this.array;
        synchronized (this.array) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.array[x][y];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int[][] nArray = this.array;
        synchronized (this.array) {
            for (int i = 0; i < this.num_fields; ++i) {
                for (int j = 0; j < this.num_fields; ++j) {
                    this.array[i][j] = 0;
                }
            }
            this.checksum = this.checksum();
            this.repaint();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getState() {
        int[][] nArray = this.array;
        synchronized (this.array) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getCopyOfState() {
        int[][] retval = new int[this.num_fields][this.num_fields];
        int[][] nArray = this.array;
        synchronized (this.array) {
            for (int i = 0; i < this.num_fields; ++i) {
                System.arraycopy(this.array[i], 0, retval[i], 0, this.num_fields);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return retval;
        }
    }

    public void update() {
        this.checksum = this.checksum();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(Object new_state) {
        if (new_state == null) {
            return;
        }
        try {
            int[][] new_array = (int[][])new_state;
            int[][] nArray = this.array;
            synchronized (this.array) {
                this.clear();
                for (int i = 0; i < this.num_fields; ++i) {
                    System.arraycopy(new_array[i], 0, this.array[i], 0, this.num_fields);
                }
                this.checksum = this.checksum();
                this.repaint();
                // ** MonitorExit[var3_4] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checksum() {
        int retval = 0;
        int[][] nArray = this.array;
        synchronized (this.array) {
            for (int i = 0; i < this.num_fields; ++i) {
                for (int j = 0; j < this.num_fields; ++j) {
                    retval += this.array[i][j];
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return retval;
        }
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.off_graphics == null || d.width != this.off_dimension.width || d.height != this.off_dimension.height) {
            this.off_dimension = d;
            this.off_image = this.createImage(d.width, d.height);
            this.off_graphics = this.off_image.getGraphics();
        }
        this.off_graphics.setColor(this.getBackground());
        this.off_graphics.fillRect(0, 0, d.width, d.height);
        this.off_graphics.setColor(Color.black);
        this.off_graphics.setFont(this.def_font);
        this.drawEmptyBoard(this.off_graphics);
        this.drawNumbers(this.off_graphics);
        g.drawImage(this.off_image, 0, 0, this);
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    void drawEmptyBoard(Graphics g) {
        int i;
        int x = this.x_offset;
        int y = this.y_offset;
        Color old_col = g.getColor();
        g.setFont(this.def_font2);
        old_col = g.getColor();
        g.setColor(checksum_col);
        g.drawString("Checksum: " + this.checksum, this.x_offset + this.field_size, this.y_offset - 20);
        g.setFont(this.def_font);
        g.setColor(old_col);
        for (i = 0; i < this.num_fields; ++i) {
            for (int j = 0; j < this.num_fields; ++j) {
                g.drawRect(x, y, this.field_size, this.field_size);
                x += this.field_size;
            }
            g.drawString("" + (this.num_fields - i - 1), x + 20, y + this.field_size / 2);
            y += this.field_size;
            x = this.x_offset;
        }
        for (i = 0; i < this.num_fields; ++i) {
            g.drawString("" + i, this.x_offset + i * this.field_size + this.field_size / 2, y + 30);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawNumbers(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int len = 0;
        int[][] nArray = this.array;
        synchronized (this.array) {
            for (int i = 0; i < this.num_fields; ++i) {
                for (int j = 0; j < this.num_fields; ++j) {
                    String num = "" + this.array[i][j];
                    len = fm.stringWidth(num);
                    Point p = this.index2Coord(i, j);
                    g.drawString(num, p.x - len / 2, p.y);
                }
            }
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    Point coord2Index(int x, int y) {
        Point ret = new Point();
        ret.x = this.x_offset + x * this.field_size;
        ret.y = this.y_offset + (this.num_fields - 1 - y) * this.field_size;
        return ret;
    }

    Point index2Coord(int i, int j) {
        int x = this.x_offset + i * this.field_size + this.field_size / 2;
        int y = this.y_offset + this.num_fields * this.field_size - j * this.field_size - this.field_size / 2;
        return new Point(x, y);
    }
}

