/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class MessageDispatcherTest
implements RequestHandler {
    Channel channel;
    MessageDispatcher disp;
    RspList rsp_list;
    String props = null;

    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        this.disp = new MessageDispatcher(this.channel, null, null, this, false, true);
        this.channel.connect("MessageDispatcherTestGroup");
        MyThread t1 = new MyThread("one");
        MyThread t2 = new MyThread("two");
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        System.out.println("** Disconnecting channel");
        this.channel.disconnect();
        System.out.println("** Disconnecting channel -- done");
        System.out.println("** Closing channel");
        this.channel.close();
        System.out.println("** Closing channel -- done");
        System.out.println("** disp.stop()");
        this.disp.stop();
        System.out.println("** disp.stop() -- done");
    }

    public Object handle(Message msg) {
        System.out.println("handle(): " + msg.getObject());
        Util.sleepRandom(2000L);
        return "Success !";
    }

    public static void main(String[] args) {
        try {
            new MessageDispatcherTest().start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    class MyThread
    extends Thread {
        public MyThread(String name) {
            this.setName(name);
        }

        public void run() {
            for (int i = 0; i < 10; ++i) {
                System.out.println('[' + this.getName() + "] casting message #" + i);
                MessageDispatcherTest.this.rsp_list = MessageDispatcherTest.this.disp.castMessage(null, new Message(null, null, (Serializable)((Object)('[' + this.getName() + "] number #" + i))), 2, 0L);
                System.out.println('[' + this.getName() + "] responses:\n" + MessageDispatcherTest.this.rsp_list);
            }
        }
    }
}

