/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.TimeoutException;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class PromiseTest
extends TestCase {
    Promise p;

    public PromiseTest(String name) {
        super(name);
    }

    public void setUp() {
        this.p = new Promise();
    }

    public void tearDown() {
        this.p.reset();
    }

    public void testGetResultNoTimeout() {
        new ResultSetter(this.p, 500L).start();
        Object result = this.p.getResult(0L);
        PromiseTest.assertEquals((Object)result, (Object)Boolean.TRUE);
    }

    public void testGetResultNoTimeout_ResultAlreadySet() {
        new ResultSetter(this.p, 1L).start();
        Util.sleep(100L);
        Object result = this.p.getResult(0L);
        PromiseTest.assertEquals((Object)result, (Object)Boolean.TRUE);
    }

    public void testGetResultWithTimeout() {
        try {
            this.p.getResultWithTimeout(500L);
            PromiseTest.fail((String)"this should throw a TimeoutException");
        }
        catch (TimeoutException e) {
            PromiseTest.assertTrue((e != null ? 1 : 0) != 0);
        }
    }

    public void testGetResultWithTimeoutNoException() {
        Object ret = this.p.getResult(500L);
        PromiseTest.assertNull((Object)ret);
    }

    public void testGetResultWithTimeoutAndInterrupt() {
        new Interrupter(Thread.currentThread(), 100L).start();
        Object result = this.p.getResult(500L);
        PromiseTest.assertNull((Object)result);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{PromiseTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    class Interrupter
    extends Thread {
        long wait_time = 2000L;
        Thread target = null;

        Interrupter(Thread target, long wait_time) {
            this.target = target;
            this.wait_time = wait_time;
        }

        public void run() {
            Util.sleep(this.wait_time);
            this.target.interrupt();
        }
    }

    class ResultSetter
    extends Thread {
        long wait_time = 2000L;
        Promise target = null;

        ResultSetter(Promise target, long wait_time) {
            this.target = target;
            this.wait_time = wait_time;
        }

        public void run() {
            Util.sleep(this.wait_time);
            this.target.setResult(Boolean.TRUE);
        }
    }
}

