/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.net.Socket;
import java.net.SocketException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.stack.Utilities;
import org.jgroups.util.Util;

public class LazyRoutingClientTest
extends TestCase {
    private int routerPort = -1;
    private long routingClientReplyTimeout = 30000L;

    public LazyRoutingClientTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.routerPort = Utilities.startGossipRouter(30000L, 1000L, this.routingClientReplyTimeout);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        Utilities.stopGossipRouter();
    }

    public void testLazyClient() throws Exception {
        Socket s = new Socket("localhost", this.routerPort);
        DataInputStream dis = new DataInputStream(s.getInputStream());
        DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        int len = dis.readInt();
        byte[] buffer = new byte[len];
        dis.readFully(buffer, 0, len);
        IpAddress localAddr = (IpAddress)Util.objectFromByteBuffer(buffer);
        LazyRoutingClientTest.assertEquals((Object)localAddr.getIpAddress(), (Object)s.getLocalAddress());
        LazyRoutingClientTest.assertEquals((int)localAddr.getPort(), (int)s.getLocalPort());
        Thread.sleep(this.routingClientReplyTimeout + 500L);
        Exception expected13 = null;
        Exception expected14 = null;
        try {
            dos.writeInt(-10);
            dos.writeUTF("testgroup");
        }
        catch (Exception e) {
            expected14 = e;
        }
        try {
            dis.readInt();
        }
        catch (Exception e) {
            expected13 = e;
        }
        LazyRoutingClientTest.assertTrue((expected14 instanceof SocketException || expected13 instanceof EOFException ? 1 : 0) != 0);
        dis.close();
        dos.close();
        s.close();
    }

    public static Test suite() {
        TestSuite s = new TestSuite(LazyRoutingClientTest.class);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LazyRoutingClientTest.suite());
        System.exit(0);
    }
}

