/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import jnr.constants.Constant;
import jnr.constants.platform.Signal;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubySignalException;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.Interrupt;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

@JRubyClass(name={"Interrupt"}, parent="SignalException")
public class RubyInterrupt
extends RubySignalException {
    private static final ObjectAllocator INTERRUPT_ALLOCATOR = RubyInterrupt::new;

    static RubyClass define(Ruby runtime2, RubyClass signalExceptionClass) {
        RubyClass interruptClass = runtime2.defineClass("Interrupt", signalExceptionClass, INTERRUPT_ALLOCATOR);
        interruptClass.defineAnnotatedMethods(RubyInterrupt.class);
        return interruptClass;
    }

    protected RubyInterrupt(Ruby runtime2, RubyClass exceptionClass) {
        super(runtime2, exceptionClass);
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new Interrupt(message2, this);
    }

    @Override
    @JRubyMethod(optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        Ruby runtime2 = context.runtime;
        RubyFixnum signo2 = runtime2.newFixnum((Constant)Signal.SIGINT);
        args2 = args2.length > 0 ? ArraySupport.newCopy(signo2, args2) : new IRubyObject[]{signo2, runtime2.newString("Interrupt")};
        super.initialize(context, args2, block);
        return this;
    }
}

