/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.Comparator;

@Deprecated
public class Qsort {
    private static final int SIZE_THRESHOLD = 16;

    public static void sort(Object[] a, Comparator c) {
        if (a.length < 16) {
            Qsort.insertionsort(a, 0, a.length, c);
            return;
        }
        Qsort.quicksort_loop(a, 0, a.length, c);
    }

    public static void sort(Object[] a, int begin2, int end2, Comparator c) {
        if (begin2 < end2) {
            if (end2 - begin2 < 16) {
                Qsort.insertionsort(a, begin2, end2, c);
                return;
            }
            Qsort.quicksort_loop(a, begin2, end2, c);
        }
    }

    private static void endTest(Object[] a, int lo, int hi, Comparator c) {
        if (c.compare(a[lo], a[lo + 1]) <= 0) {
            if (c.compare(a[hi - 2], a[hi - 1]) > 0) {
                Qsort.bubbleUp(a, lo, hi - 1, c);
            }
        } else if (c.compare(a[hi - 2], a[hi - 1]) > 0) {
            Qsort.insertionsort(a, lo, hi, c);
        } else {
            Qsort.bubbleDown(a, lo, hi - 1, c);
        }
    }

    private static boolean seqtest(Object[] a, int lo, int hi, Comparator c) {
        for (int i2 = lo + 1; i2 < hi - 2; ++i2) {
            if (c.compare(a[i2], a[i2 + 1]) <= 0) continue;
            return false;
        }
        Qsort.endTest(a, lo, hi, c);
        return true;
    }

    private static boolean revtest(Object[] a, int lo, int hi, Comparator c) {
        int i2;
        for (i2 = lo + 1; i2 < hi - 2; ++i2) {
            if (c.compare(a[i2], a[i2 + 1]) >= 0) continue;
            return false;
        }
        i2 = lo;
        int j = hi - 1;
        while (i2 < j) {
            Qsort.swap(a, i2++, j--);
        }
        Qsort.endTest(a, lo, hi, c);
        return true;
    }

    private static void quicksort_loop(Object[] a, int lo, int hi, Comparator c) {
        ArrayList<int[]> stack = new ArrayList<int[]>(16);
        int[] entry = new int[]{lo, hi};
        while (!stack.isEmpty() || entry != null) {
            int[] p2;
            Object m3;
            Object m1;
            int t;
            if (entry == null) {
                entry = (int[])stack.remove(stack.size() - 1);
            }
            lo = entry[0];
            hi = entry[1];
            int midi = lo + (hi - lo) / 2;
            Object mid = a[midi];
            if (hi - lo >= 200) {
                t = (hi - lo) / 8;
                m1 = Qsort.med3(a[lo + t], a[lo + t * 2], a[lo + t * 3], c);
                m3 = Qsort.med3(a[midi + t], a[midi + t * 2], a[midi + t * 3], c);
            } else {
                t = (hi - lo) / 4;
                m1 = a[lo + t];
                m3 = a[midi + t];
            }
            mid = Qsort.med3(m1, mid, m3, c);
            if (hi - lo >= 63) {
                if (c.compare(m1, mid) <= 0 && c.compare(mid, m3) <= 0) {
                    if (Qsort.seqtest(a, lo, hi, c)) {
                        entry = null;
                        continue;
                    }
                } else if (c.compare(m1, mid) >= 0 && c.compare(mid, m3) >= 0 && Qsort.revtest(a, lo, hi, c)) {
                    entry = null;
                    continue;
                }
            }
            if (hi - (p2 = Qsort.partition(a, lo, hi, mid, c))[1] > 16 && p2[0] - lo > 16) {
                entry[0] = p2[1];
                entry[1] = hi;
                stack.add(entry);
                entry = new int[]{lo, p2[0]};
                continue;
            }
            if (hi - p2[1] > 16) {
                entry[0] = p2[1];
                entry[1] = hi;
                Qsort.insertionsort(a, lo, p2[0], c);
                continue;
            }
            if (p2[0] - lo > 16) {
                entry[0] = lo;
                entry[1] = p2[0];
                Qsort.insertionsort(a, p2[1], hi, c);
                continue;
            }
            Qsort.insertionsort(a, lo, p2[0], c);
            Qsort.insertionsort(a, p2[1], hi, c);
            entry = null;
        }
    }

    private static int[] partition(Object[] a, int lo1, int hi, Object x, Comparator comp) {
        int lo;
        int i2 = lo = lo1;
        int j = hi;
        int c = 0;
        while (true) {
            if (i2 < j && (c = comp.compare(a[i2], x)) <= 0) {
                if (c == 0) {
                    if (i2 > lo) {
                        Qsort.swap(a, lo++, i2);
                    } else {
                        ++lo;
                    }
                }
                ++i2;
                continue;
            }
            --j;
            while (j >= i2 && (c = comp.compare(x, a[j])) < 0) {
                --j;
            }
            if (i2 > j) break;
            if (c == 0) {
                Qsort.swap(a, i2, j);
                if (i2 > lo) {
                    Qsort.swap(a, lo++, i2);
                } else {
                    ++lo;
                }
            } else {
                Qsort.swap(a, i2, j);
            }
            ++i2;
        }
        int n = c = i2 >= hi ? hi - 1 : i2;
        while (c > lo1 && comp.compare(x, a[c]) < 0) {
            --c;
        }
        --lo;
        while (lo >= lo1 && c > lo) {
            Qsort.swap(a, lo1++, c--);
        }
        return new int[]{c > lo ? c + 1 : lo1, i2};
    }

    private static Object med3(Object lo, Object mid, Object hi, Comparator c) {
        if (c.compare(mid, lo) < 0) {
            if (c.compare(hi, mid) < 0) {
                return mid;
            }
            if (c.compare(hi, lo) < 0) {
                return hi;
            }
            return lo;
        }
        if (c.compare(hi, mid) < 0) {
            if (c.compare(hi, lo) < 0) {
                return lo;
            }
            return hi;
        }
        return mid;
    }

    private static void insertionsort(Object[] a, int lo, int hi, Comparator c) {
        for (int i2 = lo + 1; i2 < hi; ++i2) {
            int j;
            Object t = a[j];
            for (j = i2; j > lo && c.compare(t, a[j - 1]) < 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = t;
        }
    }

    private static void bubbleDown(Object[] a, int lo, int hi, Comparator c) {
        Object x = a[lo];
        while (lo < hi && c.compare(x, a[lo + 1]) > 0) {
            a[lo++] = a[lo];
        }
        a[lo] = x;
    }

    private static void bubbleUp(Object[] a, int lo, int hi, Comparator c) {
        Object x = a[hi];
        while (hi > lo && c.compare(x, a[hi - 1]) < 0) {
            a[hi--] = a[hi];
        }
        a[hi] = x;
    }

    private static void swap(Object[] a, int i2, int j) {
        Object t = a[i2];
        a[i2] = a[j];
        a[j] = t;
    }
}

