/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.springmvc.scanner;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jsondoc.core.annotation.ApiHeader;
import org.jsondoc.core.pojo.ApiDoc;
import org.jsondoc.core.pojo.ApiHeaderDoc;
import org.jsondoc.core.pojo.ApiMethodDoc;
import org.jsondoc.core.pojo.ApiParamDoc;
import org.jsondoc.core.pojo.ApiResponseObjectDoc;
import org.jsondoc.core.pojo.ApiVerb;
import org.jsondoc.core.scanner.AbstractJSONDocScanner;
import org.jsondoc.core.util.JSONDocType;
import org.jsondoc.core.util.JSONDocTypeBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

public class SpringJSONDocScanner
extends AbstractJSONDocScanner {
    public ApiDoc mergeApiDoc(Class<?> controller, ApiDoc apiDoc) {
        return apiDoc;
    }

    public ApiMethodDoc mergeApiMethodDoc(Method method, Class<?> controller, ApiMethodDoc apiMethodDoc) {
        apiMethodDoc.setVerb(this.getApiVerbFromSpringAnnotation(method, controller));
        apiMethodDoc.getProduces().addAll(this.getProducesFromSpringAnnotation(method, controller));
        apiMethodDoc.getConsumes().addAll(this.getConsumesFromSpringAnnotation(method, controller));
        apiMethodDoc.getHeaders().addAll(this.getHeadersFromSpringAnnotation(method, controller));
        apiMethodDoc.setResponse(this.getApiResponseObject(apiMethodDoc, method));
        apiMethodDoc.setResponsestatuscode(this.getResponseStatusCodeFromSpringAnnotation(apiMethodDoc, method));
        apiMethodDoc.setPath(this.getPathFromSpringAnnotation(apiMethodDoc, method, controller));
        apiMethodDoc.getQueryparameters().addAll(this.getQueryParamsFromSpringAnnotation(method, controller));
        return apiMethodDoc;
    }

    private String getResponseStatusCodeFromSpringAnnotation(ApiMethodDoc apiMethodDoc, Method method) {
        String responseStatusCode = apiMethodDoc.getResponsestatuscode();
        if (method.isAnnotationPresent(ResponseStatus.class)) {
            ResponseStatus responseStatus = method.getAnnotation(ResponseStatus.class);
            responseStatusCode = responseStatus.value().toString() + " - " + responseStatus.value().getReasonPhrase();
        }
        if (responseStatusCode == null) {
            responseStatusCode = HttpStatus.OK.toString();
        }
        return responseStatusCode;
    }

    public ApiParamDoc mergeApiPathParamDoc(Method method, int paramIndex, ApiParamDoc apiParamDoc) {
        Annotation[] parameterAnnotations;
        for (Annotation annotation : parameterAnnotations = method.getParameterAnnotations()[paramIndex]) {
            PathVariable pathVariable;
            if (!(annotation instanceof PathVariable) || (pathVariable = (PathVariable)annotation).value().isEmpty()) continue;
            apiParamDoc.setName(pathVariable.value());
        }
        return apiParamDoc;
    }

    public ApiParamDoc mergeApiQueryParamDoc(Method method, int paramIndex, ApiParamDoc apiParamDoc) {
        Annotation[] parameterAnnotations;
        for (Annotation annotation : parameterAnnotations = method.getParameterAnnotations()[paramIndex]) {
            if (!(annotation instanceof RequestParam)) continue;
            RequestParam requestParam = (RequestParam)annotation;
            if (!requestParam.value().isEmpty()) {
                apiParamDoc.setName(requestParam.value());
            }
            apiParamDoc.setRequired(String.valueOf(requestParam.required()));
            if (requestParam.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) continue;
            apiParamDoc.setDefaultvalue(requestParam.defaultValue());
        }
        return apiParamDoc;
    }

    private List<ApiParamDoc> getQueryParamsFromSpringAnnotation(Method method, Class<?> controller) {
        String[] splitParam;
        RequestMapping requestMapping;
        ArrayList<ApiParamDoc> apiParamDocs = new ArrayList<ApiParamDoc>();
        if (controller.isAnnotationPresent(RequestMapping.class) && (requestMapping = controller.getAnnotation(RequestMapping.class)).params().length > 0) {
            for (String param : requestMapping.params()) {
                splitParam = param.split("=");
                if (splitParam != null) {
                    apiParamDocs.add(new ApiParamDoc(splitParam[0], null, JSONDocTypeBuilder.build((JSONDocType)new JSONDocType(), String.class, null), "true", new String[]{splitParam[1]}, null, null));
                    continue;
                }
                apiParamDocs.add(new ApiParamDoc(param, null, JSONDocTypeBuilder.build((JSONDocType)new JSONDocType(), String.class, null), "true", new String[0], null, null));
            }
        }
        if (method.isAnnotationPresent(RequestMapping.class) && (requestMapping = method.getAnnotation(RequestMapping.class)).params().length > 0) {
            apiParamDocs.clear();
            for (String param : requestMapping.params()) {
                splitParam = param.split("=");
                if (splitParam.length > 1) {
                    apiParamDocs.add(new ApiParamDoc(splitParam[0], "", JSONDocTypeBuilder.build((JSONDocType)new JSONDocType(), String.class, null), "true", new String[]{splitParam[1]}, null, null));
                    continue;
                }
                apiParamDocs.add(new ApiParamDoc(param, "", JSONDocTypeBuilder.build((JSONDocType)new JSONDocType(), String.class, null), "true", new String[0], null, null));
            }
        }
        return apiParamDocs;
    }

    private ApiResponseObjectDoc getApiResponseObject(ApiMethodDoc apiMethodDoc, Method method) {
        if (apiMethodDoc.getResponse() != null && method.getReturnType().isAssignableFrom(ResponseEntity.class)) {
            apiMethodDoc.getResponse().getJsondocType().getType().remove(0);
        }
        return apiMethodDoc.getResponse();
    }

    private Set<ApiHeaderDoc> getHeadersFromSpringAnnotation(Method method, Class<?> controller) {
        Annotation[][] parameterAnnotations;
        List<String> headersStringList;
        LinkedHashSet<ApiHeaderDoc> headers = new LinkedHashSet<ApiHeaderDoc>();
        RequestMapping typeAnnotation = controller.getAnnotation(RequestMapping.class);
        RequestMapping methodAnnotation = method.getAnnotation(RequestMapping.class);
        if (typeAnnotation != null) {
            headersStringList = Arrays.asList(typeAnnotation.headers());
            this.addToHeaders(headers, headersStringList);
        }
        if (methodAnnotation != null) {
            headersStringList = Arrays.asList(methodAnnotation.headers());
            this.addToHeaders(headers, headersStringList);
        }
        for (Annotation[] annotations : parameterAnnotations = method.getParameterAnnotations()) {
            String[] stringArray;
            RequestHeader requestHeader = null;
            ApiHeader apiHeader = null;
            for (Annotation annotation : annotations) {
                if (RequestHeader.class.isAssignableFrom(annotation.annotationType())) {
                    requestHeader = (RequestHeader)annotation;
                }
                if (!ApiHeader.class.isAssignableFrom(annotation.annotationType())) continue;
                apiHeader = (ApiHeader)annotation;
            }
            if (requestHeader == null || apiHeader == null) continue;
            if (!requestHeader.value().isEmpty()) {
                String[] stringArray2;
                String string = requestHeader.value();
                String string2 = apiHeader.description();
                if (requestHeader.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
                    stringArray2 = new String[]{};
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = requestHeader.defaultValue();
                }
                headers.add(new ApiHeaderDoc(string, string2, stringArray2));
                continue;
            }
            String string = apiHeader.name();
            String string3 = apiHeader.description();
            if (requestHeader.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
                stringArray = new String[]{};
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = requestHeader.defaultValue();
            }
            headers.add(new ApiHeaderDoc(string, string3, stringArray));
        }
        return headers;
    }

    private void addToHeaders(Set<ApiHeaderDoc> headers, List<String> headersStringList) {
        for (String header : headersStringList) {
            String[] splitHeader = header.split("=");
            if (splitHeader.length > 1) {
                headers.add(new ApiHeaderDoc(splitHeader[0], null, new String[]{splitHeader[1]}));
                continue;
            }
            headers.add(new ApiHeaderDoc(splitHeader[0], null, new String[0]));
        }
    }

    private Set<String> getProducesFromSpringAnnotation(Method method, Class<?> controller) {
        RequestMapping requestMapping;
        LinkedHashSet<String> produces = new LinkedHashSet<String>();
        if (controller.isAnnotationPresent(RequestMapping.class) && (requestMapping = controller.getAnnotation(RequestMapping.class)).produces().length > 0) {
            produces.addAll(Arrays.asList(requestMapping.produces()));
        }
        if (method.isAnnotationPresent(RequestMapping.class) && (requestMapping = method.getAnnotation(RequestMapping.class)).produces().length > 0) {
            produces.clear();
            produces.addAll(Arrays.asList(requestMapping.produces()));
        }
        return produces;
    }

    private Set<String> getConsumesFromSpringAnnotation(Method method, Class<?> controller) {
        RequestMapping requestMapping;
        LinkedHashSet<String> consumes = new LinkedHashSet<String>();
        if (controller.isAnnotationPresent(RequestMapping.class) && (requestMapping = controller.getAnnotation(RequestMapping.class)).consumes().length > 0) {
            consumes.addAll(Arrays.asList(requestMapping.consumes()));
        }
        if (method.isAnnotationPresent(RequestMapping.class) && (requestMapping = method.getAnnotation(RequestMapping.class)).consumes().length > 0) {
            consumes.clear();
            consumes.addAll(Arrays.asList(requestMapping.consumes()));
        }
        return consumes;
    }

    private ApiVerb[] getApiVerbFromSpringAnnotation(Method method, Class<?> controller) {
        RequestMapping requestMapping;
        LinkedHashSet<ApiVerb> apiVerbs = new LinkedHashSet<ApiVerb>();
        if (controller.isAnnotationPresent(RequestMapping.class) && (requestMapping = controller.getAnnotation(RequestMapping.class)).method().length > 0) {
            for (RequestMethod requestMethod : requestMapping.method()) {
                apiVerbs.add(ApiVerb.valueOf((String)requestMethod.name()));
            }
        }
        if (method.isAnnotationPresent(RequestMapping.class)) {
            apiVerbs = new LinkedHashSet();
            requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping.method().length > 0) {
                for (RequestMethod requestMethod : requestMapping.method()) {
                    apiVerbs.add(ApiVerb.valueOf((String)requestMethod.name()));
                }
            }
        }
        if (apiVerbs.isEmpty()) {
            apiVerbs.add(ApiVerb.GET);
        }
        return apiVerbs.toArray(new ApiVerb[apiVerbs.size()]);
    }

    private String getPathFromSpringAnnotation(ApiMethodDoc apiMethodDoc, Method method, Class<?> controller) {
        RequestMapping requestMapping;
        StringBuffer pathStringBuffer = new StringBuffer();
        if (controller.isAnnotationPresent(RequestMapping.class) && (requestMapping = controller.getAnnotation(RequestMapping.class)).value().length > 0) {
            pathStringBuffer.append(requestMapping.value()[0]);
        }
        if (method.isAnnotationPresent(RequestMapping.class) && (requestMapping = method.getAnnotation(RequestMapping.class)).value().length > 0) {
            pathStringBuffer.append(requestMapping.value()[0]);
        }
        return pathStringBuffer.toString();
    }
}

