/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.springmvc.scanner.builder;

import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringPathBuilder {
    public static Set<String> buildPath(Method method) {
        RequestMapping requestMapping;
        Class<?> controller = method.getDeclaringClass();
        HashSet<String> paths = new HashSet<String>();
        HashSet<Object> controllerMapping = new HashSet<String>();
        HashSet<Object> methodMapping = new HashSet<String>();
        if (controller.isAnnotationPresent(RequestMapping.class) && ((requestMapping = controller.getAnnotation(RequestMapping.class)).value().length > 0 || requestMapping.path().length > 0)) {
            controllerMapping = new HashSet<Object>(Arrays.asList(ObjectArrays.concat((Object[])requestMapping.value(), (Object[])requestMapping.path(), String.class)));
        }
        if (method.isAnnotationPresent(RequestMapping.class) && ((requestMapping = method.getAnnotation(RequestMapping.class)).value().length > 0 || requestMapping.path().length > 0)) {
            methodMapping = new HashSet<Object>(Arrays.asList(ObjectArrays.concat((Object[])requestMapping.value(), (Object[])requestMapping.path(), String.class)));
        }
        if (controllerMapping.isEmpty()) {
            controllerMapping.add("");
        }
        if (methodMapping.isEmpty()) {
            methodMapping.add("");
        }
        for (String controllerPath : controllerMapping) {
            for (String methodPath : methodMapping) {
                paths.add(controllerPath + methodPath);
            }
        }
        for (String path : paths) {
            if (!path.equals("")) continue;
            paths.remove(path);
            paths.add("/");
        }
        return paths;
    }
}

