/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.springmvc.scanner;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiObject;
import org.jsondoc.core.annotation.flow.ApiFlowSet;
import org.jsondoc.core.annotation.global.ApiChangelogSet;
import org.jsondoc.core.annotation.global.ApiGlobal;
import org.jsondoc.core.annotation.global.ApiMigrationSet;
import org.jsondoc.core.pojo.ApiDoc;
import org.jsondoc.core.pojo.ApiMethodDoc;
import org.jsondoc.core.pojo.ApiObjectDoc;
import org.jsondoc.core.pojo.JSONDocTemplate;
import org.jsondoc.core.scanner.AbstractJSONDocScanner;
import org.jsondoc.core.scanner.builder.JSONDocApiDocBuilder;
import org.jsondoc.core.scanner.builder.JSONDocApiMethodDocBuilder;
import org.jsondoc.core.scanner.builder.JSONDocApiObjectDocBuilder;
import org.jsondoc.core.util.JSONDocUtils;
import org.jsondoc.springmvc.scanner.builder.SpringConsumesBuilder;
import org.jsondoc.springmvc.scanner.builder.SpringHeaderBuilder;
import org.jsondoc.springmvc.scanner.builder.SpringObjectBuilder;
import org.jsondoc.springmvc.scanner.builder.SpringPathBuilder;
import org.jsondoc.springmvc.scanner.builder.SpringPathVariableBuilder;
import org.jsondoc.springmvc.scanner.builder.SpringProducesBuilder;
import org.jsondoc.springmvc.scanner.builder.SpringQueryParamBuilder;
import org.jsondoc.springmvc.scanner.builder.SpringRequestBodyBuilder;
import org.jsondoc.springmvc.scanner.builder.SpringResponseBuilder;
import org.jsondoc.springmvc.scanner.builder.SpringResponseStatusBuilder;
import org.jsondoc.springmvc.scanner.builder.SpringVerbBuilder;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

public abstract class AbstractSpringJSONDocScanner
extends AbstractJSONDocScanner {
    public Set<Method> jsondocMethods(Class<?> controller) {
        LinkedHashSet<Method> annotatedMethods = new LinkedHashSet<Method>();
        for (Method method : controller.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(RequestMapping.class)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    public static Set<Class<?>> buildJSONDocObjectsCandidates(Set<Class<?>> candidates, Class<?> clazz, Type type) {
        if (Map.class.isAssignableFrom(clazz)) {
            if (type instanceof ParameterizedType) {
                Type mapKeyType = ((ParameterizedType)type).getActualTypeArguments()[0];
                Type mapValueType = ((ParameterizedType)type).getActualTypeArguments()[1];
                if (mapKeyType instanceof Class) {
                    candidates.add((Class)mapKeyType);
                } else if (mapKeyType instanceof WildcardType) {
                    candidates.add(Void.class);
                } else {
                    candidates.addAll(AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(candidates, (Class)((ParameterizedType)mapKeyType).getRawType(), mapKeyType));
                }
                if (mapValueType instanceof Class) {
                    candidates.add((Class)mapValueType);
                } else if (mapValueType instanceof WildcardType) {
                    candidates.add(Void.class);
                } else {
                    candidates.addAll(AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(candidates, (Class)((ParameterizedType)mapValueType).getRawType(), mapValueType));
                }
            }
        } else if (Collection.class.isAssignableFrom(clazz)) {
            if (type instanceof ParameterizedType) {
                Type parametrizedType = ((ParameterizedType)type).getActualTypeArguments()[0];
                candidates.add(clazz);
                if (parametrizedType instanceof Class) {
                    candidates.add((Class)parametrizedType);
                } else if (parametrizedType instanceof WildcardType) {
                    candidates.add(Void.class);
                } else {
                    candidates.addAll(AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(candidates, (Class)((ParameterizedType)parametrizedType).getRawType(), parametrizedType));
                }
            } else if (type instanceof GenericArrayType) {
                candidates.addAll(AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(candidates, clazz, ((GenericArrayType)type).getGenericComponentType()));
            } else {
                candidates.add(clazz);
            }
        } else if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            candidates.addAll(AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(candidates, componentType, type));
        } else if (type instanceof ParameterizedType) {
            Type parametrizedType = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (parametrizedType instanceof Class) {
                candidates.add((Class)parametrizedType);
                candidates.addAll(AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(candidates, (Class)((ParameterizedType)type).getRawType(), parametrizedType));
            } else if (parametrizedType instanceof WildcardType) {
                candidates.add(Void.class);
                candidates.addAll(AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(candidates, (Class)((ParameterizedType)type).getRawType(), parametrizedType));
            } else if (parametrizedType instanceof TypeVariable) {
                candidates.add(Void.class);
                candidates.addAll(AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(candidates, (Class)((ParameterizedType)type).getRawType(), parametrizedType));
            } else {
                candidates.addAll(AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(candidates, (Class)((ParameterizedType)parametrizedType).getRawType(), parametrizedType));
            }
        } else {
            candidates.add(clazz);
        }
        return candidates;
    }

    private void appendSubCandidates(Class<?> clazz, Set<Class<?>> subCandidates) {
        if (clazz.isPrimitive() || clazz.equals(Class.class)) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            Class<?> fieldClass = field.getType();
            HashSet fieldCandidates = new HashSet();
            AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(fieldCandidates, fieldClass, field.getGenericType());
            for (Class clazz2 : fieldCandidates) {
                if (subCandidates.contains(clazz2)) continue;
                subCandidates.add(clazz2);
                this.appendSubCandidates(clazz2, subCandidates);
            }
        }
    }

    public Set<Class<?>> jsondocObjects(List<String> packages) {
        Set methodsAnnotatedWith = this.reflections.getMethodsAnnotatedWith(RequestMapping.class);
        HashSet candidates = Sets.newHashSet();
        HashSet subCandidates = Sets.newHashSet();
        HashSet elected = Sets.newHashSet();
        for (Method method : methodsAnnotatedWith) {
            AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(candidates, method.getReturnType(), method.getGenericReturnType());
            Integer requestBodyParameterIndex = JSONDocUtils.getIndexOfParameterWithAnnotation((Method)method, RequestBody.class);
            if (requestBodyParameterIndex == -1) continue;
            candidates.addAll(AbstractSpringJSONDocScanner.buildJSONDocObjectsCandidates(candidates, method.getParameterTypes()[requestBodyParameterIndex], method.getGenericParameterTypes()[requestBodyParameterIndex]));
        }
        for (Class clazz : candidates) {
            this.appendSubCandidates(clazz, subCandidates);
        }
        candidates.addAll(subCandidates);
        for (Class clazz : candidates) {
            if (clazz.getPackage() == null) continue;
            for (String pkg : packages) {
                if (!clazz.getPackage().getName().contains(pkg)) continue;
                elected.add(clazz);
            }
        }
        return elected;
    }

    public Set<Class<?>> jsondocFlows() {
        return this.reflections.getTypesAnnotatedWith(ApiFlowSet.class, true);
    }

    public ApiDoc initApiDoc(Class<?> controller) {
        ApiDoc apiDoc = new ApiDoc();
        apiDoc.setName(controller.getSimpleName());
        apiDoc.setDescription(controller.getSimpleName());
        return apiDoc;
    }

    public ApiDoc mergeApiDoc(Class<?> controller, ApiDoc apiDoc) {
        ApiDoc jsondocApiDoc = JSONDocApiDocBuilder.build(controller);
        BeanUtils.copyProperties((Object)jsondocApiDoc, (Object)apiDoc, (String[])new String[]{"methods", "supportedversions", "auth"});
        return apiDoc;
    }

    public ApiMethodDoc initApiMethodDoc(Method method, Map<Class<?>, JSONDocTemplate> jsondocTemplates) {
        ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
        apiMethodDoc.setPath(SpringPathBuilder.buildPath(method));
        apiMethodDoc.setMethod(method.getName());
        apiMethodDoc.setVerb(SpringVerbBuilder.buildVerb(method));
        apiMethodDoc.setProduces(SpringProducesBuilder.buildProduces(method));
        apiMethodDoc.setConsumes(SpringConsumesBuilder.buildConsumes(method));
        apiMethodDoc.setHeaders(SpringHeaderBuilder.buildHeaders(method));
        apiMethodDoc.setPathparameters(SpringPathVariableBuilder.buildPathVariable(method));
        apiMethodDoc.setQueryparameters(SpringQueryParamBuilder.buildQueryParams(method));
        apiMethodDoc.setBodyobject(SpringRequestBodyBuilder.buildRequestBody(method));
        apiMethodDoc.setResponse(SpringResponseBuilder.buildResponse(method));
        apiMethodDoc.setResponsestatuscode(SpringResponseStatusBuilder.buildResponseStatusCode(method));
        Integer index = JSONDocUtils.getIndexOfParameterWithAnnotation((Method)method, RequestBody.class);
        if (index != -1) {
            apiMethodDoc.getBodyobject().setJsondocTemplate(jsondocTemplates.get(method.getParameterTypes()[index]));
        }
        return apiMethodDoc;
    }

    public ApiMethodDoc mergeApiMethodDoc(Method method, ApiMethodDoc apiMethodDoc) {
        if (method.isAnnotationPresent(ApiMethod.class) && method.getDeclaringClass().isAnnotationPresent(Api.class)) {
            ApiMethodDoc jsondocApiMethodDoc = JSONDocApiMethodDocBuilder.build((Method)method);
            BeanUtils.copyProperties((Object)jsondocApiMethodDoc, (Object)apiMethodDoc, (String[])new String[]{"path", "verb", "produces", "consumes", "headers", "pathparameters", "queryparameters", "bodyobject", "response", "responsestatuscode", "apierrors", "supportedversions", "auth", "displayMethodAs"});
        }
        return apiMethodDoc;
    }

    public ApiObjectDoc initApiObjectDoc(Class<?> clazz) {
        return SpringObjectBuilder.buildObject(clazz);
    }

    public ApiObjectDoc mergeApiObjectDoc(Class<?> clazz, ApiObjectDoc apiObjectDoc) {
        if (clazz.isAnnotationPresent(ApiObject.class)) {
            ApiObjectDoc jsondocApiObjectDoc = JSONDocApiObjectDocBuilder.build(clazz);
            BeanUtils.copyProperties((Object)jsondocApiObjectDoc, (Object)apiObjectDoc);
        }
        return apiObjectDoc;
    }

    public Set<Class<?>> jsondocGlobal() {
        return this.reflections.getTypesAnnotatedWith(ApiGlobal.class, true);
    }

    public Set<Class<?>> jsondocChangelogs() {
        return this.reflections.getTypesAnnotatedWith(ApiChangelogSet.class, true);
    }

    public Set<Class<?>> jsondocMigrations() {
        return this.reflections.getTypesAnnotatedWith(ApiMigrationSet.class, true);
    }
}

