/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.springmvc.scanner.builder;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jsondoc.springmvc.scanner.SpringBuilderUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringConsumesBuilder {
    public static Set<String> buildConsumes(Method method) {
        RequestMapping requestMapping;
        LinkedHashSet<String> consumes = new LinkedHashSet<String>();
        Class<?> controller = method.getDeclaringClass();
        if (SpringBuilderUtils.isAnnotated(controller, RequestMapping.class) && (requestMapping = SpringBuilderUtils.getAnnotation(controller, RequestMapping.class)).consumes().length > 0) {
            consumes.addAll(Arrays.asList(requestMapping.consumes()));
        }
        if (SpringBuilderUtils.isAnnotated(method, RequestMapping.class) && (requestMapping = SpringBuilderUtils.getAnnotation(method, RequestMapping.class)).consumes().length > 0) {
            consumes.clear();
            consumes.addAll(Arrays.asList(requestMapping.consumes()));
        }
        if (consumes.isEmpty()) {
            consumes.add("application/json");
        }
        return consumes;
    }
}

