/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.springmvc.scanner.builder;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jsondoc.springmvc.scanner.SpringBuilderUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringProducesBuilder {
    public static Set<String> buildProduces(Method method) {
        RequestMapping requestMapping;
        LinkedHashSet<String> produces = new LinkedHashSet<String>();
        Class<?> controller = method.getDeclaringClass();
        if (SpringBuilderUtils.isAnnotated(controller, RequestMapping.class) && (requestMapping = SpringBuilderUtils.getAnnotation(controller, RequestMapping.class)).produces().length > 0) {
            produces.addAll(Arrays.asList(requestMapping.produces()));
        }
        if (SpringBuilderUtils.isAnnotated(method, RequestMapping.class) && (requestMapping = SpringBuilderUtils.getAnnotation(method, RequestMapping.class)).produces().length > 0) {
            produces.clear();
            produces.addAll(Arrays.asList(requestMapping.produces()));
        }
        if (produces.isEmpty()) {
            produces.add("application/json");
        }
        return produces;
    }
}

