/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHProject;
import org.kohsuke.github.GHProjectCard;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHProjectColumn
extends GHObject {
    protected GHProject project;
    private String name;
    private String project_url;

    GHProjectColumn lateBind(GitHub root) {
        return this;
    }

    GHProjectColumn lateBind(GHProject project) {
        this.project = project;
        return this.lateBind(project.root());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHProject getProject() throws IOException {
        if (this.project == null) {
            try {
                this.project = ((Requester)this.root().createRequest().withUrlPath(this.getProjectUrl().getPath(), new String[0])).fetch(GHProject.class);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public URL getProjectUrl() {
        return GitHubClient.parseURL(this.project_url);
    }

    public void setName(String name) throws IOException {
        this.edit("name", name);
    }

    private void edit(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("PATCH")).with(key, value)).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    protected String getApiRoute() {
        return String.format("/projects/columns/%d", this.getId());
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    public PagedIterable<GHProjectCard> listCards() throws IOException {
        GHProjectColumn column = this;
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/projects/columns/%d/cards", this.getId()), new String[0])).toIterable(GHProjectCard[].class, item -> item.lateBind(column));
    }

    public GHProjectCard createCard(String note) throws IOException {
        return ((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("note", note)).withUrlPath(String.format("/projects/columns/%d/cards", this.getId()), new String[0])).fetch(GHProjectCard.class).lateBind(this);
    }

    public GHProjectCard createCard(GHIssue issue) throws IOException {
        String contentType = issue instanceof GHPullRequest ? "PullRequest" : "Issue";
        return ((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("content_type", contentType)).with("content_id", issue.getId())).withUrlPath(String.format("/projects/columns/%d/cards", this.getId()), new String[0])).fetch(GHProjectCard.class).lateBind(this);
    }
}

