/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.modifiers.CounterConfig;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class CounterConfigGui
extends AbstractConfigGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private JLabeledTextField startField;
    private JLabeledTextField incrField;
    private JLabeledTextField endField;
    private JLabeledTextField varNameField;
    private JLabeledTextField formatField;
    private JCheckBox resetCounterOnEachThreadGroupIteration;
    private JCheckBox perUserField;

    public CounterConfigGui() {
        this.init();
    }

    public String getLabelResource() {
        return "counter_config_title";
    }

    public TestElement createTestElement() {
        CounterConfig config = new CounterConfig();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement c) {
        if (c instanceof CounterConfig) {
            CounterConfig config = (CounterConfig)c;
            config.setStart(this.startField.getText());
            config.setEnd(this.endField.getText());
            config.setIncrement(this.incrField.getText());
            config.setVarName(this.varNameField.getText());
            config.setFormat(this.formatField.getText());
            config.setIsPerUser(this.perUserField.isSelected());
            config.setResetOnThreadGroupIteration(this.resetCounterOnEachThreadGroupIteration.isEnabled() && this.resetCounterOnEachThreadGroupIteration.isSelected());
        }
        super.configureTestElement(c);
    }

    public void clearGui() {
        super.clearGui();
        this.startField.setText("");
        this.incrField.setText("");
        this.endField.setText("");
        this.varNameField.setText("");
        this.formatField.setText("");
        this.perUserField.setSelected(false);
        this.resetCounterOnEachThreadGroupIteration.setEnabled(false);
    }

    public void configure(TestElement element) {
        super.configure(element);
        CounterConfig config = (CounterConfig)element;
        this.startField.setText(config.getStartAsString());
        this.endField.setText(config.getEndAsString());
        this.incrField.setText(config.getIncrementAsString());
        this.formatField.setText(config.getFormat());
        this.varNameField.setText(config.getVarName());
        this.perUserField.setSelected(config.isPerUser());
        if (config.isPerUser()) {
            this.resetCounterOnEachThreadGroupIteration.setEnabled(true);
            this.resetCounterOnEachThreadGroupIteration.setSelected(config.isResetOnThreadGroupIteration());
        } else {
            this.resetCounterOnEachThreadGroupIteration.setEnabled(false);
        }
    }

    private void init() {
        this.setBorder(this.makeBorder());
        this.setLayout((LayoutManager)new VerticalLayout(5, 3));
        this.startField = new JLabeledTextField(JMeterUtils.getResString((String)"start"));
        this.incrField = new JLabeledTextField(JMeterUtils.getResString((String)"increment"));
        this.endField = new JLabeledTextField(JMeterUtils.getResString((String)"max"));
        this.varNameField = new JLabeledTextField(JMeterUtils.getResString((String)"var_name"));
        this.formatField = new JLabeledTextField(JMeterUtils.getResString((String)"format"));
        this.perUserField = new JCheckBox(JMeterUtils.getResString((String)"counter_per_user"));
        this.resetCounterOnEachThreadGroupIteration = new JCheckBox(JMeterUtils.getResString((String)"counter_reset_per_tg_iteration"));
        this.add(this.makeTitlePanel());
        this.add((Component)this.startField);
        this.add((Component)this.incrField);
        this.add((Component)this.endField);
        this.add((Component)this.formatField);
        this.add((Component)this.varNameField);
        this.add(this.perUserField);
        this.add(this.resetCounterOnEachThreadGroupIteration);
        this.perUserField.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.perUserField) {
            this.resetCounterOnEachThreadGroupIteration.setEnabled(this.perUserField.isSelected());
        }
    }
}

