/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.math.BigDecimal;
import javax.swing.JPanel;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.chartData.interfaces.IAxisDataSeries;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.LabelAxisProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.LineChartProperties;
import org.jCharts.properties.PointChartProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.properties.util.ChartFont;
import org.jCharts.types.ChartType;

public class RespTimeGraphChart
extends JPanel {
    private static final long serialVersionUID = 280L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected double[][] data;
    protected String title;
    protected String xAxisTitle;
    protected String yAxisTitle;
    protected String yAxisLabel;
    protected String[] xAxisLabels;
    protected int width;
    protected int height;
    protected String[] legendLabels = new String[]{JMeterUtils.getResString((String)"aggregate_graph_legend")};
    protected int maxYAxisScale;
    protected Font titleFont;
    protected Font legendFont;
    protected Color[] color;
    protected boolean showGrouping = true;
    protected int legendPlacement = 0;
    protected Shape pointShape = PointChartProperties.SHAPE_CIRCLE;
    protected float strokeWidth = 3.5f;

    public RespTimeGraphChart() {
    }

    public RespTimeGraphChart(LayoutManager layout) {
        super(layout);
    }

    public RespTimeGraphChart(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public void setData(double[][] data) {
        this.data = data;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setXAxisTitle(String title) {
        this.xAxisTitle = title;
    }

    public void setYAxisTitle(String title) {
        this.yAxisTitle = title;
    }

    public void setXAxisLabels(String[] labels) {
        this.xAxisLabels = labels;
    }

    public void setYAxisLabels(String label) {
        this.yAxisLabel = label;
    }

    public void setLegendLabels(String[] labels) {
        this.legendLabels = labels;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getMaxYAxisScale() {
        return this.maxYAxisScale;
    }

    public void setMaxYAxisScale(int maxYAxisScale) {
        this.maxYAxisScale = maxYAxisScale;
    }

    public Color[] getColor() {
        return this.color;
    }

    public void setColor(Color[] color) {
        this.color = color;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font legendFont) {
        this.legendFont = legendFont;
    }

    public int getLegendPlacement() {
        return this.legendPlacement;
    }

    public void setLegendPlacement(int legendPlacement) {
        this.legendPlacement = legendPlacement;
    }

    public Shape getPointShape() {
        return this.pointShape;
    }

    public void setPointShape(Shape pointShape) {
        this.pointShape = pointShape;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public boolean isShowGrouping() {
        return this.showGrouping;
    }

    public void setShowGrouping(boolean showGrouping) {
        this.showGrouping = showGrouping;
    }

    private void drawSample(String _title, String[] _xAxisLabels, String _yAxisTitle, String[] _legendLabels, double[][] _data, int _width, int _height, Color[] _color, Font legendFont, Graphics g) {
        double max = this.maxYAxisScale > 0 ? (double)this.maxYAxisScale : this.findMax(_data);
        try {
            if (_title.length() == 0) {
                _title = JMeterUtils.getResString((String)"graph_resp_time_title");
            }
            this.setPreferredSize(new Dimension(_width, _height));
            DataSeries dataSeries = new DataSeries(_xAxisLabels, null, _yAxisTitle, _title);
            Stroke[] strokes = new Stroke[_legendLabels.length];
            for (int i = 0; i < _legendLabels.length; ++i) {
                strokes[i] = new BasicStroke(this.strokeWidth, 1, 1, 5.0f);
            }
            Shape[] shapes = new Shape[_legendLabels.length];
            for (int i = 0; i < _legendLabels.length; ++i) {
                shapes[i] = this.pointShape;
            }
            LineChartProperties lineChartProperties = new LineChartProperties(strokes, shapes);
            Paint[] paints = new Paint[_color.length];
            System.arraycopy(_color, 0, paints, 0, _color.length);
            AxisChartDataSet axisChartDataSet = new AxisChartDataSet(_data, _legendLabels, paints, ChartType.LINE, (ChartTypeProperties)lineChartProperties);
            dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)axisChartDataSet);
            ChartProperties chartProperties = new ChartProperties();
            LabelAxisProperties xaxis = new LabelAxisProperties();
            DataAxisProperties yaxis = new DataAxisProperties();
            yaxis.setUseCommas(this.showGrouping);
            if (legendFont != null) {
                yaxis.setAxisTitleChartFont(new ChartFont(legendFont, (Paint)new Color(20)));
                yaxis.setScaleChartFont(new ChartFont(legendFont, (Paint)new Color(20)));
                xaxis.setAxisTitleChartFont(new ChartFont(legendFont, (Paint)new Color(20)));
                xaxis.setScaleChartFont(new ChartFont(legendFont, (Paint)new Color(20)));
            }
            if (this.titleFont != null) {
                chartProperties.setTitleFont(new ChartFont(this.titleFont, (Paint)new Color(0)));
            }
            try {
                BigDecimal round = new BigDecimal(max / 1000.0);
                round = round.setScale(0, 0);
                double topValue = round.doubleValue() * 1000.0;
                yaxis.setUserDefinedScale(0.0, 500.0);
                yaxis.setNumItems((int)(topValue / 500.0) + 1);
                yaxis.setShowGridLines(1);
            }
            catch (PropertyException e) {
                log.warn("", (Throwable)e);
            }
            AxisProperties axisProperties = new AxisProperties(xaxis, (LabelAxisProperties)yaxis);
            axisProperties.setXAxisLabelsAreVertical(true);
            LegendProperties legendProperties = new LegendProperties();
            legendProperties.setBorderStroke(null);
            legendProperties.setPlacement(this.legendPlacement);
            legendProperties.setIconBorderPaint((Paint)Color.WHITE);
            legendProperties.setIconBorderStroke((Stroke)new BasicStroke(0.0f, 2, 2));
            legendProperties.setNumColumns(-1);
            if (this.legendPlacement == 1 || this.legendPlacement == 2) {
                legendProperties.setNumColumns(1);
            }
            if (legendFont != null) {
                legendProperties.setFont(legendFont);
            }
            AxisChart axisChart = new AxisChart((IAxisDataSeries)dataSeries, chartProperties, axisProperties, legendProperties, _width, _height);
            axisChart.setGraphics2D((Graphics2D)g);
            axisChart.render();
        }
        catch (ChartDataException e) {
            log.warn("", (Throwable)e);
        }
        catch (PropertyException e) {
            log.warn("", (Throwable)e);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.data != null && this.title != null && this.xAxisLabels != null && this.yAxisLabel != null && this.yAxisTitle != null) {
            this.drawSample(this.title, this.xAxisLabels, this.yAxisTitle, this.legendLabels, this.data, this.width, this.height, this.color, this.legendFont, graphics);
        }
    }

    private double findMax(double[][] datas) {
        double max = 0.0;
        for (int i = 0; i < datas.length; ++i) {
            for (int j = 0; j < datas[i].length; ++j) {
                double value = datas[i][j];
                if (Double.isNaN(value) || !(value > max)) continue;
                max = value;
            }
        }
        return max;
    }
}

