/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.ConflictException;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.ExposedPorts;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.Volumes;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CreateContainerCmdImpl
extends AbstrDockerCmd<CreateContainerCmd, CreateContainerResponse>
implements CreateContainerCmd {
    private String name;
    @JsonProperty(value="Hostname")
    private String hostName = "";
    @JsonProperty(value="Domainname")
    private String domainName = "";
    @JsonProperty(value="User")
    private String user = "";
    @JsonProperty(value="Memory")
    private long memoryLimit = 0L;
    @JsonProperty(value="MemorySwap")
    private long memorySwap = 0L;
    @JsonProperty(value="CpuShares")
    private int cpuShares = 0;
    @JsonProperty(value="CpuPeriod")
    private Integer cpuPeriod;
    @JsonProperty(value="Cpuset")
    private String cpuset;
    @JsonProperty(value="AttachStdin")
    private boolean attachStdin = false;
    @JsonProperty(value="AttachStdout")
    private boolean attachStdout = false;
    @JsonProperty(value="AttachStderr")
    private boolean attachStderr = false;
    @JsonProperty(value="PortSpecs")
    private String[] portSpecs;
    @JsonProperty(value="Tty")
    private boolean tty = false;
    @JsonProperty(value="OpenStdin")
    private boolean stdinOpen = false;
    @JsonProperty(value="StdinOnce")
    private boolean stdInOnce = false;
    @JsonProperty(value="Env")
    private String[] env;
    @JsonProperty(value="Cmd")
    private String[] cmd;
    @JsonProperty(value="Entrypoint")
    private String[] entrypoint;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Volumes")
    private Volumes volumes = new Volumes(new Volume[0]);
    @JsonProperty(value="WorkingDir")
    private String workingDir = "";
    @JsonProperty(value="MacAddress")
    private String macAddress;
    @JsonProperty(value="NetworkDisabled")
    private boolean networkDisabled = false;
    @JsonProperty(value="ExposedPorts")
    private ExposedPorts exposedPorts = new ExposedPorts(new ExposedPort[0]);
    @JsonProperty(value="HostConfig")
    private HostConfig hostConfig = new HostConfig();
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="CpusetMems")
    private String cpusetMems;
    @JsonProperty(value="BlkioWeight")
    private Integer blkioWeight;
    @JsonProperty(value="OomKillDisable")
    private Boolean oomKillDisable;

    public CreateContainerCmdImpl(CreateContainerCmd.Exec exec, String image) {
        super(exec);
        Preconditions.checkNotNull((Object)image, (Object)"image was not specified");
        this.withImage(image);
    }

    @Override
    public CreateContainerResponse exec() throws NotFoundException, ConflictException {
        return (CreateContainerResponse)super.exec();
    }

    @Override
    @JsonIgnore
    public Bind[] getBinds() {
        return this.hostConfig.getBinds();
    }

    @Override
    public Integer getBlkioWeight() {
        return this.blkioWeight;
    }

    @Override
    public Capability[] getCapAdd() {
        return this.hostConfig.getCapAdd();
    }

    @Override
    public Capability[] getCapDrop() {
        return this.hostConfig.getCapDrop();
    }

    @Override
    public String[] getCmd() {
        return this.cmd;
    }

    public String getContainerIDFile() {
        return this.hostConfig.getContainerIDFile();
    }

    @Override
    public Integer getCpuPeriod() {
        return this.cpuPeriod;
    }

    @Override
    public String getCpuset() {
        return this.cpuset;
    }

    @Override
    public String getCpusetMems() {
        return this.cpusetMems;
    }

    @Override
    public int getCpuShares() {
        return this.cpuShares;
    }

    @Override
    @JsonIgnore
    public Device[] getDevices() {
        return this.hostConfig.getDevices();
    }

    @Override
    @JsonIgnore
    public String[] getDns() {
        return this.hostConfig.getDns();
    }

    @Override
    @JsonIgnore
    public String[] getDnsSearch() {
        return this.hostConfig.getDnsSearch();
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public String[] getEntrypoint() {
        return this.entrypoint;
    }

    @Override
    public String[] getEnv() {
        return this.env;
    }

    @Override
    @JsonIgnore
    public ExposedPort[] getExposedPorts() {
        return this.exposedPorts.getExposedPorts();
    }

    @Override
    @JsonIgnore
    public String[] getExtraHosts() {
        return this.hostConfig.getExtraHosts();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    @JsonIgnore
    public Link[] getLinks() {
        return this.hostConfig.getLinks();
    }

    @Override
    @JsonIgnore
    public LxcConf[] getLxcConf() {
        return this.hostConfig.getLxcConf();
    }

    @Override
    @JsonIgnore
    public LogConfig getLogConfig() {
        return this.hostConfig.getLogConfig();
    }

    @Override
    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public long getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    public long getMemorySwap() {
        return this.memorySwap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getNetworkMode() {
        return this.hostConfig.getNetworkMode();
    }

    @Override
    @JsonIgnore
    public Ports getPortBindings() {
        return this.hostConfig.getPortBindings();
    }

    @Override
    public String[] getPortSpecs() {
        return this.portSpecs;
    }

    @Override
    @JsonIgnore
    public RestartPolicy getRestartPolicy() {
        return this.hostConfig.getRestartPolicy();
    }

    @Override
    public Ulimit[] getUlimits() {
        return this.hostConfig.getUlimits();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    @JsonIgnore
    public Volume[] getVolumes() {
        return this.volumes.getVolumes();
    }

    @Override
    @JsonIgnore
    public VolumesFrom[] getVolumesFrom() {
        return this.hostConfig.getVolumesFrom();
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public boolean isAttachStderr() {
        return this.attachStderr;
    }

    @Override
    public boolean isAttachStdin() {
        return this.attachStdin;
    }

    @Override
    public boolean isAttachStdout() {
        return this.attachStdout;
    }

    @Override
    public boolean isNetworkDisabled() {
        return this.networkDisabled;
    }

    @Override
    public Boolean isOomKillDisable() {
        return this.oomKillDisable;
    }

    @Override
    @JsonIgnore
    public Boolean isPrivileged() {
        return this.hostConfig.isPrivileged();
    }

    @Override
    @JsonIgnore
    public Boolean isPublishAllPorts() {
        return this.hostConfig.isPublishAllPorts();
    }

    public boolean isReadonlyRootfs() {
        return this.hostConfig.isReadonlyRootfs();
    }

    @Override
    public boolean isStdInOnce() {
        return this.stdInOnce;
    }

    @Override
    public boolean isStdinOpen() {
        return this.stdinOpen;
    }

    @Override
    public boolean isTty() {
        return this.tty;
    }

    @Override
    @JsonIgnore
    public String getPidMode() {
        return this.hostConfig.getPidMode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)"create container ").append((Object)(this.name != null ? "name=" + this.name + " " : "")).append((Object)this).toString();
    }

    @Override
    public CreateContainerCmdImpl withAttachStderr(boolean attachStderr) {
        this.attachStderr = attachStderr;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withAttachStdin(boolean attachStdin) {
        this.attachStdin = attachStdin;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withAttachStdout(boolean attachStdout) {
        this.attachStdout = attachStdout;
        return this;
    }

    @Override
    public CreateContainerCmd withBinds(Bind ... binds) {
        Preconditions.checkNotNull((Object)binds, (Object)"binds was not specified");
        this.hostConfig.setBinds(binds);
        return this;
    }

    @Override
    public CreateContainerCmd withBlkioWeight(Integer blkioWeight) {
        Preconditions.checkNotNull((Object)blkioWeight, (Object)"blkioWeight was not specified");
        this.blkioWeight = blkioWeight;
        return null;
    }

    @Override
    public CreateContainerCmd withCapAdd(Capability ... capAdd) {
        Preconditions.checkNotNull((Object)capAdd, (Object)"capAdd was not specified");
        this.hostConfig.setCapAdd(capAdd);
        return this;
    }

    @Override
    public CreateContainerCmd withCapDrop(Capability ... capDrop) {
        Preconditions.checkNotNull((Object)capDrop, (Object)"capDrop was not specified");
        this.hostConfig.setCapDrop(capDrop);
        return this;
    }

    @Override
    public CreateContainerCmdImpl withCmd(String ... cmd) {
        Preconditions.checkNotNull((Object)cmd, (Object)"cmd was not specified");
        this.cmd = cmd;
        return this;
    }

    @Override
    public CreateContainerCmd withContainerIDFile(String containerIDFile) {
        Preconditions.checkNotNull((Object)containerIDFile, (Object)"no containerIDFile was specified");
        this.hostConfig.setContainerIDFile(containerIDFile);
        return this;
    }

    @Override
    public CreateContainerCmd withCpuPeriod(Integer cpuPeriod) {
        Preconditions.checkNotNull((Object)cpuPeriod, (Object)"cpuPeriod was not specified");
        this.cpuPeriod = cpuPeriod;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withCpuset(String cpuset) {
        Preconditions.checkNotNull((Object)cpuset, (Object)"cpuset was not specified");
        this.cpuset = cpuset;
        return this;
    }

    @Override
    public CreateContainerCmd withCpusetMems(String cpusetMems) {
        Preconditions.checkNotNull((Object)cpusetMems, (Object)"cpusetMems was not specified");
        this.cpusetMems = cpusetMems;
        return null;
    }

    @Override
    public CreateContainerCmdImpl withCpuShares(int cpuShares) {
        this.cpuShares = cpuShares;
        return this;
    }

    @Override
    public CreateContainerCmd withDevices(Device ... devices) {
        Preconditions.checkNotNull((Object)devices, (Object)"devices was not specified");
        this.hostConfig.setDevices(devices);
        return this;
    }

    @Override
    public CreateContainerCmdImpl withDns(String ... dns) {
        Preconditions.checkNotNull((Object)dns, (Object)"dns was not specified");
        this.hostConfig.setDns(dns);
        return this;
    }

    @Override
    public CreateContainerCmd withDnsSearch(String ... dnsSearch) {
        Preconditions.checkNotNull((Object)dnsSearch, (Object)"dnsSearch was not specified");
        this.hostConfig.setDnsSearch(dnsSearch);
        return this;
    }

    @Override
    public CreateContainerCmdImpl withDomainName(String domainName) {
        Preconditions.checkNotNull((Object)domainName, (Object)"no domainName was specified");
        this.domainName = domainName;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withEntrypoint(String ... entrypoint) {
        Preconditions.checkNotNull((Object)entrypoint, (Object)"entrypoint was not specified");
        this.entrypoint = entrypoint;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withEnv(String ... env) {
        Preconditions.checkNotNull((Object)env, (Object)"env was not specified");
        this.env = env;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withExposedPorts(ExposedPort ... exposedPorts) {
        Preconditions.checkNotNull((Object)exposedPorts, (Object)"exposedPorts was not specified");
        this.exposedPorts = new ExposedPorts(exposedPorts);
        return this;
    }

    @Override
    public CreateContainerCmd withExtraHosts(String ... extraHosts) {
        Preconditions.checkNotNull((Object)extraHosts, (Object)"extraHosts was not specified");
        this.hostConfig.setExtraHosts(extraHosts);
        return this;
    }

    @Override
    public CreateContainerCmdImpl withHostName(String hostName) {
        Preconditions.checkNotNull((Object)this.hostConfig, (Object)"no hostName was specified");
        this.hostName = hostName;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withImage(String image) {
        Preconditions.checkNotNull((Object)image, (Object)"no image was specified");
        this.image = image;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withLabels(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, (Object)"labels was not specified");
        this.labels = labels;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withLinks(Link ... links) {
        Preconditions.checkNotNull((Object)links, (Object)"links was not specified");
        this.hostConfig.setLinks(links);
        return this;
    }

    @Override
    public CreateContainerCmd withLxcConf(LxcConf ... lxcConf) {
        Preconditions.checkNotNull((Object)lxcConf, (Object)"lxcConf was not specified");
        this.hostConfig.setLxcConf(lxcConf);
        return this;
    }

    @Override
    public CreateContainerCmd withLogConfig(LogConfig logConfig) {
        Preconditions.checkNotNull((Object)logConfig, (Object)"logConfig was not specified");
        this.hostConfig.setLogConfig(logConfig);
        return this;
    }

    @Override
    public CreateContainerCmdImpl withMacAddress(String macAddress) {
        Preconditions.checkNotNull((Object)macAddress, (Object)"macAddress was not specified");
        this.macAddress = macAddress;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withMemoryLimit(long memoryLimit) {
        this.memoryLimit = memoryLimit;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withMemorySwap(long memorySwap) {
        this.memorySwap = memorySwap;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name was not specified");
        this.name = name;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withNetworkDisabled(boolean disableNetwork) {
        this.networkDisabled = disableNetwork;
        return this;
    }

    @Override
    public CreateContainerCmd withNetworkMode(String networkMode) {
        Preconditions.checkNotNull((Object)networkMode, (Object)"networkMode was not specified");
        this.hostConfig.setNetworkMode(networkMode);
        return this;
    }

    @Override
    public CreateContainerCmd withOomKillDisable(Boolean oomKillDisable) {
        Preconditions.checkNotNull((Object)oomKillDisable, (Object)"oomKillDisable was not specified");
        this.oomKillDisable = oomKillDisable;
        return this;
    }

    @Override
    public CreateContainerCmd withPortBindings(PortBinding ... portBindings) {
        Preconditions.checkNotNull((Object)portBindings, (Object)"portBindings was not specified");
        this.hostConfig.setPortBindings(new Ports(portBindings));
        return this;
    }

    @Override
    public CreateContainerCmd withPortBindings(Ports portBindings) {
        Preconditions.checkNotNull((Object)portBindings, (Object)"portBindings was not specified");
        this.hostConfig.setPortBindings(portBindings);
        return this;
    }

    @Override
    public CreateContainerCmdImpl withPortSpecs(String ... portSpecs) {
        Preconditions.checkNotNull((Object)portSpecs, (Object)"portSpecs was not specified");
        this.portSpecs = portSpecs;
        return this;
    }

    @Override
    public CreateContainerCmd withPrivileged(boolean privileged) {
        this.hostConfig.setPrivileged(privileged);
        return this;
    }

    @Override
    public CreateContainerCmd withPublishAllPorts(boolean publishAllPorts) {
        this.hostConfig.setPublishAllPorts(publishAllPorts);
        return this;
    }

    @Override
    public CreateContainerCmd withReadonlyRootfs(boolean readonlyRootfs) {
        this.hostConfig.setReadonlyRootfs(readonlyRootfs);
        return this;
    }

    @Override
    public CreateContainerCmd withRestartPolicy(RestartPolicy restartPolicy) {
        Preconditions.checkNotNull((Object)restartPolicy, (Object)"restartPolicy was not specified");
        this.hostConfig.setRestartPolicy(restartPolicy);
        return this;
    }

    @Override
    public CreateContainerCmdImpl withStdInOnce(boolean stdInOnce) {
        this.stdInOnce = stdInOnce;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withStdinOpen(boolean stdinOpen) {
        this.stdinOpen = stdinOpen;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withTty(boolean tty) {
        this.tty = tty;
        return this;
    }

    @Override
    public CreateContainerCmd withUlimits(Ulimit[] ulimits) {
        Preconditions.checkNotNull((Object)ulimits, (Object)"no ulimits was specified");
        this.hostConfig.setUlimits(ulimits);
        return this;
    }

    @Override
    public CreateContainerCmdImpl withUser(String user) {
        Preconditions.checkNotNull((Object)user, (Object)"user was not specified");
        this.user = user;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withVolumes(Volume ... volumes) {
        Preconditions.checkNotNull((Object)volumes, (Object)"volumes was not specified");
        this.volumes = new Volumes(volumes);
        return this;
    }

    @Override
    public CreateContainerCmdImpl withVolumesFrom(VolumesFrom ... volumesFrom) {
        Preconditions.checkNotNull((Object)volumesFrom, (Object)"volumesFrom was not specified");
        this.hostConfig.setVolumesFrom(volumesFrom);
        return this;
    }

    @Override
    public CreateContainerCmdImpl withWorkingDir(String workingDir) {
        Preconditions.checkNotNull((Object)workingDir, (Object)"workingDir was not specified");
        this.workingDir = workingDir;
        return this;
    }

    @Override
    public CreateContainerCmd withPidMode(String pidMode) {
        Preconditions.checkNotNull((Object)pidMode, (Object)"pidMode was not specified");
        this.hostConfig.setPidMode(pidMode);
        return this;
    }
}

