/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerClientException;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullImageResultCallback
extends ResultCallbackTemplate<PullImageResultCallback, PullResponseItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PullImageResultCallback.class);
    @CheckForNull
    private PullResponseItem latestItem = null;

    @Override
    public void onNext(PullResponseItem item) {
        this.latestItem = item;
        LOGGER.debug(item.toString());
    }

    public void awaitSuccess() {
        try {
            this.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new DockerClientException("", e);
        }
        if (this.latestItem == null) {
            throw new DockerClientException("Could not pull image");
        }
        if (!this.latestItem.isPullSuccessIndicated()) {
            throw new DockerClientException("Could not pull image: " + this.latestItem.getError());
        }
    }
}

