/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;

public class RemoveContainerCmdImpl
extends AbstrDockerCmd<RemoveContainerCmd, Void>
implements RemoveContainerCmd {
    private String containerId;
    private boolean removeVolumes;
    private boolean force;

    public RemoveContainerCmdImpl(RemoveContainerCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public boolean hasRemoveVolumesEnabled() {
        return this.removeVolumes;
    }

    @Override
    public boolean hasForceEnabled() {
        return this.force;
    }

    @Override
    public RemoveContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    public RemoveContainerCmd withRemoveVolumes(boolean removeVolumes) {
        this.removeVolumes = removeVolumes;
        return this;
    }

    @Override
    public RemoveContainerCmd withForce() {
        return this.withForce(true);
    }

    @Override
    public RemoveContainerCmd withForce(boolean force) {
        this.force = force;
        return this;
    }

    public String toString() {
        return "rm " + (this.removeVolumes ? "--volumes=true" : "") + (this.force ? "--force=true" : "") + this.containerId;
    }

    @Override
    public Void exec() throws NotFoundException {
        return (Void)super.exec();
    }
}

