/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class FileReporter
extends JPanel {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final Map<String, List<Integer>> data = new ConcurrentHashMap<String, List<Integer>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String file) throws IOException {
        BufferedReader reader;
        block10: {
            File datafile = new File(file);
            reader = null;
            try {
                if (datafile.canRead()) {
                    reader = new BufferedReader(new FileReader(datafile));
                    break block10;
                }
                JOptionPane.showMessageDialog(null, "The file you specified cannot be read.", "Information", 1);
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(reader);
                throw throwable;
            }
            JOrphanUtils.closeQuietly(reader);
            return;
        }
        block6: while (true) {
            String line;
            while ((line = reader.readLine()) != null) {
                try {
                    if ((line = line.trim()).startsWith("#")) continue block6;
                    if (line.length() == 0) continue;
                    int splitter = line.lastIndexOf(32);
                    String key = line.substring(0, splitter);
                    int len = line.length() - 1;
                    Integer value = null;
                    value = line.charAt(len) == ',' ? Integer.valueOf(line.substring(splitter + 1, len)) : Integer.valueOf(line.substring(splitter + 1));
                    List<Integer> v = this.getData(key);
                    if (v == null) {
                        v = Collections.synchronizedList(new ArrayList());
                        this.data.put(key, v);
                    }
                    v.add(value);
                }
                catch (NumberFormatException nfe) {
                    log.error("This line could not be parsed: " + line, (Throwable)nfe);
                }
                catch (Exception e) {
                    log.error("This line caused a problem: " + line, (Throwable)e);
                }
            }
            break;
        }
        JOrphanUtils.closeQuietly((Closeable)reader);
        this.showPanel();
    }

    public List<Integer> getData(String key) {
        return this.data.get(key);
    }

    public void showPanel() {
        JFrame f = new JFrame("Data File Report");
        this.setLayout(new BorderLayout());
        GraphPanel gp = new GraphPanel(this.data);
        this.add((Component)gp, "Center");
        this.add((Component)gp.getStats(), "East");
        this.add((Component)gp.getLegend(), "North");
        f.setSize(500, 300);
        f.getContentPane().add(this);
        f.setVisible(true);
    }

    private static class GraphPanel
    extends JPanel {
        private static final long serialVersionUID = 240L;
        private final Map<String, List<Integer>> data;
        private final List<String> keys = Collections.synchronizedList(new ArrayList());
        private final List<Color> colorList = Collections.synchronizedList(new ArrayList());

        public GraphPanel(Map<String, List<Integer>> data) {
            this.data = data;
            for (String key : data.keySet()) {
                this.keys.add(key);
            }
            for (int a = 51; a < 255; a += 102) {
                for (int b = 51; b < 255; b += 102) {
                    for (int c = 51; c < 255; c += 102) {
                        this.colorList.add(new Color(a, b, c));
                    }
                }
            }
        }

        public float getMax() {
            float maxValue = 0.0f;
            for (int t = 0; t < this.keys.size(); ++t) {
                String key = this.keys.get(t);
                List<Integer> temp = this.data.get(key);
                for (int j = 0; j < temp.size(); ++j) {
                    float f = temp.get(j).intValue();
                    maxValue = Math.max(f, maxValue);
                }
            }
            return (float)((double)maxValue + (double)maxValue * 0.1);
        }

        public float getMin() {
            float minValue = 9999999.0f;
            for (int t = 0; t < this.keys.size(); ++t) {
                String key = this.keys.get(t);
                List<Integer> temp = this.data.get(key);
                for (int j = 0; j < temp.size(); ++j) {
                    float f = temp.get(j).intValue();
                    minValue = Math.min(f, minValue);
                }
            }
            return (float)((double)minValue - (double)minValue * 0.1);
        }

        public JPanel getLegend() {
            JPanel main = new JPanel();
            GridBagLayout g = new GridBagLayout();
            main.setLayout(g);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            int t = 0;
            while (t < this.keys.size()) {
                String key = this.keys.get(t);
                JLabel colorSwatch = new JLabel("  ");
                colorSwatch.setBackground(this.colorList.get(t % this.colorList.size()));
                colorSwatch.setOpaque(true);
                c.gridx = 1;
                c.gridy = t;
                g.setConstraints(colorSwatch, c);
                main.add(colorSwatch);
                JLabel name = new JLabel(key);
                c.gridx = 2;
                c.gridy = t++;
                g.setConstraints(name, c);
                main.add(name);
            }
            return main;
        }

        public JPanel getStats() {
            int total = 0;
            float totalValue = 0.0f;
            float maxValue = 0.0f;
            float minValue = 999999.0f;
            for (int t = 0; t < this.keys.size(); ++t) {
                String key = this.keys.get(t);
                List<Integer> temp = this.data.get(key);
                for (int j = 0; j < temp.size(); ++j) {
                    float f = temp.get(j).intValue();
                    minValue = Math.min(f, minValue);
                    maxValue = Math.max(f, maxValue);
                    totalValue += f;
                    ++total;
                }
            }
            float averageValue = totalValue / (float)total;
            JPanel main = new JPanel();
            GridBagLayout g = new GridBagLayout();
            main.setLayout(g);
            DecimalFormat df = new DecimalFormat("#0.0");
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 6, 3, 6);
            c.fill = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            JLabel count = new JLabel("Count: " + total);
            c.gridx = 1;
            c.gridy = 1;
            g.setConstraints(count, c);
            JLabel min = new JLabel("Min: " + df.format(Float.valueOf(minValue)));
            c.gridx = 1;
            c.gridy = 2;
            g.setConstraints(min, c);
            JLabel max = new JLabel("Max: " + df.format(Float.valueOf(maxValue)));
            c.gridx = 1;
            c.gridy = 3;
            g.setConstraints(max, c);
            JLabel average = new JLabel("Average: " + df.format(Float.valueOf(averageValue)));
            c.gridx = 1;
            c.gridy = 4;
            g.setConstraints(average, c);
            main.add(count);
            main.add(min);
            main.add(max);
            main.add(average);
            return main;
        }

        public int getDataWidth() {
            int size = 0;
            for (int t = 0; t < this.keys.size(); ++t) {
                String key = this.keys.get(t);
                size = Math.max(size, this.data.get(key).size());
            }
            return size;
        }

        @Override
        public void update(Graphics g) {
            int base = 10;
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            int width = this.getSize().width;
            int height = this.getSize().height;
            float maxValue = this.getMax();
            float minValue = this.getMin();
            g.setColor(Color.gray);
            int dataWidth = this.getDataWidth();
            int increment = Math.round((float)(width - 1) / (float)(dataWidth - 1));
            int yIncrement = Math.round(((float)height - (float)(1 + base)) / 9.0f);
            for (int t = 1; t < dataWidth; t += dataWidth / 25 + 1) {
                g.drawString(Integer.valueOf(t).toString(), t * increment + 2, height - 2);
            }
            float incrementValue = (maxValue - minValue) / 9.0f;
            for (int t = 0; t < 10; ++t) {
                g.drawString(Integer.valueOf(Math.round(minValue + (float)t * incrementValue)).toString(), 2, height - t * yIncrement - 2 - base);
            }
            int start = 0;
            for (int t = 0; t < this.keys.size(); ++t) {
                String key = this.keys.get(t);
                List<Integer> v = this.data.get(key);
                start = 0;
                g.setColor(this.colorList.get(t % this.colorList.size()));
                for (int i = 0; i < v.size() - 1; ++i) {
                    float y1 = v.get(i).intValue();
                    float y2 = v.get(i + 1).intValue();
                    int Y1 = Math.round((float)height * (y1 -= minValue) / (maxValue - minValue));
                    int Y2 = Math.round((float)height * (y2 -= minValue) / (maxValue - minValue));
                    Y1 = height - Y1 - base;
                    Y2 = height - Y2 - base;
                    g.drawLine(start, Y1, start + increment, Y2);
                    start += increment;
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            this.update(g);
        }
    }
}

