/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleSender;
import org.apache.jmeter.samplers.SampleSenderFactory;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class RemoteListenerWrapper
extends AbstractTestElement
implements SampleListener,
TestStateListener,
Serializable,
NoThreadClone {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private final RemoteSampleListener listener;
    private final SampleSender sender;

    public RemoteListenerWrapper(RemoteSampleListener l) {
        this.listener = l;
        this.sender = SampleSenderFactory.getInstance(this.listener);
    }

    public RemoteListenerWrapper() {
        this.listener = null;
        this.sender = null;
    }

    @Override
    public void testStarted() {
        block3: {
            log.debug("Test Started()");
            try {
                this.listener.testStarted();
            }
            catch (Throwable ex) {
                log.warn("testStarted()", ex);
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                if (!(ex instanceof RuntimeException)) break block3;
                throw (RuntimeException)ex;
            }
        }
    }

    @Override
    public void testEnded() {
        this.sender.testEnded();
    }

    @Override
    public void testStarted(String host) {
        block3: {
            log.debug("Test Started on " + host);
            try {
                this.listener.testStarted(host);
            }
            catch (Throwable ex) {
                log.error("testStarted(host)", ex);
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                if (!(ex instanceof RuntimeException)) break block3;
                throw (RuntimeException)ex;
            }
        }
    }

    @Override
    public void testEnded(String host) {
        this.sender.testEnded(host);
    }

    @Override
    public void sampleOccurred(SampleEvent e) {
        this.sender.sampleOccurred(e);
    }

    @Override
    public void sampleStarted(SampleEvent e) {
        log.debug("Sample started");
        try {
            this.listener.sampleStarted(e);
        }
        catch (RemoteException err) {
            log.error("sampleStarted", (Throwable)err);
        }
    }

    @Override
    public void sampleStopped(SampleEvent e) {
        log.debug("Sample stopped");
        try {
            this.listener.sampleStopped(e);
        }
        catch (RemoteException err) {
            log.error("sampleStopped", (Throwable)err);
        }
    }
}

