/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator;

import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.kurento.modulecreator.KurentoModuleCreator;
import org.kurento.modulecreator.PathUtils;
import org.kurento.modulecreator.Result;

public class Main {
    private static final String HELP = "h";
    private static final String VERBOSE = "v";
    private static final String LIST_GEN_FILES = "lf";
    private static final String ROM = "r";
    private static final String DEPROM = "dr";
    private static final String TEMPLATES_DIR = "t";
    private static final String CODEGEN = "c";
    private static final String DELETE = "d";
    private static final String NO_OVERWRITE = "n";
    private static final String CONFIG = "cf";
    private static final String INTERNAL_TEMPLATES = "it";
    private static final String SHOW_VALUES = "s";
    private static final String OUTPUT_MODEL = "o";
    private static final String PRINT_SIMPLE_KMD = "p";
    private static final String GENERATE_MAVEN = "maven";
    private static final String GENERATE_NPM = "npm";

    public static void main(String[] args) throws IOException, TemplateException {
        Options options = Main.configureOptions();
        CommandLine line = null;
        try {
            PosixParser parser = new PosixParser();
            line = parser.parse(options, args);
            if (line.hasOption(HELP) || !line.hasOption(ROM)) {
                Main.printHelp(options);
                System.exit(0);
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            Main.printHelp(options);
            System.exit(1);
        }
        KurentoModuleCreator processor = new KurentoModuleCreator();
        processor.setDeleteGenDir(line.hasOption(DELETE));
        processor.setVerbose(line.hasOption(VERBOSE));
        processor.setOverwrite(!line.hasOption(NO_OVERWRITE));
        processor.setListGeneratedFiles(line.hasOption(LIST_GEN_FILES));
        if (line.hasOption(TEMPLATES_DIR)) {
            processor.setTemplatesDir(Main.getTemplatesDir(line));
        } else if (line.hasOption(INTERNAL_TEMPLATES)) {
            processor.setInternalTemplates(line.getOptionValue(INTERNAL_TEMPLATES));
        }
        processor.setConfig(Main.getConfigContent(line));
        processor.setKmdFilesToGen(Main.getKmdFiles(line));
        processor.setDependencyKmdFiles(Main.getDependencyKmdFiles(line));
        processor.setOutputFile(Main.getOutputModuleFile(line));
        processor.setGenerateMavenPom(line.hasOption(GENERATE_MAVEN));
        processor.setGenerateNpmPackage(line.hasOption(GENERATE_NPM));
        Main.showValues(processor, line);
        Main.printSimpleKmd(processor, line);
        processor.setCodeGenDir(Main.getCodegenDir(line));
        Result result = processor.generateCode();
        if (result.isSuccess()) {
            System.out.println("Generation success");
        } else {
            System.out.println("Generation failed");
            result.showErrorsInConsole();
            System.exit(1);
        }
    }

    private static void showValues(KurentoModuleCreator krp, CommandLine line) throws FileNotFoundException, IOException {
        if (!line.hasOption(SHOW_VALUES)) {
            return;
        }
        String[] keys = line.getOptionValues(SHOW_VALUES);
        krp.printValues(keys);
        System.exit(0);
    }

    private static void printSimpleKmd(KurentoModuleCreator krp, CommandLine line) throws FileNotFoundException, IOException {
        if (!line.hasOption(PRINT_SIMPLE_KMD)) {
            return;
        }
        try {
            krp.printSimpleKmd();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static Options configureOptions() {
        Options options = new Options();
        options.addOption(VERBOSE, "verbose", false, "Prints source code while being generated.");
        options.addOption(HELP, "help", false, "Prints this message.");
        OptionBuilder.withLongOpt((String)"rom");
        OptionBuilder.withDescription((String)"A space separated list of Kurento Media Element Description (kmd) files or folders containing this files.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ROM_FILE");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)ROM));
        OptionBuilder.withLongOpt((String)"deprom");
        OptionBuilder.withDescription((String)"A space separated list of Kurento Media Element Description (kmd) files used as dependencies or folders containing this files.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"DEP_ROM_FILE");
        options.addOption(OptionBuilder.create((String)DEPROM));
        OptionBuilder.withLongOpt((String)"templates");
        OptionBuilder.withDescription((String)"Directory that contains template files.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"TEMPLATES_DIR");
        options.addOption(OptionBuilder.create((String)TEMPLATES_DIR));
        OptionBuilder.withLongOpt((String)"internal-templates");
        OptionBuilder.withDescription((String)"Directory that contains template files.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"TEMPLATES_DIR");
        options.addOption(OptionBuilder.create((String)INTERNAL_TEMPLATES));
        OptionBuilder.withLongOpt((String)"codegen");
        OptionBuilder.withDescription((String)"Destination directory for generated files (required if --show-values or --output-model is not present.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"CODEGEN_DIR");
        options.addOption(OptionBuilder.create((String)CODEGEN));
        options.addOption(DELETE, "delete", false, "Delete destination directory before generating files.");
        options.addOption(LIST_GEN_FILES, "list-generated-files", false, "List in the standard output the names of generated files.");
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"Configuration file.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"CONFIGURATION_FILE");
        options.addOption(OptionBuilder.create((String)CONFIG));
        OptionBuilder.withLongOpt((String)"show-values");
        OptionBuilder.withDescription((String)"Show values for provided keys in kmd.json files.");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"LIST OF KEYS");
        options.addOption(OptionBuilder.create((String)SHOW_VALUES));
        OptionBuilder.withLongOpt((String)"output-model");
        OptionBuilder.withDescription((String)"Directory where the final model will be written.");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"DIR");
        options.addOption(OptionBuilder.create((String)OUTPUT_MODEL));
        OptionBuilder.withLongOpt((String)"no-overwrite");
        OptionBuilder.withDescription((String)"Do not overwrite files if they are already generated.");
        options.addOption(OptionBuilder.create((String)NO_OVERWRITE));
        options.addOption(GENERATE_MAVEN, "maven-pom", false, "Generate pom.xml file based on base file or template.");
        options.addOption(GENERATE_NPM, "npm-package", false, "Generate package.json file based on base file or template.");
        options.addOption(PRINT_SIMPLE_KMD, "print-simple-kmd", false, "Print events, complex types and remote classes present on kmd");
        return options;
    }

    public static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("kurento-module-creator", options);
    }

    private static List<Path> getDependencyKmdFiles(CommandLine line) throws IOException {
        if (line.hasOption(DEPROM)) {
            String[] kmdPathNames = line.getOptionValues(DEPROM);
            List<Path> kmdFiles = PathUtils.getPaths(kmdPathNames, "*.kmd.json");
            if (kmdFiles.isEmpty()) {
                String paths = null;
                for (String path : kmdPathNames) {
                    paths = paths == null ? path : paths + ":" + path;
                }
                System.err.println("No dependency kmd files found in paths: " + paths);
                return Collections.emptyList();
            }
            return kmdFiles;
        }
        return Collections.emptyList();
    }

    private static JsonObject getConfigContent(CommandLine line) throws JsonIOException, IOException {
        JsonObject configContents = new JsonObject();
        String configValue = line.getOptionValue(CONFIG);
        if (configValue != null) {
            Path configFile = Paths.get(configValue, new String[0]);
            if (!Files.exists(configFile, new LinkOption[0])) {
                System.err.println("Config file '" + configFile + "' does not exist or is not readable");
                System.exit(1);
            }
            configContents = KurentoModuleCreator.loadConfigFile(configFile);
        }
        return configContents;
    }

    private static Path getCodegenDir(CommandLine line) {
        if (!(line.hasOption(CODEGEN) || line.hasOption(SHOW_VALUES) || line.hasOption(OUTPUT_MODEL))) {
            Main.printHelp(Main.configureOptions());
            System.exit(1);
        }
        if (line.hasOption(CODEGEN)) {
            File codegenDir = new File(line.getOptionValue(CODEGEN));
            if (codegenDir.exists()) {
                if (!codegenDir.canWrite()) {
                    System.err.println("Codegen '" + codegenDir + "' is not writable");
                    System.exit(1);
                } else if (!codegenDir.isDirectory()) {
                    System.err.println("Codegen '" + codegenDir + "' is not a directory");
                    System.exit(1);
                }
            }
            return codegenDir.toPath();
        }
        return null;
    }

    private static Path getTemplatesDir(CommandLine line) {
        File templatesDir = new File(line.getOptionValue(TEMPLATES_DIR));
        if (templatesDir.exists()) {
            if (!templatesDir.canRead()) {
                System.err.println("TemplatesDir '" + templatesDir + "' is not readable");
                System.exit(1);
            } else if (!templatesDir.isDirectory()) {
                System.err.println("TemplatesDir '" + templatesDir + "' is not a directory");
                System.exit(1);
            }
            return templatesDir.toPath();
        }
        System.err.println("TemplatesDir '" + templatesDir + "' doesn't exist");
        System.exit(1);
        return null;
    }

    private static Path getOutputModuleFile(CommandLine line) throws IOException {
        if (!line.hasOption(OUTPUT_MODEL)) {
            return null;
        }
        String outputPathName = line.getOptionValue(OUTPUT_MODEL);
        Path outputPath = Paths.get(outputPathName, new String[0]);
        if (!Files.exists(outputPath, new LinkOption[0])) {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        }
        if (Files.isDirectory(outputPath, new LinkOption[0]) && Files.isWritable(outputPath)) {
            return outputPath;
        }
        System.err.println("Output directory option should be a writable directory");
        System.exit(1);
        return null;
    }

    private static List<Path> getKmdFiles(CommandLine line) throws IOException {
        Object[] kmdPathNames = line.getOptionValues(ROM);
        List<Path> kmdFiles = PathUtils.getPaths((String[])kmdPathNames, "*.kmd.json");
        if (kmdFiles.isEmpty()) {
            System.err.println("No kmd files found in paths: " + Arrays.toString(kmdPathNames));
            System.exit(1);
        }
        return kmdFiles;
    }
}

