/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.codegen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFusioner {
    private static final Logger log = LoggerFactory.getLogger(JsonFusioner.class);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Path generatedJson;
    private final Path customizerJson;
    private final Path outputFile;
    private final Set<String> addChildrenTags;
    private final Set<String> replaceChildrenTags;

    public JsonFusioner(Path generatedJson, Path customizerJson, Path outputFile) {
        this(generatedJson, customizerJson, outputFile, null, null);
    }

    public JsonFusioner(Path generatedJson, Path customizerJson, Path outputFile, String[] addChildrenTags, String[] replaceChildrenTags) {
        this.generatedJson = generatedJson;
        this.customizerJson = customizerJson;
        this.outputFile = outputFile;
        this.addChildrenTags = new HashSet<String>(Arrays.asList(addChildrenTags));
        this.replaceChildrenTags = new HashSet<String>(Arrays.asList(replaceChildrenTags));
    }

    public void fusionJsons() throws IOException {
        try {
            JsonObject generatedJsonDoc = this.loadJson(this.generatedJson);
            JsonObject customizedJsonDoc = this.loadJson(this.customizerJson);
            this.merge(generatedJsonDoc, customizedJsonDoc, new ArrayList<String>());
            this.writeJson(generatedJsonDoc);
        }
        catch (IOException e) {
            log.warn("Error while merging '" + this.generatedJson + "' with '" + this.customizerJson + "': " + e.getMessage());
        }
    }

    private void merge(JsonObject genNode, JsonObject custNode, List<String> genPath) {
        for (Map.Entry entry : custNode.entrySet()) {
            JsonElement custChildNode = (JsonElement)entry.getValue();
            JsonElement genChildNode = genNode.get((String)entry.getKey());
            if (genChildNode != null) {
                ArrayList<String> newPath;
                String nodePath = this.getPath(genPath, (String)entry.getKey());
                if (this.replaceChildrenTags.contains(nodePath)) {
                    if (!(custChildNode instanceof JsonObject) || !(genChildNode instanceof JsonObject)) continue;
                    newPath = new ArrayList<String>(genPath);
                    newPath.add((String)entry.getKey());
                    this.merge((JsonObject)genChildNode, (JsonObject)custChildNode, newPath);
                    continue;
                }
                if (this.addChildrenTags.contains(nodePath)) {
                    this.addChildren(custChildNode, genChildNode);
                    continue;
                }
                if (this.includedInReplaceOrAdd(nodePath)) {
                    if (!(custChildNode instanceof JsonObject) || !(genChildNode instanceof JsonObject)) continue;
                    newPath = new ArrayList<String>(genPath);
                    newPath.add((String)entry.getKey());
                    this.merge((JsonObject)genChildNode, (JsonObject)custChildNode, newPath);
                    continue;
                }
                genNode.add((String)entry.getKey(), custChildNode);
                continue;
            }
            genNode.add((String)entry.getKey(), custChildNode);
        }
    }

    private void addChildren(JsonElement fromElement, JsonElement toElement) {
        if (fromElement instanceof JsonObject && toElement instanceof JsonObject) {
            JsonObject fromObject = (JsonObject)fromElement;
            JsonObject toObject = (JsonObject)toElement;
            for (Map.Entry entry : fromObject.entrySet()) {
                toObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        } else if (fromElement instanceof JsonArray && toElement instanceof JsonArray) {
            JsonArray fromArray = (JsonArray)fromElement;
            JsonArray toArray = (JsonArray)toElement;
            toArray.addAll(fromArray);
        }
    }

    private boolean includedInReplaceOrAdd(String nodePath) {
        for (String path : this.replaceChildrenTags) {
            if (!path.startsWith(nodePath)) continue;
            return true;
        }
        for (String path : this.addChildrenTags) {
            if (!path.startsWith(nodePath)) continue;
            return true;
        }
        return false;
    }

    private String getPath(List<String> path, String propName) {
        StringBuilder sb = new StringBuilder("/");
        for (String prop : path) {
            sb.append(prop).append("/");
        }
        sb.append(propName);
        return sb.toString();
    }

    private JsonObject loadJson(Path jsonPath) throws JsonSyntaxException, JsonIOException, IOException {
        return (JsonObject)gson.fromJson((Reader)Files.newBufferedReader(jsonPath, StandardCharsets.UTF_8), JsonElement.class);
    }

    private void writeJson(JsonObject doc) throws IOException {
        String json = gson.toJson((JsonElement)doc);
        try (BufferedWriter os = Files.newBufferedWriter(this.outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            os.write(json);
        }
    }
}

