/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.codegen.function;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kurento.modulecreator.definition.Return;
import org.kurento.modulecreator.definition.TypeRef;

public class CppObjectType
implements TemplateMethodModelEx {
    private final Set<String> nativeTypes = new HashSet<String>();

    public CppObjectType() {
        this.nativeTypes.add("float");
        this.nativeTypes.add("int");
        this.nativeTypes.add("double");
        this.nativeTypes.add("int64");
    }

    public Object exec(List arguments) throws TemplateModelException {
        Object type = arguments.get(0);
        if (type instanceof StringModel && (type = ((StringModel)type).getWrappedObject()) instanceof Return) {
            type = ((Return)type).getType();
        }
        boolean isParam = true;
        String prefix = "";
        String suffix = "";
        if (arguments.size() > 1) {
            isParam = ((TemplateBooleanModel)arguments.get(1)).getAsBoolean();
        }
        if (arguments.size() > 2) {
            prefix = arguments.get(2).toString();
        }
        if (arguments.size() > 3) {
            suffix = arguments.get(3).toString();
        }
        if (type == null) {
            if (isParam) {
                return "void ";
            }
            return "void";
        }
        if (type instanceof TypeRef) {
            TypeRef typeRef = (TypeRef)type;
            if (typeRef.isList()) {
                if (isParam) {
                    return "const std::vector<" + this.getTypeAsString(typeRef.getName(), false, prefix, suffix) + "> &";
                }
                return "std::vector<" + this.getTypeAsString(typeRef.getName(), false, prefix, suffix) + ">";
            }
            if (typeRef.isMap()) {
                if (isParam) {
                    return "const std::map <std::string," + this.getTypeAsString(typeRef.getName(), false, prefix, suffix) + "> &";
                }
                return "std::map <std::string," + this.getTypeAsString(typeRef.getName(), false, prefix, suffix) + ">";
            }
            return this.getTypeAsString(typeRef.getName(), isParam, prefix, suffix);
        }
        return this.getTypeAsString(type.toString(), isParam, prefix, suffix);
    }

    private String getTypeAsString(String typeName, boolean isParam, String prefix, String suffix) {
        if (typeName.equals("boolean")) {
            if (isParam) {
                return "bool ";
            }
            return "bool";
        }
        if (typeName.equals("String")) {
            if (isParam) {
                return "const std::string &";
            }
            return "std::string";
        }
        if (this.nativeTypes.contains(typeName)) {
            if (isParam) {
                if (typeName.equals("int64")) {
                    return "int64_t ";
                }
                return typeName + " ";
            }
            if (typeName.equals("int64")) {
                return "int64_t";
            }
            return typeName;
        }
        if (isParam) {
            return "std::shared_ptr<" + prefix + typeName + suffix + "> ";
        }
        return "std::shared_ptr<" + prefix + typeName + suffix + ">";
    }
}

