/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.definition;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kurento.modulecreator.definition.ModelElement;
import org.kurento.modulecreator.definition.NamedElement;
import org.kurento.modulecreator.definition.TypeRef;

public class DataItem
extends NamedElement {
    private TypeRef type;
    private boolean optional = false;
    private JsonElement defaultValue;

    public DataItem(String name, String doc, TypeRef type, boolean optional) {
        super(name, doc);
        this.type = type;
        this.optional = optional;
    }

    public DataItem(String name, String doc, TypeRef type, JsonElement defaultValue) {
        super(name, doc);
        this.type = type;
        this.optional = true;
        this.defaultValue = defaultValue;
    }

    public TypeRef getType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setType(TypeRef type) {
        this.type = type;
    }

    public JsonElement getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.optional ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataItem other = (DataItem)obj;
        if (this.optional != other.optional) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public List<ModelElement> getChildren() {
        return new ArrayList<ModelElement>(Arrays.asList(this.type));
    }
}

