/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.kurento.modulecreator.definition.ModuleDefinition;
import org.kurento.modulecreator.definition.Param;
import org.kurento.modulecreator.definition.Property;
import org.kurento.modulecreator.definition.RemoteClass;
import org.kurento.modulecreator.definition.TypeRef;
import org.kurento.modulecreator.json.DataItemAdapter;
import org.kurento.modulecreator.json.MethodAdapter;
import org.kurento.modulecreator.json.RemoteClassAdapter;
import org.kurento.modulecreator.json.TypeRefAdapter;

public class JsonModuleSaverLoader {
    private static JsonModuleSaverLoader INSTANCE = new JsonModuleSaverLoader();
    private final Gson gson;

    public static JsonModuleSaverLoader getInstance() {
        return INSTANCE;
    }

    private JsonModuleSaverLoader() {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        gsonBuilder.registerTypeAdapter(TypeRef.class, (Object)new TypeRefAdapter());
        gsonBuilder.registerTypeAdapter(Param.class, (Object)new DataItemAdapter());
        gsonBuilder.registerTypeAdapter(Property.class, (Object)new DataItemAdapter());
        gsonBuilder.registerTypeAdapter(RemoteClass.class, (Object)new RemoteClassAdapter());
        gsonBuilder.registerTypeAdapter(Method.class, (Object)new MethodAdapter());
        gsonBuilder.disableHtmlEscaping();
        this.gson = gsonBuilder.create();
    }

    public ModuleDefinition loadFromFile(Path file) throws FileNotFoundException, IOException {
        return this.loadFromInputStream(Files.newInputStream(file, new OpenOption[0]));
    }

    public ModuleDefinition loadFromClasspath(String resourceName) throws IOException {
        return this.loadFromInputStream(this.getClass().getResourceAsStream(resourceName));
    }

    private ModuleDefinition loadFromInputStream(InputStream is) throws IOException {
        String moduleString = this.loadTextFromInputStream(is);
        ModuleDefinition module = (ModuleDefinition)this.gson.fromJson(moduleString, ModuleDefinition.class);
        return module;
    }

    private String loadTextFromInputStream(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    public void writeToFile(ModuleDefinition module, File file) throws FileNotFoundException {
        String jsonModuleString = this.gson.toJson((Object)module);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        PrintWriter writer = new PrintWriter(file);
        writer.println(jsonModuleString);
        writer.close();
    }
}

