/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.cli.avalon.CLArgsParser;
import org.apache.commons.cli.avalon.CLOption;
import org.apache.commons.cli.avalon.CLOptionDescriptor;
import org.apache.commons.cli.avalon.CLUtil;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.NewDriver;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.control.gui.ReportGui;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.ReportMainFrame;
import org.apache.jmeter.plugin.JMeterPlugin;
import org.apache.jmeter.plugin.PluginManager;
import org.apache.jmeter.report.gui.ReportPageGui;
import org.apache.jmeter.report.gui.action.ReportActionRouter;
import org.apache.jmeter.report.gui.action.ReportLoad;
import org.apache.jmeter.report.gui.tree.ReportTreeListener;
import org.apache.jmeter.report.gui.tree.ReportTreeModel;
import org.apache.jmeter.report.writers.gui.HTMLReportWriterGui;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.gui.AbstractListenerGui;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class JMeterReport
implements JMeterPlugin {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int PROPFILE_OPT = 112;
    private static final int PROPFILE2_OPT = 113;
    private static final int TESTFILE_OPT = 116;
    private static final int LOGFILE_OPT = 108;
    private static final int NONGUI_OPT = 110;
    private static final int HELP_OPT = 104;
    private static final int VERSION_OPT = 118;
    private static final int SERVER_OPT = 115;
    private static final int JMETER_PROPERTY = 74;
    private static final int SYSTEM_PROPERTY = 68;
    private static final int LOGLEVEL = 76;
    private static final int REMOTE_OPT = 114;
    private static final int JMETER_HOME_OPT = 100;
    private static final CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print usage information and exit"), new CLOptionDescriptor("version", 8, 118, "print the version information and exit"), new CLOptionDescriptor("propfile", 2, 112, "the jmeter property file to use"), new CLOptionDescriptor("addprop", 34, 113, "additional property file(s)"), new CLOptionDescriptor("testfile", 2, 116, "the jmeter test(.jmx) file to run"), new CLOptionDescriptor("logfile", 2, 108, "the file to log samples to"), new CLOptionDescriptor("nongui", 8, 110, "run JMeter in nongui mode"), new CLOptionDescriptor("server", 8, 115, "run the JMeter server"), new CLOptionDescriptor("jmeterproperty", 48, 74, "Define additional JMeter properties"), new CLOptionDescriptor("systemproperty", 48, 68, "Define additional JMeter properties"), new CLOptionDescriptor("loglevel", 48, 76, "Define loglevel: [category=]level e.g. jorphan=INFO or jmeter.util=DEBUG"), new CLOptionDescriptor("runremote", 8, 114, "Start remote servers from non-gui mode"), new CLOptionDescriptor("homedir", 2, 100, "the jmeter home directory to use")};
    private static final String[][] DEFAULT_ICONS = new String[][]{{AbstractListenerGui.class.getName(), "org/apache/jmeter/images/meter.png"}, {AbstractConfigGui.class.getName(), "org/apache/jmeter/images/testtubes.png"}, {HTMLReportWriterGui.class.getName(), "org/apache/jmeter/images/new/pencil.png"}, {ReportPageGui.class.getName(), "org/apache/jmeter/images/new/scroll.png"}, {ReportGui.class.getName(), "org/apache/jmeter/images/new/book.png"}};

    public String[][] getIconMappings() {
        String iconProp = JMeterUtils.getPropDefault((String)"jmeter.icons", (String)"org/apache/jmeter/images/icon.properties");
        Properties p = JMeterUtils.loadProperties((String)iconProp);
        if (p == null) {
            log.info(iconProp + " not found - using default icon set");
            return DEFAULT_ICONS;
        }
        log.info("Loaded icon properties from " + iconProp);
        String[][] iconlist = new String[p.size()][3];
        Enumeration<Object> pe = p.keys();
        int i = 0;
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            String[] icons = JOrphanUtils.split((String)p.getProperty(key), (String)" ");
            iconlist[i][0] = key;
            iconlist[i][1] = icons[0];
            if (icons.length > 1) {
                iconlist[i][2] = icons[1];
            }
            ++i;
        }
        return iconlist;
    }

    public String[][] getResourceBundles() {
        return new String[0][];
    }

    public void startNonGui(CLOption testFile, CLOption logFile) {
        System.setProperty("JMeter.NonGui", "true");
        PluginManager.install((JMeterPlugin)this, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGui(CLOption testFile) {
        PluginManager.install((JMeterPlugin)this, (boolean)true);
        ReportTreeModel treeModel = new ReportTreeModel();
        ReportTreeListener treeLis = new ReportTreeListener(treeModel);
        treeLis.setActionHandler(ReportActionRouter.getInstance());
        ReportGuiPackage.getInstance(treeLis, treeModel);
        ReportMainFrame main = new ReportMainFrame(treeModel, treeLis);
        ComponentUtil.centerComponentInWindow((Component)main, (int)80);
        main.setVisible(true);
        ReportActionRouter.getInstance().actionPerformed(new ActionEvent(main, 1, "add_all"));
        if (testFile != null) {
            FileInputStream reader = null;
            try {
                File f = new File(testFile.getArgument());
                log.info("Loading file: " + f);
                reader = new FileInputStream(f);
                HashTree tree = SaveService.loadTree((InputStream)reader);
                ReportGuiPackage.getInstance().setReportPlanFile(f.getAbsolutePath());
                new ReportLoad().insertLoadedTree(1, tree);
                JOrphanUtils.closeQuietly((Closeable)reader);
            }
            catch (Exception e) {
                log.error("Failure loading test file", (Throwable)e);
                JMeterUtils.reportErrorToUser((String)e.toString());
            }
            finally {
                JOrphanUtils.closeQuietly(reader);
            }
        }
    }

    public void start(String[] args) {
        CLArgsParser parser = new CLArgsParser(args, options);
        if (null != parser.getErrorString()) {
            System.err.println("Error: " + parser.getErrorString());
            System.out.println("Usage");
            System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
            return;
        }
        try {
            this.initializeProperties(parser);
            log.info("Version " + JMeterUtils.getJMeterVersion());
            log.info("java.version=" + System.getProperty("java.version"));
            log.info(JMeterUtils.getJMeterCopyright());
            if (parser.getArgumentById(118) != null) {
                System.out.println(JMeterUtils.getJMeterCopyright());
                System.out.println("Version " + JMeterUtils.getJMeterVersion());
            } else if (parser.getArgumentById(104) != null) {
                System.out.println(JMeterUtils.getResourceFileAsText((String)"org/apache/jmeter/help.txt"));
            } else if (parser.getArgumentById(110) == null) {
                this.startGui(parser.getArgumentById(116));
            } else {
                this.startNonGui(parser.getArgumentById(116), parser.getArgumentById(108));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("An error occurred: " + e.getMessage());
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initializeProperties(CLArgsParser parser) {
        if (parser.getArgumentById(112) != null) {
            JMeterUtils.getProperties((String)parser.getArgumentById(112).getArgument());
        } else {
            JMeterUtils.getProperties((String)(NewDriver.getJMeterDir() + File.separator + "bin" + File.separator + "jmeter.properties"));
        }
        if (parser.getArgumentById(100) == null) {
            JMeterUtils.setJMeterHome((String)NewDriver.getJMeterDir());
        } else {
            JMeterUtils.setJMeterHome((String)parser.getArgumentById(100).getArgument());
        }
        Properties jmeterProps = JMeterUtils.getJMeterProperties();
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        block12: for (int i = 0; i < size; ++i) {
            CLOption option = (CLOption)clOptions.get(i);
            String name = option.getArgument(0);
            String value = option.getArgument(1);
            switch (option.getDescriptor().getId()) {
                case 113: {
                    File f = new File(name);
                    FileInputStream inStream = null;
                    try {
                        inStream = new FileInputStream(f);
                        jmeterProps.load(inStream);
                    }
                    catch (FileNotFoundException e) {
                        log.warn("Can't find additional property file: " + name, (Throwable)e);
                        IOUtils.closeQuietly((InputStream)inStream);
                        continue block12;
                    }
                    catch (IOException e2) {
                        log.warn("Error loading additional property file: " + name, (Throwable)e2);
                        {
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(inStream);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((InputStream)inStream);
                        continue block12;
                    }
                    IOUtils.closeQuietly((InputStream)inStream);
                    continue block12;
                }
                case 68: {
                    if (value.length() > 0) {
                        log.info("Setting System property: " + name + "=" + value);
                        System.getProperties().setProperty(name, value);
                        continue block12;
                    }
                    log.warn("Removing System property: " + name);
                    System.getProperties().remove(name);
                    continue block12;
                }
                case 74: {
                    if (value.length() > 0) {
                        log.info("Setting JMeter property: " + name + "=" + value);
                        jmeterProps.setProperty(name, value);
                        continue block12;
                    }
                    log.warn("Removing JMeter property: " + name);
                    jmeterProps.remove(name);
                    continue block12;
                }
                case 76: {
                    if (value.length() > 0) {
                        log.info("LogLevel: " + name + "=" + value);
                        LoggingManager.setPriority((String)value, (String)name);
                        continue block12;
                    }
                    log.warn("LogLevel: " + name);
                    LoggingManager.setPriority((String)name);
                    continue block12;
                }
            }
        }
    }
}

