/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.report.gui.action.AbstractAction;
import org.apache.jmeter.report.gui.action.ReportActionRouter;
import org.apache.jmeter.report.gui.action.ReportExitCommand;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ReportCheckDirty
extends AbstractAction
implements HashTreeTraverser,
ActionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static Map<ReportTreeNode, TestElement> previousGuiItems;
    public static final String CHECK_DIRTY = "check_dirty";
    public static final String SUB_TREE_SAVED = "sub_tree_saved";
    public static final String SUB_TREE_LOADED = "sub_tree_loaded";
    public static final String ADD_ALL = "add_all";
    public static final String REMOVE = "check_remove";
    boolean checkMode = false;
    boolean removeMode = false;
    boolean dirty = false;
    private static final Set<String> commands;

    public ReportCheckDirty() {
        previousGuiItems = new HashMap<ReportTreeNode, TestElement>();
        ReportActionRouter.getInstance().addPreActionListener(ReportExitCommand.class, this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("exit")) {
            this.doAction(e);
        }
    }

    @Override
    public void doAction(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(SUB_TREE_SAVED)) {
            HashTree subTree = (HashTree)e.getSource();
            subTree.traverse((HashTreeTraverser)this);
        } else if (action.equals(SUB_TREE_LOADED)) {
            ListedHashTree addTree = (ListedHashTree)e.getSource();
            addTree.traverse((HashTreeTraverser)this);
        } else if (action.equals(ADD_ALL)) {
            previousGuiItems.clear();
            ReportGuiPackage.getInstance().getTreeModel().getReportPlan().traverse((HashTreeTraverser)this);
        } else if (action.equals(REMOVE)) {
            ReportGuiPackage guiPackage = ReportGuiPackage.getInstance();
            ReportTreeNode[] nodes = guiPackage.getTreeListener().getSelectedNodes();
            this.removeMode = true;
            for (int i = nodes.length - 1; i >= 0; --i) {
                guiPackage.getTreeModel().getCurrentSubTree(nodes[i]).traverse((HashTreeTraverser)this);
            }
            this.removeMode = false;
        }
        this.checkMode = true;
        this.dirty = false;
        HashTree wholeTree = ReportGuiPackage.getInstance().getTreeModel().getReportPlan();
        wholeTree.traverse((HashTreeTraverser)this);
        ReportGuiPackage.getInstance().setDirty(this.dirty);
        this.checkMode = false;
    }

    public void addNode(Object node, HashTree subTree) {
        log.debug("Node is class:" + node.getClass());
        ReportTreeNode treeNode = (ReportTreeNode)node;
        if (this.checkMode) {
            if (previousGuiItems.containsKey(treeNode)) {
                if (!previousGuiItems.get(treeNode).equals(treeNode.getTestElement())) {
                    this.dirty = true;
                }
            } else {
                this.dirty = true;
            }
        } else if (this.removeMode) {
            previousGuiItems.remove(treeNode);
        } else {
            previousGuiItems.put(treeNode, (TestElement)treeNode.getTestElement().clone());
        }
    }

    public void subtractNode() {
    }

    public void processPath() {
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands = new HashSet<String>();
        commands.add(CHECK_DIRTY);
        commands.add(SUB_TREE_SAVED);
        commands.add(SUB_TREE_LOADED);
        commands.add(ADD_ALL);
        commands.add(REMOVE);
    }
}

