/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNotSyncedException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import javax.swing.Icon;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class FsSyncController<M extends FsModel>
extends FsDecoratingController<M, FsController<? extends M>> {
    private static final BitField<FsSyncOption> SYNC_OPTIONS = BitField.of((Enum)FsSyncOption.WAIT_CLOSE_INPUT, (Enum[])new FsSyncOption[]{FsSyncOption.WAIT_CLOSE_OUTPUT});
    private static final SyncSocketFactory SYNC_SOCKET_FACTORY = JSE7.AVAILABLE ? SyncSocketFactory.NIO2 : SyncSocketFactory.OIO;

    public FsSyncController(FsController<? extends M> controller) {
        super(controller);
    }

    @Override
    public Icon getOpenIcon() throws IOException {
        while (true) {
            try {
                return this.delegate.getOpenIcon();
            }
            catch (FsNotSyncedException ex) {
                this.delegate.sync(SYNC_OPTIONS);
                continue;
            }
            break;
        }
    }

    @Override
    public Icon getClosedIcon() throws IOException {
        while (true) {
            try {
                return this.delegate.getClosedIcon();
            }
            catch (FsNotSyncedException ex) {
                this.delegate.sync(SYNC_OPTIONS);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isReadOnly() throws IOException {
        while (true) {
            try {
                return this.delegate.isReadOnly();
            }
            catch (FsNotSyncedException ex) {
                this.delegate.sync(SYNC_OPTIONS);
                continue;
            }
            break;
        }
    }

    @Override
    public FsEntry getEntry(FsEntryName name) throws IOException {
        while (true) {
            try {
                return this.delegate.getEntry(name);
            }
            catch (FsNotSyncedException ex) {
                this.delegate.sync(SYNC_OPTIONS);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isReadable(FsEntryName name) throws IOException {
        while (true) {
            try {
                return this.delegate.isReadable(name);
            }
            catch (FsNotSyncedException ex) {
                this.delegate.sync(SYNC_OPTIONS);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isWritable(FsEntryName name) throws IOException {
        while (true) {
            try {
                return this.delegate.isWritable(name);
            }
            catch (FsNotSyncedException ex) {
                this.delegate.sync(SYNC_OPTIONS);
                continue;
            }
            break;
        }
    }

    @Override
    public void setReadOnly(FsEntryName name) throws IOException {
        while (true) {
            try {
                while (true) {
                    this.delegate.setReadOnly(name);
                }
            }
            catch (FsNotSyncedException ex) {
                this.delegate.sync(SYNC_OPTIONS);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        while (true) {
            try {
                return this.delegate.setTime(name, times, options);
            }
            catch (FsNotSyncedException ex) {
                this.delegate.sync(SYNC_OPTIONS);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        while (true) {
            try {
                return this.delegate.setTime(name, types, value, options);
            }
            catch (FsNotSyncedException ex) {
                this.delegate.sync(SYNC_OPTIONS);
                continue;
            }
            break;
        }
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return SYNC_SOCKET_FACTORY.newInputSocket(this, this.delegate.getInputSocket(name, options));
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        return SYNC_SOCKET_FACTORY.newOutputSocket(this, this.delegate.getOutputSocket(name, options, template));
    }

    @Override
    public void mknod(@NonNull FsEntryName name, @NonNull Entry.Type type, @NonNull BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        while (true) {
            try {
                this.delegate.mknod(name, type, options, template);
                return;
            }
            catch (FsNotSyncedException ex) {
                this.delegate.sync(SYNC_OPTIONS);
                continue;
            }
            break;
        }
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        while (true) {
            try {
                this.delegate.unlink(name, options);
                return;
            }
            catch (FsNotSyncedException ex) {
                this.delegate.sync(SYNC_OPTIONS);
                continue;
            }
            break;
        }
    }

    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(OutputSocket<?> output) {
            super(output);
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            while (true) {
                try {
                    return (Entry)this.getBoundSocket().getLocalTarget();
                }
                catch (FsNotSyncedException ex) {
                    FsSyncController.this.delegate.sync(SYNC_OPTIONS);
                    continue;
                }
                break;
            }
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            while (true) {
                try {
                    return this.getBoundSocket().newOutputStream();
                }
                catch (FsNotSyncedException ex) {
                    FsSyncController.this.delegate.sync(SYNC_OPTIONS);
                    continue;
                }
                break;
            }
        }
    }

    private final class Nio2Output
    extends Output {
        Nio2Output(OutputSocket<?> output) {
            super(output);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            while (true) {
                try {
                    return this.getBoundSocket().newSeekableByteChannel();
                }
                catch (FsNotSyncedException ex) {
                    FsSyncController.this.delegate.sync(SYNC_OPTIONS);
                    continue;
                }
                break;
            }
        }
    }

    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(InputSocket<?> input) {
            super(input);
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            while (true) {
                try {
                    return (Entry)this.getBoundSocket().getLocalTarget();
                }
                catch (FsNotSyncedException ex) {
                    FsSyncController.this.delegate.sync(SYNC_OPTIONS);
                    continue;
                }
                break;
            }
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            while (true) {
                try {
                    return this.getBoundSocket().newReadOnlyFile();
                }
                catch (FsNotSyncedException ex) {
                    FsSyncController.this.delegate.sync(SYNC_OPTIONS);
                    continue;
                }
                break;
            }
        }

        @Override
        public InputStream newInputStream() throws IOException {
            while (true) {
                try {
                    return this.getBoundSocket().newInputStream();
                }
                catch (FsNotSyncedException ex) {
                    FsSyncController.this.delegate.sync(SYNC_OPTIONS);
                    continue;
                }
                break;
            }
        }
    }

    private final class Nio2Input
    extends Input {
        Nio2Input(InputSocket<?> input) {
            super(input);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            while (true) {
                try {
                    return this.getBoundSocket().newSeekableByteChannel();
                }
                catch (FsNotSyncedException ex) {
                    FsSyncController.this.delegate.sync(SYNC_OPTIONS);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private static enum SyncSocketFactory {
        OIO{

            @Override
            InputSocket<?> newInputSocket(FsSyncController<?> controller, InputSocket<?> input) {
                FsSyncController<?> fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Input(input);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsSyncController<?> controller, OutputSocket<?> output) {
                FsSyncController<?> fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Output(output);
            }
        }
        ,
        NIO2{

            @Override
            InputSocket<?> newInputSocket(FsSyncController<?> controller, InputSocket<?> input) {
                FsSyncController<?> fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Nio2Input(input);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsSyncController<?> controller, OutputSocket<?> output) {
                FsSyncController<?> fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Nio2Output(output);
            }
        };


        abstract InputSocket<?> newInputSocket(FsSyncController<?> var1, InputSocket<?> var2);

        abstract OutputSocket<?> newOutputSocket(FsSyncController<?> var1, OutputSocket<?> var2);
    }
}

