/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.SeekableByteChannel;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class SeekableByteBufferChannel
implements SeekableByteChannel {
    private ByteBuffer buffer;

    public SeekableByteBufferChannel(ByteBuffer buffer) {
        if (!buffer.hasArray()) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer.duplicate();
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer.duplicate();
    }

    @Override
    public final int read(ByteBuffer dst) {
        int available = this.buffer.remaining();
        if (available <= 0) {
            return -1;
        }
        int remaining = dst.remaining();
        if (remaining > available) {
            remaining = available;
        }
        int position = this.buffer.position();
        dst.put(this.buffer.array(), this.buffer.arrayOffset() + position, remaining);
        this.buffer.position(position + remaining);
        return remaining;
    }

    @Override
    public final int write(ByteBuffer src) {
        int remaining = src.remaining();
        int position = this.buffer.position();
        this.ensureLimit(position + remaining);
        src.get(this.buffer.array(), this.buffer.arrayOffset() + position, remaining);
        this.buffer.position(position + remaining);
        return remaining;
    }

    @Override
    public final long position() {
        return this.buffer.position();
    }

    private void ensureLimit(long minLimit) {
        int limit = this.buffer.limit();
        if (minLimit <= (long)limit) {
            return;
        }
        if (this.buffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        long oldCapacity = this.buffer.capacity();
        if (minLimit <= oldCapacity) {
            this.buffer.limit((int)minLimit);
        } else {
            if (minLimit > Integer.MAX_VALUE) {
                throw new OutOfMemoryError();
            }
            long newCapacity = oldCapacity << 1;
            if (newCapacity > Integer.MAX_VALUE) {
                newCapacity = minLimit;
            }
            byte[] array = new byte[(int)newCapacity];
            System.arraycopy(this.buffer.array(), this.buffer.arrayOffset(), array, 0, limit);
            this.buffer = ByteBuffer.wrap(array);
        }
    }

    @Override
    public final SeekableByteBufferChannel position(long newPosition) {
        this.ensureLimit(newPosition);
        this.buffer.position((int)newPosition);
        return this;
    }

    @Override
    public final long size() {
        return this.buffer.limit();
    }

    @Override
    public final SeekableByteBufferChannel truncate(long newSize) {
        if (newSize < (long)this.buffer.limit()) {
            this.buffer.limit((int)newSize);
        }
        return this;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

