/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.gui.Stoppable;
import org.apache.jmeter.protocol.http.proxy.Proxy;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class Daemon
extends Thread
implements Stoppable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int ACCEPT_TIMEOUT = 1000;
    private final int daemonPort;
    private final ServerSocket mainSocket;
    private volatile boolean running;
    private final ProxyControl target;
    private final Class<? extends Proxy> proxyClass;

    public Daemon(int port, ProxyControl target) throws IOException {
        this(port, target, Proxy.class);
    }

    public Daemon(int port, ProxyControl target, Class<? extends Proxy> proxyClass) throws IOException {
        super("HTTP Proxy Daemon");
        this.target = target;
        this.daemonPort = port;
        this.proxyClass = proxyClass;
        log.info("Creating Daemon Socket on port: " + this.daemonPort);
        this.mainSocket = new ServerSocket(this.daemonPort);
        this.mainSocket.setSoTimeout(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.running = true;
        log.info("Proxy up and running!");
        Map<String, String> pageEncodings = Collections.synchronizedMap(new HashMap());
        Map<String, String> formEncodings = Collections.synchronizedMap(new HashMap());
        try {
            while (this.running) {
                try {
                    Socket clientSocket = this.mainSocket.accept();
                    if (!this.running) continue;
                    Proxy thd = this.proxyClass.newInstance();
                    thd.configure(clientSocket, this.target, pageEncodings, formEncodings);
                    thd.start();
                }
                catch (InterruptedIOException e) {}
            }
            log.info("Proxy Server stopped");
            return;
        }
        catch (Exception e) {
            log.warn("Proxy Server stopped", (Throwable)e);
            return;
        }
        finally {
            JOrphanUtils.closeQuietly((ServerSocket)this.mainSocket);
        }
    }

    public void stopServer() {
        this.running = false;
    }
}

