/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jmeter.assertions.ResponseAssertion;
import org.apache.jmeter.assertions.gui.AssertionGui;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.control.gui.LogicControllerGui;
import org.apache.jmeter.control.gui.TransactionControllerGui;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.Stoppable;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.control.RecordingController;
import org.apache.jmeter.protocol.http.gui.HeaderPanel;
import org.apache.jmeter.protocol.http.proxy.Daemon;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.Pattern;

public class ProxyControl
extends GenericController {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final String ASSERTION_GUI = AssertionGui.class.getName();
    private static final String TRANSACTION_CONTROLLER_GUI = TransactionControllerGui.class.getName();
    private static final String LOGIC_CONTROLLER_GUI = LogicControllerGui.class.getName();
    private static final String HEADER_PANEL = HeaderPanel.class.getName();
    private transient Daemon server;
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_PORT_S = Integer.toString(8080);
    private static final String PORT = "ProxyControlGui.port";
    private static final String EXCLUDE_LIST = "ProxyControlGui.exclude_list";
    private static final String INCLUDE_LIST = "ProxyControlGui.include_list";
    private static final String CAPTURE_HTTP_HEADERS = "ProxyControlGui.capture_http_headers";
    private static final String ADD_ASSERTIONS = "ProxyControlGui.add_assertion";
    private static final String GROUPING_MODE = "ProxyControlGui.grouping_mode";
    private static final String SAMPLER_TYPE_NAME = "ProxyControlGui.sampler_type_name";
    private static final String SAMPLER_REDIRECT_AUTOMATICALLY = "ProxyControlGui.sampler_redirect_automatically";
    private static final String SAMPLER_FOLLOW_REDIRECTS = "ProxyControlGui.sampler_follow_redirects";
    private static final String USE_KEEPALIVE = "ProxyControlGui.use_keepalive";
    private static final String SAMPLER_DOWNLOAD_IMAGES = "ProxyControlGui.sampler_download_images";
    private static final String REGEX_MATCH = "ProxyControlGui.regex_match";
    private static final String CONTENT_TYPE_EXCLUDE = "ProxyControlGui.content_type_exclude";
    private static final String CONTENT_TYPE_INCLUDE = "ProxyControlGui.content_type_include";
    private static final int GROUPING_ADD_SEPARATORS = 1;
    private static final int GROUPING_IN_SIMPLE_CONTROLLERS = 2;
    private static final int GROUPING_STORE_FIRST_ONLY = 3;
    private static final int GROUPING_IN_TRANSACTION_CONTROLLERS = 4;
    private static final String SAMPLER_TYPE_HTTP_SAMPLER_JAVA = "0";
    private static final String SAMPLER_TYPE_HTTP_SAMPLER_HC3_1 = "1";
    private static final String SAMPLER_TYPE_HTTP_SAMPLER_HC4 = "2";
    private long lastTime = 0L;
    private static final long sampleGap = JMeterUtils.getPropDefault((String)"proxy.pause", (int)1000);
    private AtomicBoolean addAssertions = new AtomicBoolean(false);
    private AtomicInteger groupingMode = new AtomicInteger(0);
    private AtomicBoolean samplerRedirectAutomatically = new AtomicBoolean(false);
    private AtomicBoolean samplerFollowRedirects = new AtomicBoolean(false);
    private AtomicBoolean useKeepAlive = new AtomicBoolean(false);
    private AtomicBoolean samplerDownloadImages = new AtomicBoolean(false);
    private AtomicBoolean regexMatch = new AtomicBoolean(false);
    private JMeterTreeNode target;

    public ProxyControl() {
        this.setPort(8080);
        this.setExcludeList(new HashSet<String>());
        this.setIncludeList(new HashSet<String>());
        this.setCaptureHttpHeaders(true);
    }

    public void setPort(int port) {
        this.setProperty((JMeterProperty)new IntegerProperty(PORT, port));
    }

    public void setPort(String port) {
        this.setProperty(PORT, port);
    }

    public void setCaptureHttpHeaders(boolean capture) {
        this.setProperty((JMeterProperty)new BooleanProperty(CAPTURE_HTTP_HEADERS, capture));
    }

    public void setGroupingMode(int grouping) {
        this.groupingMode.set(grouping);
        this.setProperty((JMeterProperty)new IntegerProperty(GROUPING_MODE, grouping));
    }

    public void setAssertions(boolean b) {
        this.addAssertions.set(b);
        this.setProperty((JMeterProperty)new BooleanProperty(ADD_ASSERTIONS, b));
    }

    @Deprecated
    public void setSamplerTypeName(int samplerTypeName) {
        this.setProperty((JMeterProperty)new IntegerProperty(SAMPLER_TYPE_NAME, samplerTypeName));
    }

    public void setSamplerTypeName(String samplerTypeName) {
        this.setProperty((JMeterProperty)new StringProperty(SAMPLER_TYPE_NAME, samplerTypeName));
    }

    public void setSamplerRedirectAutomatically(boolean b) {
        this.samplerRedirectAutomatically.set(b);
        this.setProperty((JMeterProperty)new BooleanProperty(SAMPLER_REDIRECT_AUTOMATICALLY, b));
    }

    public void setSamplerFollowRedirects(boolean b) {
        this.samplerFollowRedirects.set(b);
        this.setProperty((JMeterProperty)new BooleanProperty(SAMPLER_FOLLOW_REDIRECTS, b));
    }

    public void setUseKeepAlive(boolean b) {
        this.useKeepAlive.set(b);
        this.setProperty((JMeterProperty)new BooleanProperty(USE_KEEPALIVE, b));
    }

    public void setSamplerDownloadImages(boolean b) {
        this.samplerDownloadImages.set(b);
        this.setProperty((JMeterProperty)new BooleanProperty(SAMPLER_DOWNLOAD_IMAGES, b));
    }

    public void setIncludeList(Collection<String> list) {
        this.setProperty((JMeterProperty)new CollectionProperty(INCLUDE_LIST, new HashSet<String>(list)));
    }

    public void setExcludeList(Collection<String> list) {
        this.setProperty((JMeterProperty)new CollectionProperty(EXCLUDE_LIST, new HashSet<String>(list)));
    }

    public void setRegexMatch(boolean b) {
        this.regexMatch.set(b);
        this.setProperty((JMeterProperty)new BooleanProperty(REGEX_MATCH, b));
    }

    public void setContentTypeExclude(String contentTypeExclude) {
        this.setProperty((JMeterProperty)new StringProperty(CONTENT_TYPE_EXCLUDE, contentTypeExclude));
    }

    public void setContentTypeInclude(String contentTypeInclude) {
        this.setProperty((JMeterProperty)new StringProperty(CONTENT_TYPE_INCLUDE, contentTypeInclude));
    }

    public boolean getAssertions() {
        return this.getPropertyAsBoolean(ADD_ASSERTIONS);
    }

    public int getGroupingMode() {
        return this.getPropertyAsInt(GROUPING_MODE);
    }

    public int getPort() {
        return this.getPropertyAsInt(PORT);
    }

    public String getPortString() {
        return this.getPropertyAsString(PORT);
    }

    public int getDefaultPort() {
        return 8080;
    }

    public boolean getCaptureHttpHeaders() {
        return this.getPropertyAsBoolean(CAPTURE_HTTP_HEADERS);
    }

    public String getSamplerTypeName() {
        String type = this.getPropertyAsString(SAMPLER_TYPE_NAME);
        if (SAMPLER_TYPE_HTTP_SAMPLER_JAVA.equals(type)) {
            type = "Java";
        } else if (SAMPLER_TYPE_HTTP_SAMPLER_HC3_1.equals(type)) {
            type = "HttpClient3.1";
        } else if (SAMPLER_TYPE_HTTP_SAMPLER_HC4.equals(type)) {
            type = "HttpClient4";
        }
        return type;
    }

    public boolean getSamplerRedirectAutomatically() {
        return this.getPropertyAsBoolean(SAMPLER_REDIRECT_AUTOMATICALLY, false);
    }

    public boolean getSamplerFollowRedirects() {
        return this.getPropertyAsBoolean(SAMPLER_FOLLOW_REDIRECTS, true);
    }

    public boolean getUseKeepalive() {
        return this.getPropertyAsBoolean(USE_KEEPALIVE, true);
    }

    public boolean getSamplerDownloadImages() {
        return this.getPropertyAsBoolean(SAMPLER_DOWNLOAD_IMAGES, false);
    }

    public boolean getRegexMatch() {
        return this.getPropertyAsBoolean(REGEX_MATCH, false);
    }

    public String getContentTypeExclude() {
        return this.getPropertyAsString(CONTENT_TYPE_EXCLUDE);
    }

    public String getContentTypeInclude() {
        return this.getPropertyAsString(CONTENT_TYPE_INCLUDE);
    }

    public void addConfigElement(ConfigElement config) {
    }

    public void startProxy() throws IOException {
        this.notifyTestListenersOfStart();
        try {
            this.server = new Daemon(this.getPort(), this);
            this.server.start();
            GuiPackage.getInstance().register((Stoppable)this.server);
        }
        catch (IOException e) {
            log.error("Could not create Proxy daemon", (Throwable)e);
            throw e;
        }
    }

    public void addExcludedPattern(String pattern) {
        this.getExcludePatterns().addItem((Object)pattern);
    }

    public CollectionProperty getExcludePatterns() {
        return (CollectionProperty)this.getProperty(EXCLUDE_LIST);
    }

    public void addIncludedPattern(String pattern) {
        this.getIncludePatterns().addItem((Object)pattern);
    }

    public CollectionProperty getIncludePatterns() {
        return (CollectionProperty)this.getProperty(INCLUDE_LIST);
    }

    public void clearExcludedPatterns() {
        this.getExcludePatterns().clear();
    }

    public void clearIncludedPatterns() {
        this.getIncludePatterns().clear();
    }

    public JMeterTreeNode getTarget() {
        return this.target;
    }

    public void setTarget(JMeterTreeNode target) {
        this.target = target;
    }

    public synchronized void deliverSampler(HTTPSamplerBase sampler, TestElement[] subConfigs, SampleResult result) {
        if (this.filterContentType(result) && this.filterUrl(sampler)) {
            JMeterTreeNode myTarget = this.findTargetControllerNode();
            Collection<ConfigTestElement> defaultConfigurations = this.findApplicableElements(myTarget, ConfigTestElement.class, false);
            Collection<Arguments> userDefinedVariables = this.findApplicableElements(myTarget, Arguments.class, true);
            this.removeValuesFromSampler(sampler, defaultConfigurations);
            this.replaceValues((TestElement)sampler, subConfigs, userDefinedVariables);
            sampler.setAutoRedirects(this.samplerRedirectAutomatically.get());
            sampler.setFollowRedirects(this.samplerFollowRedirects.get());
            sampler.setUseKeepAlive(this.useKeepAlive.get());
            sampler.setImageParser(this.samplerDownloadImages.get());
            this.placeSampler(sampler, subConfigs, myTarget);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Sample excluded based on url or content-type: " + result.getUrlAsString() + " - " + result.getContentType());
            }
            result.setSampleLabel("[" + result.getSampleLabel() + "]");
        }
        this.notifySampleListeners(new SampleEvent(result, "WorkBench"));
    }

    public void stopProxy() {
        if (this.server != null) {
            this.server.stopServer();
            GuiPackage.getInstance().unregister((Stoppable)this.server);
            try {
                this.server.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.notifyTestListenersOfEnd();
            this.server = null;
        }
    }

    boolean filterUrl(HTTPSamplerBase sampler) {
        String domain = sampler.getDomain();
        if (domain == null || domain.length() == 0) {
            return false;
        }
        String url = this.generateMatchUrl(sampler);
        CollectionProperty includePatterns = this.getIncludePatterns();
        if (includePatterns.size() > 0 && !this.matchesPatterns(url, includePatterns)) {
            return false;
        }
        CollectionProperty excludePatterns = this.getExcludePatterns();
        return excludePatterns.size() <= 0 || !this.matchesPatterns(url, excludePatterns);
    }

    boolean filterContentType(SampleResult result) {
        boolean matched;
        String includeExp = this.getContentTypeInclude();
        String excludeExp = this.getContentTypeExclude();
        if (!(includeExp != null && includeExp.length() != 0 || excludeExp != null && excludeExp.length() != 0)) {
            return true;
        }
        String sampleContentType = result.getContentType();
        if (sampleContentType == null || sampleContentType.length() == 0) {
            if (log.isDebugEnabled()) {
                log.debug("No Content-type found for : " + result.getUrlAsString());
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Content-type to filter : " + sampleContentType);
        }
        if (!(matched = this.testPattern(includeExp, sampleContentType, true))) {
            return false;
        }
        matched = this.testPattern(excludeExp, sampleContentType, false);
        return matched;
    }

    private final boolean testPattern(String expression, String sampleContentType, boolean expectedToMatch) {
        if (expression != null && expression.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Testing Expression : " + expression + " on sampleContentType:" + sampleContentType + ", expected to match:" + expectedToMatch);
            }
            Pattern pattern = null;
            try {
                pattern = JMeterUtils.getPatternCache().getPattern(expression, 32784);
                if (JMeterUtils.getMatcher().contains(sampleContentType, pattern) != expectedToMatch) {
                    return false;
                }
            }
            catch (MalformedCachePatternException e) {
                log.warn("Skipped invalid content pattern: " + expression, (Throwable)e);
            }
        }
        return true;
    }

    private void addAssertion(JMeterTreeModel model, JMeterTreeNode node) throws IllegalUserActionException {
        ResponseAssertion ra = new ResponseAssertion();
        ra.setProperty("TestElement.gui_class", ASSERTION_GUI);
        ra.setName(JMeterUtils.getResString((String)"assertion_title"));
        ra.setTestFieldResponseData();
        model.addComponent((TestElement)ra, node);
    }

    private void addDivider(final JMeterTreeModel model, final JMeterTreeNode node) {
        final GenericController sc = new GenericController();
        sc.setProperty("TestElement.gui_class", LOGIC_CONTROLLER_GUI);
        sc.setName("-------------------");
        JMeterUtils.runSafe((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    model.addComponent((TestElement)sc, node);
                }
                catch (IllegalUserActionException e) {
                    log.error("Program error", (Throwable)e);
                    throw new Error(e);
                }
            }
        });
    }

    private void addSimpleController(final JMeterTreeModel model, final JMeterTreeNode node, String name) throws InterruptedException, InvocationTargetException {
        final GenericController sc = new GenericController();
        sc.setProperty("TestElement.gui_class", LOGIC_CONTROLLER_GUI);
        sc.setName(name);
        JMeterUtils.runSafe((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    model.addComponent((TestElement)sc, node);
                }
                catch (IllegalUserActionException e) {
                    log.error("Program error", (Throwable)e);
                    throw new Error(e);
                }
            }
        });
    }

    private void addTransactionController(final JMeterTreeModel model, final JMeterTreeNode node, String name) throws InterruptedException, InvocationTargetException {
        final TransactionController sc = new TransactionController();
        sc.setProperty("TestElement.gui_class", TRANSACTION_CONTROLLER_GUI);
        sc.setName(name);
        JMeterUtils.runSafe((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    model.addComponent((TestElement)sc, node);
                }
                catch (IllegalUserActionException e) {
                    log.error("Program error", (Throwable)e);
                    throw new Error(e);
                }
            }
        });
    }

    private void addTimers(JMeterTreeModel model, JMeterTreeNode node, long deltaT) {
        TestPlan variables = new TestPlan();
        variables.addParameter("T", Long.toString(deltaT));
        ValueReplacer replacer = new ValueReplacer(variables);
        JMeterTreeNode mySelf = model.getNodeOf((TestElement)this);
        Enumeration children = mySelf.children();
        while (children.hasMoreElements()) {
            TestElement template;
            JMeterTreeNode templateNode = (JMeterTreeNode)children.nextElement();
            if (!templateNode.isEnabled() || !((template = templateNode.getTestElement()) instanceof Timer)) continue;
            TestElement timer = (TestElement)template.clone();
            try {
                replacer.undoReverseReplace(timer);
                model.addComponent(timer, node);
            }
            catch (InvalidVariableException e) {
                log.error("Program error", (Throwable)e);
                throw new Error(e);
            }
            catch (IllegalUserActionException e) {
                log.error("Program error", (Throwable)e);
                throw new Error(e);
            }
        }
    }

    private JMeterTreeNode findFirstNodeOfType(Class<?> type) {
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        List nodes = treeModel.getNodesOfType(type);
        for (JMeterTreeNode node : nodes) {
            if (!node.isEnabled()) continue;
            return node;
        }
        return null;
    }

    private JMeterTreeNode findTargetControllerNode() {
        JMeterTreeNode myTarget = this.getTarget();
        if (myTarget != null) {
            return myTarget;
        }
        myTarget = this.findFirstNodeOfType(RecordingController.class);
        if (myTarget != null) {
            return myTarget;
        }
        myTarget = this.findFirstNodeOfType(AbstractThreadGroup.class);
        if (myTarget != null) {
            return myTarget;
        }
        myTarget = this.findFirstNodeOfType(WorkBench.class);
        if (myTarget != null) {
            return myTarget;
        }
        log.error("Program error: proxy recording target not found.");
        return null;
    }

    private Collection<?> findApplicableElements(JMeterTreeNode myTarget, Class<? extends TestElement> myClass, boolean ascending) {
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        LinkedList<Object> elements = new LinkedList<Object>();
        Enumeration kids = treeModel.getNodeOf((TestElement)this).children();
        while (kids.hasMoreElements()) {
            TestElement element;
            JMeterTreeNode subNode = (JMeterTreeNode)kids.nextElement();
            if (!subNode.isEnabled() || !myClass.isInstance(element = (TestElement)subNode.getUserObject())) continue;
            if (ascending) {
                elements.addFirst(element);
                continue;
            }
            elements.add(element);
        }
        for (JMeterTreeNode controller = myTarget; controller != null; controller = (JMeterTreeNode)controller.getParent()) {
            kids = controller.children();
            while (kids.hasMoreElements()) {
                TestPlan tp;
                Arguments args;
                JMeterTreeNode subNode = (JMeterTreeNode)kids.nextElement();
                if (!subNode.isEnabled()) continue;
                TestElement element = (TestElement)subNode.getUserObject();
                if (myClass.isInstance(element)) {
                    log.debug("Applicable: " + element.getName());
                    if (ascending) {
                        elements.addFirst(element);
                    } else {
                        elements.add(element);
                    }
                }
                if (!(element instanceof TestPlan) || !myClass.isInstance(args = (tp = (TestPlan)element).getArguments())) continue;
                if (ascending) {
                    elements.addFirst(args);
                    continue;
                }
                elements.add(args);
            }
        }
        return elements;
    }

    private void placeSampler(final HTTPSamplerBase sampler, final TestElement[] subConfigs, JMeterTreeNode myTarget) {
        try {
            final JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
            boolean firstInBatch = false;
            long now = System.currentTimeMillis();
            long deltaT = now - this.lastTime;
            int cachedGroupingMode = this.groupingMode.get();
            if (deltaT > sampleGap) {
                if (!myTarget.isLeaf() && cachedGroupingMode == 1) {
                    this.addDivider(treeModel, myTarget);
                }
                if (cachedGroupingMode == 2) {
                    this.addSimpleController(treeModel, myTarget, sampler.getName());
                }
                if (cachedGroupingMode == 4) {
                    this.addTransactionController(treeModel, myTarget, sampler.getName());
                }
                firstInBatch = true;
            }
            if (this.lastTime == 0L) {
                deltaT = 0L;
            }
            this.lastTime = now;
            if (cachedGroupingMode == 3) {
                if (!firstInBatch) {
                    return;
                }
                sampler.setFollowRedirects(true);
                sampler.setImageParser(true);
            }
            if (cachedGroupingMode == 2 || cachedGroupingMode == 4) {
                for (int i = myTarget.getChildCount() - 1; i >= 0; --i) {
                    JMeterTreeNode c = (JMeterTreeNode)myTarget.getChildAt(i);
                    if (!(c.getTestElement() instanceof GenericController)) continue;
                    myTarget = c;
                    break;
                }
            }
            final long deltaTFinal = deltaT;
            final boolean firstInBatchFinal = firstInBatch;
            final JMeterTreeNode myTargetFinal = myTarget;
            JMeterUtils.runSafe((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        JMeterTreeNode newNode = treeModel.addComponent((TestElement)sampler, myTargetFinal);
                        if (firstInBatchFinal) {
                            if (ProxyControl.this.addAssertions.get()) {
                                ProxyControl.this.addAssertion(treeModel, newNode);
                            }
                            ProxyControl.this.addTimers(treeModel, newNode, deltaTFinal);
                        }
                        for (int i = 0; subConfigs != null && i < subConfigs.length; ++i) {
                            if (!(subConfigs[i] instanceof HeaderManager)) continue;
                            TestElement headerManager = subConfigs[i];
                            headerManager.setProperty("TestElement.gui_class", HEADER_PANEL);
                            treeModel.addComponent(headerManager, newNode);
                        }
                    }
                    catch (IllegalUserActionException e) {
                        JMeterUtils.reportErrorToUser((String)e.getMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            JMeterUtils.reportErrorToUser((String)e.getMessage());
        }
    }

    private void removeValuesFromSampler(HTTPSamplerBase sampler, Collection<ConfigTestElement> configurations) {
        PropertyIterator props = sampler.propertyIterator();
        block0: while (props.hasNext()) {
            JMeterProperty prop = props.next();
            String name = prop.getName();
            String value = prop.getStringValue();
            if (name.equals("TestElement.enabled") || name.equals("TestElement.gui_class") || name.equals("TestElement.name") || name.equals("TestElement.test_class")) continue;
            for (ConfigTestElement config : configurations) {
                String configValue = config.getPropertyAsString(name);
                if (configValue == null || configValue.length() <= 0) continue;
                if (!configValue.equals(value)) continue block0;
                sampler.setProperty(name, "");
                continue block0;
            }
        }
    }

    private String generateMatchUrl(HTTPSamplerBase sampler) {
        StringBuilder buf = new StringBuilder(sampler.getDomain());
        buf.append(':');
        buf.append(sampler.getPort());
        buf.append(sampler.getPath());
        if (sampler.getQueryString().length() > 0) {
            buf.append('?');
            buf.append(sampler.getQueryString());
        }
        return buf.toString();
    }

    private boolean matchesPatterns(String url, CollectionProperty patterns) {
        PropertyIterator iter = patterns.iterator();
        while (iter.hasNext()) {
            String item = iter.next().getStringValue();
            Pattern pattern = null;
            try {
                pattern = JMeterUtils.getPatternCache().getPattern(item, 32784);
                if (!JMeterUtils.getMatcher().matches(url, pattern)) continue;
                return true;
            }
            catch (MalformedCachePatternException e) {
                log.warn("Skipped invalid pattern: " + item, (Throwable)e);
            }
        }
        return false;
    }

    private void replaceValues(TestElement sampler, TestElement[] configs, Collection<Arguments> variables) {
        ValueReplacer replacer = new ValueReplacer();
        Iterator<Arguments> vars = variables.iterator();
        while (vars.hasNext()) {
            Map map = vars.next().getArgumentsAsMap();
            Iterator vals = map.values().iterator();
            while (vals.hasNext()) {
                Object next = vals.next();
                if (!"".equals(next)) continue;
                vals.remove();
            }
            replacer.addVariables(map);
        }
        try {
            boolean cachedRegexpMatch = this.regexMatch.get();
            replacer.reverseReplace(sampler, cachedRegexpMatch);
            for (int i = 0; i < configs.length; ++i) {
                if (configs[i] == null) continue;
                replacer.reverseReplace(configs[i], cachedRegexpMatch);
            }
        }
        catch (InvalidVariableException e) {
            log.warn("Invalid variables included for replacement into recorded sample", (Throwable)e);
        }
    }

    private void notifySampleListeners(SampleEvent event) {
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        JMeterTreeNode myNode = treeModel.getNodeOf((TestElement)this);
        Enumeration kids = myNode.children();
        while (kids.hasMoreElements()) {
            TestElement testElement;
            JMeterTreeNode subNode = (JMeterTreeNode)kids.nextElement();
            if (!subNode.isEnabled() || !((testElement = subNode.getTestElement()) instanceof SampleListener)) continue;
            ((SampleListener)testElement).sampleOccurred(event);
        }
    }

    private void notifyTestListenersOfStart() {
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        JMeterTreeNode myNode = treeModel.getNodeOf((TestElement)this);
        Enumeration kids = myNode.children();
        while (kids.hasMoreElements()) {
            TestElement testElement;
            JMeterTreeNode subNode = (JMeterTreeNode)kids.nextElement();
            if (!subNode.isEnabled() || !((testElement = subNode.getTestElement()) instanceof TestStateListener)) continue;
            ((TestStateListener)testElement).testStarted();
        }
    }

    private void notifyTestListenersOfEnd() {
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        JMeterTreeNode myNode = treeModel.getNodeOf((TestElement)this);
        Enumeration kids = myNode.children();
        while (kids.hasMoreElements()) {
            TestElement testElement;
            JMeterTreeNode subNode = (JMeterTreeNode)kids.nextElement();
            if (!subNode.isEnabled() || !((testElement = subNode.getTestElement()) instanceof TestStateListener)) continue;
            ((TestStateListener)testElement).testEnded();
        }
    }

    public boolean canRemove() {
        return null == this.server;
    }
}

