/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter;

import com.lazerycode.jmeter.UtilityFunctions;
import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.ProxyConfiguration;
import com.lazerycode.jmeter.configuration.RemoteConfiguration;
import com.lazerycode.jmeter.properties.PropertyHandler;
import com.lazerycode.jmeter.threadhandling.JMeterPluginSecurityManager;
import com.lazerycode.jmeter.threadhandling.JMeterPluginUncaughtExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.joda.time.format.DateTimeFormat;

public abstract class JMeterAbstractMojo
extends AbstractMojo {
    protected List<String> testFilesIncluded;
    protected List<String> testFilesExcluded;
    protected File testFilesDirectory;
    protected boolean testResultsTimestamp;
    protected boolean appendResultsTimestamp;
    protected String resultsFileNameDateFormat;
    protected String resultsFileFormat;
    protected Map<String, String> propertiesJMeter;
    protected Map<String, String> propertiesSaveService;
    protected Map<String, String> propertiesUpgrade;
    protected Map<String, String> propertiesUser;
    protected Map<String, String> propertiesGlobal;
    protected Map<String, String> propertiesSystem;
    protected File customPropertiesFile;
    protected boolean propertiesReplacedByCustomFiles;
    protected ProxyConfiguration proxyConfig;
    protected RemoteConfiguration remoteConfig;
    protected String overrideRootLogLevel;
    protected boolean ignoreResultFailures;
    protected boolean suppressJMeterOutput;
    protected MavenProject mavenProject;
    protected List<Artifact> pluginArtifacts;
    protected boolean skipTests;
    protected transient File workDir;
    protected File binDir;
    protected File libDir;
    protected File libExtDir;
    protected File logsDir;
    protected File resultsDir;
    protected final String jmeterConfigArtifact = "ApacheJMeter_config";
    protected JMeterArgumentsArray testArgs;
    protected PropertyHandler pluginProperties;
    protected boolean resultsOutputIsCSVFormat = false;

    protected void generateJMeterDirectoryTree() {
        this.logsDir = new File(this.workDir, "logs");
        this.logsDir.mkdirs();
        this.binDir = new File(this.workDir, "bin");
        this.binDir.mkdirs();
        this.resultsDir = new File(this.workDir, "results");
        this.resultsDir.mkdirs();
        this.libDir = new File(this.workDir, "lib");
        this.libExtDir = new File(this.libDir, "ext");
        this.libExtDir.mkdirs();
        new File(this.libDir, "junit").mkdirs();
    }

    protected void propertyConfiguration() throws MojoExecutionException {
        this.pluginProperties = new PropertyHandler(this.testFilesDirectory, this.binDir, this.getArtifactNamed("ApacheJMeter_config"), this.propertiesReplacedByCustomFiles);
        this.pluginProperties.setJMeterProperties(this.propertiesJMeter);
        this.pluginProperties.setJMeterGlobalProperties(this.propertiesGlobal);
        this.pluginProperties.setJMeterSaveServiceProperties(this.propertiesSaveService);
        this.pluginProperties.setJMeterUpgradeProperties(this.propertiesUpgrade);
        this.pluginProperties.setJmeterUserProperties(this.propertiesUser);
        this.pluginProperties.setJMeterSystemProperties(this.propertiesSystem);
        this.pluginProperties.configureJMeterPropertiesFiles();
        this.pluginProperties.setDefaultPluginProperties(this.binDir.getAbsolutePath());
    }

    protected void populateJMeterDirectoryTree() throws MojoExecutionException {
        for (Artifact artifact : this.pluginArtifacts) {
            try {
                if ("compile".equals(artifact.getScope()) && this.isArtifactAJMeterDependency(artifact)) {
                    if (artifact.getArtifactId().equals("ApacheJMeter_config")) {
                        JarFile configSettings = new JarFile(artifact.getFile());
                        Enumeration<JarEntry> entries = configSettings.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry jarFileEntry = entries.nextElement();
                            if (jarFileEntry.isDirectory() || !jarFileEntry.getName().startsWith("bin") || jarFileEntry.getName().endsWith(".properties")) continue;
                            FileUtils.copyInputStreamToFile((InputStream)configSettings.getInputStream(jarFileEntry), (File)new File(this.workDir.getCanonicalPath() + File.separator + jarFileEntry.getName()));
                        }
                        configSettings.close();
                        continue;
                    }
                    if (artifact.getArtifactId().startsWith("ApacheJMeter_")) {
                        FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.libExtDir + File.separator + artifact.getFile().getName()));
                        continue;
                    }
                    FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.libDir + File.separator + artifact.getFile().getName()));
                    continue;
                }
                if (!"runtime".equals(artifact.getScope())) continue;
                FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.libExtDir + File.separator + artifact.getFile().getName()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to populate the JMeter directory tree: " + e);
            }
        }
        System.setProperty("java.class.path", "");
    }

    protected boolean isArtifactAJMeterDependency(Artifact artifact) {
        for (String dependency : artifact.getDependencyTrail()) {
            if (!dependency.contains("org.apache.jmeter:ApacheJMeter")) continue;
            return true;
        }
        return false;
    }

    protected Artifact getArtifactNamed(String artifactName) throws MojoExecutionException {
        for (Artifact artifact : this.pluginArtifacts) {
            if (!artifact.getArtifactId().equals(artifactName)) continue;
            return artifact;
        }
        throw new MojoExecutionException("Unable to find artifact '" + artifactName + "'!");
    }

    protected void initialiseJMeterArgumentsArray(boolean disableGUI) throws MojoExecutionException {
        this.testArgs = new JMeterArgumentsArray(disableGUI, this.workDir.getAbsolutePath());
        this.testArgs.setResultsDirectory(this.resultsDir.getAbsolutePath());
        this.testArgs.setResultFileOutputFormatIsCSV(this.resultsOutputIsCSVFormat);
        if (this.testResultsTimestamp) {
            this.testArgs.setResultsTimestamp(this.testResultsTimestamp);
            this.testArgs.appendTimestamp(this.appendResultsTimestamp);
            if (UtilityFunctions.isSet(this.resultsFileNameDateFormat).booleanValue()) {
                try {
                    this.testArgs.setResultsFileNameDateFormat(DateTimeFormat.forPattern((String)this.resultsFileNameDateFormat));
                }
                catch (Exception ex) {
                    this.getLog().error((CharSequence)("'" + this.resultsFileNameDateFormat + "' is an invalid DateTimeFormat.  Defaulting to Standard ISO_8601."));
                }
            }
        }
        this.testArgs.setProxyConfig(this.proxyConfig);
        this.testArgs.setACustomPropertiesFile(this.customPropertiesFile);
        this.testArgs.setLogRootOverride(this.overrideRootLogLevel);
    }

    protected void setJMeterResultFileFormat() {
        if (this.resultsFileFormat.toLowerCase().equals("csv")) {
            this.propertiesJMeter.put("jmeter.save.saveservice.output_format", "csv");
            this.resultsOutputIsCSVFormat = true;
        } else {
            this.propertiesJMeter.put("jmeter.save.saveservice.output_format", "xml");
            this.resultsOutputIsCSVFormat = false;
        }
    }

    protected void waitForTestToFinish(List<String> threadNames) throws InterruptedException {
        Thread waitThread = null;
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        block0: for (Thread thread : threadSet) {
            for (String threadName : threadNames) {
                if (!threadName.equals(thread.getName())) continue;
                waitThread = thread;
                continue block0;
            }
        }
        if (waitThread != null) {
            waitThread.setUncaughtExceptionHandler(new JMeterPluginUncaughtExceptionHandler());
            waitThread.join();
        }
    }

    protected SecurityManager overrideSecurityManager() {
        SecurityManager oldManager = System.getSecurityManager();
        System.setSecurityManager(new JMeterPluginSecurityManager());
        return oldManager;
    }

    protected Thread.UncaughtExceptionHandler overrideUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new JMeterPluginUncaughtExceptionHandler());
        return oldHandler;
    }
}

