/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.assignment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.assignment.Assignment;
import org.mapstruct.ap.internal.model.assignment.AssignmentWrapper;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Strings;

public class WrapperForCollectionsAndMaps
extends AssignmentWrapper {
    private final List<Type> thrownTypesToExclude;
    private final String sourcePresenceChecker;
    private final String localVarName;
    private final Type localVarType;

    public WrapperForCollectionsAndMaps(Assignment decoratedAssignment, List<Type> thrownTypesToExclude, String sourcePresenceChecker, Set<String> existingVariableNames, Type targetType) {
        super(decoratedAssignment);
        this.thrownTypesToExclude = thrownTypesToExclude;
        this.sourcePresenceChecker = sourcePresenceChecker;
        this.localVarType = this.getType() == Assignment.AssignmentType.DIRECT && this.getSourceType() != null ? this.getSourceType() : targetType;
        this.localVarName = Strings.getSaveVariableName(this.localVarType.getName(), existingVariableNames);
        existingVariableNames.add(this.localVarName);
    }

    @Override
    public List<Type> getThrownTypes() {
        List<Type> parentThrownTypes = super.getThrownTypes();
        ArrayList<Type> result = new ArrayList<Type>(parentThrownTypes);
        for (Type thrownTypeToExclude : this.thrownTypesToExclude) {
            for (Type parentThrownType : parentThrownTypes) {
                if (!parentThrownType.isAssignableTo(thrownTypeToExclude)) continue;
                result.remove(parentThrownType);
            }
        }
        return result;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> imported = new HashSet<Type>();
        imported.addAll(super.getImportTypes());
        imported.add(this.localVarType);
        imported.addAll(this.localVarType.getTypeParameters());
        return imported;
    }

    public String getSourcePresenceChecker() {
        return this.sourcePresenceChecker;
    }

    public String getLocalVarName() {
        return this.localVarName;
    }

    public Type getLocalVarType() {
        return this.localVarType;
    }
}

