/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util.workarounds;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.util.workarounds.EclipseClassLoaderBridge;
import org.mapstruct.ap.internal.version.VersionInformation;

public class SpecificCompilerWorkarounds {
    private SpecificCompilerWorkarounds() {
    }

    static boolean isAssignable(Types types, TypeMirror t1, TypeMirror t2) {
        if (t1.getKind() == TypeKind.VOID) {
            return false;
        }
        return types.isAssignable(t1, t2);
    }

    static boolean isSubtype(Types types, TypeMirror t1, TypeMirror t2) {
        if (t1.getKind() == TypeKind.VOID) {
            return false;
        }
        return types.isSubtype(SpecificCompilerWorkarounds.erasure(types, t1), SpecificCompilerWorkarounds.erasure(types, t2));
    }

    static TypeMirror erasure(Types types, TypeMirror t) {
        if (t.getKind() == TypeKind.VOID || t.getKind() == TypeKind.NULL) {
            return t;
        }
        return types.erasure(t);
    }

    public static TypeElement replaceTypeElementIfNecessary(Elements elementUtils, TypeElement element) {
        TypeElement resolvedByName;
        if (element.getEnclosedElements().isEmpty() && (resolvedByName = elementUtils.getTypeElement(element.getQualifiedName())) != null && !resolvedByName.getEnclosedElements().isEmpty()) {
            return resolvedByName;
        }
        return element;
    }

    static TypeMirror asMemberOf(Types typeUtils, ProcessingEnvironment env, VersionInformation versionInformation, DeclaredType containing, Element element) {
        TypeMirror result = null;
        Exception lastException = null;
        try {
            try {
                result = typeUtils.asMemberOf(containing, element);
            }
            catch (IllegalArgumentException e) {
                lastException = e;
                if (versionInformation.isEclipseJDTCompiler()) {
                    result = EclipseClassLoaderBridge.invokeAsMemberOfWorkaround(env, containing, element);
                }
            }
        }
        catch (Exception e) {
            lastException = e;
        }
        if (null == result) {
            throw new RuntimeException("Fallback implementation of asMemberOf didn't work for " + element + " in " + containing, lastException);
        }
        return result;
    }
}

