/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.selector.MethodSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.util.TypeUtils;

abstract class XmlElementDeclSelector
implements MethodSelector {
    private final TypeUtils typeUtils;

    XmlElementDeclSelector(TypeUtils typeUtils) {
        this.typeUtils = typeUtils;
    }

    @Override
    public <T extends Method> List<SelectedMethod<T>> getMatchingMethods(Method mappingMethod, List<SelectedMethod<T>> methods, List<Type> sourceTypes, Type mappingTargetType, Type returnType, SelectionCriteria criteria) {
        ArrayList<SelectedMethod<T>> nameMatches = new ArrayList<SelectedMethod<T>>();
        ArrayList<SelectedMethod<T>> scopeMatches = new ArrayList<SelectedMethod<T>>();
        ArrayList<SelectedMethod<T>> nameAndScopeMatches = new ArrayList<SelectedMethod<T>>();
        XmlElementRefInfo xmlElementRefInfo = this.findXmlElementRef(mappingMethod.getResultType(), criteria.getTargetPropertyName());
        for (SelectedMethod<T> candidate : methods) {
            boolean scopeIsSetAndMatches;
            SourceMethod candidateMethod;
            XmlElementDeclInfo xmlElementDeclInfo;
            if (!(candidate.getMethod() instanceof SourceMethod) || (xmlElementDeclInfo = this.getXmlElementDeclInfo((candidateMethod = (SourceMethod)candidate.getMethod()).getExecutable())) == null) continue;
            String name = xmlElementDeclInfo.nameValue();
            TypeMirror scope = xmlElementDeclInfo.scopeType();
            boolean nameIsSetAndMatches = name != null && name.equals(xmlElementRefInfo.nameValue());
            boolean bl = scopeIsSetAndMatches = scope != null && this.typeUtils.isSameType(scope, xmlElementRefInfo.sourceType());
            if (nameIsSetAndMatches) {
                if (scopeIsSetAndMatches) {
                    nameAndScopeMatches.add(candidate);
                    continue;
                }
                nameMatches.add(candidate);
                continue;
            }
            if (!scopeIsSetAndMatches) continue;
            scopeMatches.add(candidate);
        }
        if (!nameAndScopeMatches.isEmpty()) {
            return nameAndScopeMatches;
        }
        if (!scopeMatches.isEmpty()) {
            return scopeMatches;
        }
        if (!nameMatches.isEmpty()) {
            return nameMatches;
        }
        return methods;
    }

    private XmlElementRefInfo findXmlElementRef(Type resultType, String targetPropertyName) {
        TypeMirror startingMirror = resultType.getTypeMirror();
        XmlElementRefInfo defaultInfo = new XmlElementRefInfo(targetPropertyName, startingMirror);
        if (targetPropertyName == null) {
            return defaultInfo;
        }
        TypeMirror currentMirror = startingMirror;
        TypeElement currentElement = resultType.getTypeElement();
        while (currentElement != null) {
            for (Element element : currentElement.getEnclosedElements()) {
                XmlElementRefInfo xmlElementRefInfo;
                if (!element.getKind().equals((Object)ElementKind.FIELD) || !element.getSimpleName().contentEquals(targetPropertyName) || (xmlElementRefInfo = this.getXmlElementRefInfo(element)) == null) continue;
                return new XmlElementRefInfo(xmlElementRefInfo.nameValue(), currentMirror);
            }
            currentMirror = currentElement.getSuperclass();
            currentElement = (TypeElement)this.typeUtils.asElement(currentMirror);
        }
        return defaultInfo;
    }

    abstract XmlElementDeclInfo getXmlElementDeclInfo(Element var1);

    abstract XmlElementRefInfo getXmlElementRefInfo(Element var1);

    static class XmlElementDeclInfo {
        private final String nameValue;
        private final TypeMirror scopeType;

        XmlElementDeclInfo(String nameValue, TypeMirror scopeType) {
            this.nameValue = nameValue;
            this.scopeType = scopeType;
        }

        String nameValue() {
            return this.nameValue;
        }

        TypeMirror scopeType() {
            return this.scopeType;
        }
    }

    static class XmlElementRefInfo {
        private final String nameValue;
        private final TypeMirror sourceType;

        XmlElementRefInfo(String nameValue, TypeMirror sourceType) {
            this.nameValue = nameValue;
            this.sourceType = sourceType;
        }

        String nameValue() {
            return this.nameValue;
        }

        TypeMirror sourceType() {
            return this.sourceType;
        }
    }
}

