/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.parameters;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class StringParameter
implements Cloneable,
ParameterHolder {
    private final String stringValue;
    private final boolean noBackslashEscapes;

    public StringParameter(String str, boolean noBackslashEscapes) {
        this.stringValue = str;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(this.stringValue, true, this.noBackslashEscapes);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return this.stringValue.length() * 3;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        byte[] bytes = this.stringValue.getBytes(StandardCharsets.UTF_8);
        pos.writeFieldLength(bytes.length);
        pos.write(bytes);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.VARCHAR;
    }

    @Override
    public String toString() {
        if (this.stringValue.length() < 1024) {
            return "'" + this.stringValue + "'";
        }
        return "'" + this.stringValue.substring(0, 1024) + "...'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

