/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation;

import java.awt.geom.Point2D;
import org.mechio.api.animation.PathInterpolator;
import org.mechio.api.animation.compiled.CompiledPath;
import org.mechio.api.interpolation.InterpolatorDirectory;
import org.mechio.api.interpolation.InterpolatorFactory;

public class MotionPath
extends PathInterpolator {
    private CompiledPath myCache = null;
    private String myName = "path";
    private Long myStartTime;
    private Long myStopTime;

    public MotionPath() {
        this(InterpolatorDirectory.instance().getDefaultFactory());
    }

    public MotionPath(InterpolatorFactory factory) {
        super(factory);
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            this.myName = "path";
            return;
        }
        this.myName = name.trim();
    }

    public void setStartTime(Long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("start time must be positive");
        }
        this.myStartTime = time;
    }

    public Long getStartTime() {
        return this.myStartTime;
    }

    public void setStopTime(Long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("start time must be positive");
        }
        this.myStopTime = time;
    }

    public Long getStopTime() {
        return this.myStopTime;
    }

    public CompiledPath getCompiledPath(long stepLength) {
        this.compilePath(stepLength);
        return this.myCache;
    }

    public boolean compilePath(long stepLength) {
        this.interpolate();
        if (this.myCache != null || this.getInterpolatedPoints().isEmpty()) {
            return false;
        }
        int len = this.getInterpolatedPoints().size();
        long start = this.myStartTime != null ? this.myStartTime : (long)this.getInterpolatedPoints().get(0).getX();
        long end = this.myStopTime != null ? this.myStopTime : (long)this.getInterpolatedPoints().get(len - 1).getX();
        this.myCache = this.compilePath(start, end, stepLength);
        return true;
    }

    public CompiledPath compilePath(long start, long end, long stepLength) {
        boolean cached;
        this.interpolate();
        start -= start % stepLength;
        long add = stepLength - end % stepLength;
        add = add == stepLength ? 0L : add;
        boolean bl = cached = this.myCache != null && this.myCache.matches(start, end += add, stepLength);
        if (stepLength < 1L || this.getInterpolatedPoints().isEmpty() || cached) {
            return this.myCache;
        }
        return CompiledPath.compilePath(start, end, this.getInterpolatedPoints(), stepLength);
    }

    public MotionPath clone() {
        MotionPath mp = new MotionPath(this.myFactory);
        for (Point2D p : this.getControlPoints()) {
            mp.addPoint(p.getX(), p.getY());
        }
        mp.myName = this.myName;
        mp.myStartTime = this.myStartTime;
        mp.myStopTime = this.myStopTime;
        if (this.myCache != null) {
            mp.myCache = this.myCache.clone();
        }
        return mp;
    }

    @Override
    protected boolean interpolate() {
        if (super.interpolate()) {
            this.myCache = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MotionPath other = (MotionPath)obj;
        if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
            return false;
        }
        if (!(this.myStartTime == other.myStartTime || this.myStartTime != null && this.myStartTime.equals(other.myStartTime))) {
            return false;
        }
        if (!(this.myStopTime == other.myStopTime || this.myStopTime != null && this.myStopTime.equals(other.myStopTime))) {
            return false;
        }
        if (!(this.myXVals == other.myXVals || this.myXVals != null && this.myXVals.equals(other.myXVals))) {
            return false;
        }
        return this.getControlPoints() == other.getControlPoints() || this.getControlPoints() != null && this.getControlPoints().equals(other.getControlPoints());
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (this.myName != null ? this.myName.hashCode() : 0);
        hash = 17 * hash + (this.myStartTime != null ? this.myStartTime.hashCode() : 0);
        hash = 17 * hash + (this.myStopTime != null ? this.myStopTime.hashCode() : 0);
        hash = 17 * hash + (this.myXVals != null ? this.myXVals.hashCode() : 0);
        return hash;
    }
}

