/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.compiled;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.mechio.api.animation.compiled.CompiledPath;

public class CompiledMap
extends HashMap<Integer, CompiledPath> {
    private long myStartTime;
    private long myEndTime;
    private long myStepLength;

    public CompiledMap(long stepLen) {
        this.myStepLength = stepLen;
        this.myEndTime = -1L;
    }

    public CompiledMap(long stepLen, long start, long end) {
        this.myStepLength = stepLen;
        this.myStartTime = start;
        this.myEndTime = end;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    public long getEndTime() {
        if (this.myEndTime != -1L) {
            return this.myEndTime;
        }
        long end = this.myStartTime;
        for (CompiledPath path : this.values()) {
            long pathEnd = path.getEndTime();
            if (pathEnd <= end) continue;
            end = pathEnd;
        }
        return end;
    }

    @Override
    public CompiledPath put(Integer key, CompiledPath value) throws IllegalArgumentException {
        if (key == null || value == null) {
            throw new IllegalArgumentException("CompiledMap does not permit null keys or values.");
        }
        if (this.myStepLength != value.getStepLength()) {
            throw new IllegalArgumentException("Cannot combine CompiledPaths with different step lengths.");
        }
        if (this.containsKey(key)) {
            value = CompiledPath.combine(Arrays.asList((CompiledPath)this.get(key), value));
        }
        CompiledPath p = super.put(key, value);
        return p;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends CompiledPath> m) throws IllegalArgumentException {
        if (m.containsKey(null) || m.containsValue(null)) {
            throw new IllegalArgumentException("CompiledMap does not permit null keys or values");
        }
        for (Map.Entry<? extends Integer, ? extends CompiledPath> e : m.entrySet()) {
            if (e.getValue().getStepLength() != this.myStepLength) {
                throw new IllegalArgumentException("Cannot combine CompiledPaths with different step lengths.");
            }
            if (!this.containsKey(e.getKey())) continue;
            CompiledPath cp = CompiledPath.combine(Arrays.asList((CompiledPath)this.get(e.getKey()), e.getValue()));
            e.setValue(cp);
        }
        super.putAll(m);
        this.normalizePaths();
    }

    private void normalizePaths() {
        long start = this.myStartTime == -1L ? 0L : this.myStartTime;
        long end = this.myEndTime == -1L ? Long.MIN_VALUE : this.myEndTime;
        for (CompiledPath p : this.values()) {
            if (this.myEndTime != -1L || p.getEndTime() <= end) continue;
            end = p.getEndTime();
        }
        this.setTimes(start, end, true);
    }

    public void setTimes(long start, long end, boolean normalizeTimes) {
        if (normalizeTimes) {
            start -= start % this.myStepLength;
            long add = this.myStepLength - end % this.myStepLength;
            add = add == this.myStepLength ? 0L : add;
            end += add;
        }
        for (Map.Entry entry : this.entrySet()) {
            CompiledPath p = ((CompiledPath)entry.getValue()).setTimes(start, end);
            if (p.equals(entry.getValue())) continue;
            entry.setValue(p);
        }
        this.myStartTime = start;
        this.myEndTime = end;
    }

    @Override
    public Object clone() {
        CompiledMap map = new CompiledMap(this.myStepLength, this.myStartTime, this.myEndTime);
        for (Map.Entry e : this.entrySet()) {
            CompiledPath p = (CompiledPath)e.getValue();
            map.put((Integer)e.getKey(), p.clone());
        }
        return map;
    }
}

